      subroutine startscf(nindpndnt,nreal,ninteger,nmaxorbs,nmaxaux,
     &                    nmaxpoints,natoms,nptcharges,nconts,ncontp,
     &                    ncontd,ncds,ncdspd,nxcs,nxcspd,irandomgrid,
     &                    igridtype,iwkvec,nshels,nshelp,nsheld,ilfunc,
     &                    icfunc,ngaussians,matloca,icdlfunc,icdcfunc,
     &                    ixclfunc,ixccfunc,natomtype,nptsatom,energy,
     &                    rhochange,diiserror,wkvec,core,focka,fockb,
     &                    focke,overlap,saux,coord,coordptcharges,
     &                    charge,ptcharge,alpha,coeff,alphacd,coefscd,
     &                    coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,
     &                    coefdxc,cdcoef,xcoefa,xcoefb,xcoefe)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iwkvec(*),nshels(*),nshelp(*),nsheld(*),ilfunc(*),
     &          icfunc(*),ngaussians(*),matloca(*),icdlfunc(*),
     &          icdcfunc(*),ixclfunc(*),ixccfunc(*),natomtype(*),
     &          nptsatom(*)

      dimension wkvec(*),core(*),focka(*),fockb(*),focke(*),
     &          overlap(nmaxorbs,*),saux(nmaxaux,*),coord(3,*),
     &          coordptcharges(3,*),charge(*),ptcharge(*),
     &          alpha(*),coeff(*),alphacd(*),coefscd(*),coefpcd(*),
     &          coefdcd(*),alphaxc(*),coefsxc(*),coefpxc(*),coefdxc(*),
     &          cdcoef(*),xcoefa(*),xcoefb(*),xcoefe(*)

      data zero/0.0/

      ncontractions=nconts+3*ncontp+6*ncontd

      ndim=ncontractions*(ncontractions+1)/2

      energy=zero
      rhochange=zero
      diiserror=zero

      ja=1
      jb=ja+(natoms+nptcharges)*3
      jc=jb+(natoms+nptcharges)
      jd=jc+ndim
      je=jd+ndim

      call fockmm(nreal-je,ninteger,natoms,nptcharges,nconts,ncontp,
     &            ncontd,ncds,ncdspd,nxcs,nxcspd,nshels,nshelp,nsheld,
     &            matloca,ilfunc,ngaussians,icfunc,icdlfunc,icdcfunc,
     &            ixclfunc,ixccfunc,iwkvec,wkvec(ja),coord,
     &            coordptcharges,wkvec(jb),charge,ptcharge,alpha,
     &            coeff,cdcoef,xcoefa,xcoefb,xcoefe,alphacd,coefscd,
     &            coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,coefdxc,
     &            wkvec(jc),core,wkvec(jd),focka,fockb,focke,wkvec(je))

      do 1001 i=1,ncontractions
      do 1001 j=1,i
 1001 overlap(i,j)=wkvec(jc+(i*(i-1)/2)+j-1)

      ja=1
      jb=ja+ncontractions*ncontractions
      jc=jb+ncontractions*ncontractions
      jd=jc+ncontractions
      je=jd+ncontractions
      jf=je+ncontractions

      if((jf+ncontractions).gt.nreal) stop 'startscf'

      call sinvmt(wkvec(ja),wkvec(jb),wkvec(jc),wkvec(jd),wkvec(je),
     &            wkvec(jf),overlap,nmaxorbs,ncontractions,nindpndnt)

      call cdcalls(nreal,ncds,ncdspd,nmaxaux,icdlfunc,icdcfunc,alphacd,
     &             coefscd,coefpcd,coefdcd,saux,coord,wkvec)

      call gengrid(nreal,nmaxpoints,igridtype,1,irandomgrid,natoms,
     &             nconts,ncontp,ncontd,ilfunc,icfunc,ngaussians,nshels,
     &             nshelp,nsheld,natomtype,nptsatom,coord,alpha,coeff,
     &             wkvec)

      return
      end
