      subroutine setupgdd(m,n,ncontd,nsheld,mtloca,iprimvc,nprimvc,
     &                    icentvc,iminj,icontr,inddyy,icentr,coord,
     &                    alpha,coeff,zeta,zetaa,zetab,twozetaa,
     &                    twozetab,aax,aay,aaz,eta,eta2,etarr,base,px,
     &                    py,pz,pxax,pyay,pzaz,pxbx,pyby,pzbz,axbx,ayby,
     &                    azbz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension nsheld(*),mtloca(*),iprimvc(*),nprimvc(*),icentvc(*),
     &          iminj(*),icontr(*),inddyy(m,*),icentr(m,*)

      dimension coord(3,*),alpha(*),coeff(*),zeta(*),zetaa(*),zetab(*),
     &          twozetaa(*),twozetab(*),aax(*),aay(*),aaz(*),eta(*),
     &          eta2(*),etarr(*),base(*),px(*),py(*),pz(*),pxax(*),
     &          pyay(*),pzaz(*),pxbx(*),pyby(*),pzbz(*),axbx(*),ayby(*),
     &          azbz(*)

      data zero,two,expcut/0.0,2.0,100.0/

      icnptr=0

      n=0

      do 1001 i=1,ncontd
      do 1001 j=1,i

      icnptr=icnptr+1

      iminj(icnptr)=i-j

      nconta=nsheld(i)
      ncontb=nsheld(j)

      matlca=mtloca(nconta)
      matlcb=mtloca(ncontb)

      i1=matlca
      i2=(i1*(i1-1))/2
      i3=matlcb
      i4=i2+i3

      inddyy(icnptr,01)=i4
      inddyy(icnptr,02)=i4+1
      inddyy(icnptr,03)=i4+2
      inddyy(icnptr,04)=i4+3
      inddyy(icnptr,05)=i4+4
      inddyy(icnptr,06)=i4+5
      inddyy(icnptr,07)=i4+i1
      inddyy(icnptr,08)=i4+i1+1
      inddyy(icnptr,09)=i4+i1+2
      inddyy(icnptr,10)=i4+i1+3
      inddyy(icnptr,11)=i4+i1+4
      inddyy(icnptr,12)=i4+i1+5
      inddyy(icnptr,13)=i4+i1*2+1
      inddyy(icnptr,14)=i4+i1*2+2
      inddyy(icnptr,15)=i4+i1*2+3
      inddyy(icnptr,16)=i4+i1*2+4
      inddyy(icnptr,17)=i4+i1*2+5
      inddyy(icnptr,18)=i4+i1*2+6
      inddyy(icnptr,19)=i4+i1*3+3
      inddyy(icnptr,20)=i4+i1*3+4
      inddyy(icnptr,21)=i4+i1*3+5
      inddyy(icnptr,22)=i4+i1*3+6
      inddyy(icnptr,23)=i4+i1*3+7
      inddyy(icnptr,24)=i4+i1*3+8
      inddyy(icnptr,25)=i4+i1*4+6
      inddyy(icnptr,26)=i4+i1*4+7
      inddyy(icnptr,27)=i4+i1*4+8
      inddyy(icnptr,28)=i4+i1*4+9
      inddyy(icnptr,29)=i4+i1*4+10
      inddyy(icnptr,30)=i4+i1*4+11
      inddyy(icnptr,31)=i4+i1*5+10
      inddyy(icnptr,32)=i4+i1*5+11
      inddyy(icnptr,33)=i4+i1*5+12
      inddyy(icnptr,34)=i4+i1*5+13
      inddyy(icnptr,35)=i4+i1*5+14
      inddyy(icnptr,36)=i4+i1*5+15

      iprima=iprimvc(nconta)
      iprimb=iprimvc(ncontb)

      nprima=iprima+nprimvc(nconta)-1
      nprimb=iprimb+nprimvc(ncontb)-1

      icenta=icentvc(nconta)
      icentb=icentvc(ncontb)

      icentr(icnptr,1)=icenta
      icentr(icnptr,2)=icentb

      ax=coord(1,icenta)
      ay=coord(2,icenta)
      az=coord(3,icenta)

      bx=coord(1,icentb)
      by=coord(2,icentb)
      bz=coord(3,icentb)

      caxbx=ax-bx
      cayby=ay-by
      cazbz=az-bz

      axbx(icnptr)=caxbx
      ayby(icnptr)=cayby
      azbz(icnptr)=cazbz

      rr=caxbx*caxbx+cayby*cayby+cazbz*cazbz

      do 1001 ii=iprima,nprima
      do 1001 jj=iprimb,nprimb

      n=n+1

      icontr(n)=icnptr

      zetaa(n)=alpha(ii)
      zetab(n)=alpha(jj)

      zeta(n)=zetaa(n)+zetab(n)

      twozetaa(n)=two*zetaa(n)
      twozetab(n)=two*zetab(n)

      factor=coeff(ii)*coeff(jj)

      aax(n)=ax
      aay(n)=ay
      aaz(n)=az

      px(n)=(zetaa(n)*ax+zetab(n)*bx)/zeta(n)
      py(n)=(zetaa(n)*ay+zetab(n)*by)/zeta(n)
      pz(n)=(zetaa(n)*az+zetab(n)*bz)/zeta(n)

      pxax(n)=px(n)-ax
      pyay(n)=py(n)-ay
      pzaz(n)=pz(n)-az

      pxbx(n)=px(n)-bx
      pyby(n)=py(n)-by
      pzbz(n)=pz(n)-bz

      eta(n)=zetaa(n)*zetab(n)/zeta(n)

      eta2(n)=two*eta(n)

      etarr(n)=eta(n)*rr

      base(n)=zero
      if(etarr(n).lt.expcut) then
                                   base(n)=factor*exp(-etarr(n))
                             else
                                   n=n-1
                             endif

 1001 continue

      return
      end
