      subroutine move(iswitch,igeometry,ihess,nreal,ninteger,nmaxpoints,
     &                ndim1,ndim2,ndim3,nmodes,natoms,nalpha,nbeta,
     &                ncontractions,nconts,ncontp,ncontd,ncds,ncdspd,
     &                nintfreeze,natomtype,nptsatom,nfuncatom,izmat1,
     &                izmat2,izmat3,nshels,nshelp,nsheld,ilfunc,icfunc,
     &                ngaussians,mtloca,icdlfunc,icdcfunc,iwkvec,
     &                dmaxfactor,stepsize,coordsave,coord,charge,dmata,
     &                dmatb,coeffa,coeffb,orbnrga,orbnrgb,alpha,coeffs,
     &                cdfitc,alphacd,coefscd,coefpcd,coefdcd,gradsave,
     &                grad,coord1,coord2,grad1,grad2,hessian,overlap,
     &                djacobian,wkvec,lsym)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension nintfreeze(*),natomtype(*),nptsatom(*),nfuncatom(*),
     &          izmat1(*),izmat2(*),izmat3(*),nshels(*),nshelp(*),
     &          nsheld(*),ilfunc(*),icfunc(*),ngaussians(*),mtloca(*),
     &          icdlfunc(*),icdcfunc(*),iwkvec(*)

      dimension coordsave(3,*),coord(3,*),charge(*),dmata(*),dmatb(*),
     &          coeffa(ndim1,*),coeffb(ndim1,*),orbnrga(*),orbnrgb(*),
     &          alpha(*),coeffs(*),cdfitc(*),alphacd(*),coefscd(*),
     &          coefpcd(*),coefdcd(*),gradsave(3,*),grad(3,*),coord1(*),
     &          coord2(*),grad1(*),grad2(*),hessian(ndim3,*),
     &          overlap(ndim2,*),djacobian(nmodes,*),wkvec(*)

      character*4 lsym(*)

      data zero,bohr/0.0,0.529177/

      ndim=ncontractions*(ncontractions+1)/2

      call gradmm(nreal,ninteger,ndim2,natoms,nconts,ncontp,ncontd,ncds,
     &            ncdspd,nshels,nshelp,nsheld,mtloca,ilfunc,ngaussians,
     &            icfunc,icdlfunc,icdcfunc,iwkvec,coord,charge,alpha,
     &            coeffs,cdfitc,alphacd,coefscd,coefpcd,coefdcd,grad,
     &            overlap,dmata,dmatb,wkvec(1),wkvec(ndim+1))

      call cdgrmm(ncds,ncdspd,icdlfunc,icdcfunc,cdfitc,alphacd,coefscd,
     &            coefpcd,coefdcd,coord,grad)

      call gradxc(nreal,nmaxpoints,ncontractions,natoms,nconts,ncontp,
     &            ncontd,natomtype,nptsatom,nfuncatom,ilfunc,icfunc,
     &            ngaussians,nshels,nshelp,nsheld,wkvec,dmata,dmatb,
     &            coord,grad,alpha,coeffs)

      call pulayforce(ndim1,ndim2,nalpha,nbeta,nconts,ncontp,ncontd,
     &                icfunc,mtloca,nshels,nshelp,nsheld,grad,wkvec,
     &                overlap,coeffa,coeffb,orbnrga,orbnrgb)

      if(natoms.eq.2) grad(2,1)=zero
      if(natoms.eq.2) grad(3,1)=zero
      if(natoms.eq.2) grad(2,2)=zero
      if(natoms.eq.2) grad(3,2)=zero

      if(ihess.gt.2) call intopt(nmodes,natoms,izmat1,izmat2,izmat3,
     &                           coord,djacobian,wkvec)

      call rotinv(natoms,nmodes,coord,grad)

      if(iswitch.eq.1) return

      gradsum=zero
      do 1001 i=1,natoms
      do 1001 j=1,3
 1001 gradsum=gradsum+abs(grad(j,i))

      if(ihess.le.2) call gcardr(igeometry,ihess,ndim3,natoms,coordsave,
     &                           coord,gradsave,grad,hessian,wkvec(1),
     &                           wkvec(9*natoms*natoms+1))

      if(ihess.gt.2) call gintdr(igeometry,1,nreal,ndim3,natoms,nmodes,
     &                           ihess,izmat1,izmat2,izmat3,wkvec,grad1,
     &                           grad2,coord1,coord2,coordsave,coord,
     &                           gradsave,grad,hessian,djacobian,
     &                           nintfreeze)

      dmaxgc=zero
      do 1002 i=1,natoms
      do 1002 j=1,3
 1002 if(abs(grad(j,i)).gt.dmaxgc) dmaxgc=abs(grad(j,i))

      do 1003 i=1,nmodes
 1003 if(nintfreeze(i).eq.1) grad2(i)=zero

      if(ihess.gt.2) then
                           dmaxgc=zero
                           do 1004 i=1,nmodes
                           check=abs(grad2(i))
 1004                      if(check.gt.dmaxgc) dmaxgc=check

                           gradsum=zero
                           do 1005 i=1,nmodes
 1005                      gradsum=gradsum+abs(grad2(i))
                     endif

      write(6,1006)
 1006 format(' gradient :',/)

      if(ihess.le.2) then
                           do 1007 i=1,natoms
 1007                      write(6,1008) lsym(i),grad(1,i)/bohr,
     &                                           grad(2,i)/bohr,
     &                                           grad(3,i)/bohr
 1008                      format(5x,a4,2x,3f12.7)
                     else
                           do 1009 i=1,natoms
                           if(i.eq.1) write(6,1010) lsym(i)
                           if(i.eq.2) write(6,1010) lsym(i),izmat1(i),
     &                                                      grad2(1)
                           if(i.eq.3) write(6,1010) lsym(i),izmat1(i),
     &                                                      grad2(2),
     &                                                      izmat2(i),
     &                                                      grad2(3)
                           if(i.gt.3) write(6,1010) lsym(i),
     &                                              izmat1(i),
     &                                              grad2(3*(i-3)+1),
     &                                              izmat2(i),
     &                                              grad2(3*(i-3)+2),
     &                                              izmat3(i),
     &                                              grad2(3*(i-3)+3)
 1009                      continue
                     endif

 1010 format(5x,a4,5x,i4,f12.7,5x,i4,f12.7,5x,i4,f12.7)

      if(ihess.le.2) then
                           print1=gradsum/bohr/real64(natoms)
                           print2=dmaxgc/bohr

                           write(6,1011) print1,print2
 1011                      format(/,'   | gradient |    = ',e14.7,
     &                              ' hartree/angstrom/atom',/,
     &                              ' maximum component = ',e14.7,
     &                              ' hartree/angstrom',/)
                     else
                           print1=gradsum/real64(nmodes)
                           print2=dmaxgc

                           write(6,1012) print1,print2
 1012                      format(/,'   | gradient |    = ',e14.7,/,
     &                              ' maximum component = ',e14.7,/)
                     endif

      dmaxdc=zero
      do 1013 i=1,natoms
      do 1013 j=1,3
      check=abs(coord(j,i)-coordsave(j,i))
 1013 if(check.gt.dmaxdc) dmaxdc=check

      davgdc=zero
      do 1014 i=1,natoms
      do 1014 j=1,3
 1014 davgdc=davgdc+abs(coord(j,i)-coordsave(j,i))/real64(natoms)

      scaling=min(davgdc,stepsize)/davgdc

      do 1015 i=1,natoms
      do 1015 j=1,3
 1015 coord(j,i)=coordsave(j,i)+scaling*(coord(j,i)-coordsave(j,i))

      print3=bohr*min(davgdc,stepsize)/real64(natoms)
      print4=bohr*dmaxdc

      write(6,1016) print3,print4
 1016 format(' | displacement |  = ',e14.7,' angstrom/atom',/,
     &       ' maximum component = ',e14.7,' angstrom',/)

      dmaxfactor=max(print1,print2,print3,print4)

      return
      end
