      subroutine mespdp(m,n,icontr,inddyy,esp,ccx,ccy,ccz,g,density,
     &                  zeta,axbx,ayby,azbz,px,py,pz,pxax,pyay,pzaz,
     &                  base,ss0,ss1,ss2,ss3,ps0,ps1,ps2,dscond,ds0,ds1,
     &                  fscond,fs0,dpcond,c,c1,pxcx,pycy,pzcz,u,twozeta)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension icontr(*),inddyy(m,*)

      dimension g(*),density(*),zeta(*),axbx(*),ayby(*),azbz(*),px(*),
     &          py(*),pz(*),pxax(*),pyay(*),pzaz(*),base(*),ss0(*),
     &          ss1(*),ss2(*),ss3(*),ps0(n,*),ps1(n,*),ps2(n,*),
     &          dscond(m,*),ds0(n,*),ds1(n,*),fscond(m,*),fs0(n,*),
     &          dpcond(m,*),c(*),c1(n,*),pxcx(*),pycy(*),pzcz(*),u(*),
     &          twozeta(*)

      data zero,two,three,pi/0.0,2.0,3.0,3.1415926535898/

      do 1001 i=1,n
 1001 twozeta(i)=two*zeta(i)

      twopi=two*pi

      do 1002 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 1002 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      do 1003 i=1,n
      call augg(4,u(i),g)
      ss0(i)=base(i)*g(1)*twopi/zeta(i)
      ss1(i)=base(i)*g(2)*twopi/zeta(i)
      ss2(i)=base(i)*g(3)*twopi/zeta(i)
 1003 ss3(i)=base(i)*g(4)*twopi/zeta(i)

      do 1004 i=1,n

      ps0(i,1)=pxax(i)*ss0(i)-pxcx(i)*ss1(i)
      ps0(i,2)=pyay(i)*ss0(i)-pycy(i)*ss1(i)
      ps0(i,3)=pzaz(i)*ss0(i)-pzcz(i)*ss1(i)

      ps1(i,1)=pxax(i)*ss1(i)-pxcx(i)*ss2(i)
      ps1(i,2)=pyay(i)*ss1(i)-pycy(i)*ss2(i)
      ps1(i,3)=pzaz(i)*ss1(i)-pzcz(i)*ss2(i)

      ps2(i,1)=pxax(i)*ss2(i)-pxcx(i)*ss3(i)
      ps2(i,2)=pyay(i)*ss2(i)-pycy(i)*ss3(i)
      ps2(i,3)=pzaz(i)*ss2(i)-pzcz(i)*ss3(i)

 1004 continue

      do 1005 i=1,n
 1005 c(i)=(ss0(i)-ss1(i))/twozeta(i)

      do 1006 i=1,n
      ds0(i,1)=pxax(i)*ps0(i,1)-pxcx(i)*ps1(i,1)+c(i)
      ds0(i,2)=pyay(i)*ps0(i,1)-pycy(i)*ps1(i,1)
      ds0(i,3)=pzaz(i)*ps0(i,1)-pzcz(i)*ps1(i,1)
      ds0(i,4)=pyay(i)*ps0(i,2)-pycy(i)*ps1(i,2)+c(i)
      ds0(i,5)=pzaz(i)*ps0(i,2)-pzcz(i)*ps1(i,2)
 1006 ds0(i,6)=pzaz(i)*ps0(i,3)-pzcz(i)*ps1(i,3)+c(i)

      do 1007 i=1,n
 1007 c(i)=(ss1(i)-ss2(i))/twozeta(i)

      do 1008 i=1,n
      ds1(i,1)=pxax(i)*ps1(i,1)-pxcx(i)*ps2(i,1)+c(i)
      ds1(i,2)=pyay(i)*ps1(i,1)-pycy(i)*ps2(i,1)
      ds1(i,3)=pzaz(i)*ps1(i,1)-pzcz(i)*ps2(i,1)
      ds1(i,4)=pyay(i)*ps1(i,2)-pycy(i)*ps2(i,2)+c(i)
      ds1(i,5)=pzaz(i)*ps1(i,2)-pzcz(i)*ps2(i,2)
 1008 ds1(i,6)=pzaz(i)*ps1(i,3)-pzcz(i)*ps2(i,3)+c(i)

      do 1009 j=1,3
      do 1009 i=1,n
 1009 c1(i,j)=(ps0(i,j)-ps1(i,j))/twozeta(i)

      do 1010 i=1,n
      fs0(i,01)=pxax(i)*ds0(i,1)-pxcx(i)*ds1(i,1)+c1(i,1)*two
      fs0(i,02)=pyay(i)*ds0(i,1)-pycy(i)*ds1(i,1)
      fs0(i,03)=pzaz(i)*ds0(i,1)-pzcz(i)*ds1(i,1)
      fs0(i,04)=pyay(i)*ds0(i,2)-pycy(i)*ds1(i,2)+c1(i,1)
      fs0(i,05)=pzaz(i)*ds0(i,2)-pzcz(i)*ds1(i,2)
      fs0(i,06)=pzaz(i)*ds0(i,3)-pzcz(i)*ds1(i,3)+c1(i,1)
      fs0(i,07)=pyay(i)*ds0(i,4)-pycy(i)*ds1(i,4)+c1(i,2)*two
      fs0(i,08)=pzaz(i)*ds0(i,4)-pzcz(i)*ds1(i,4)
      fs0(i,09)=pzaz(i)*ds0(i,5)-pzcz(i)*ds1(i,5)+c1(i,2)
 1010 fs0(i,10)=pzaz(i)*ds0(i,6)-pzcz(i)*ds1(i,6)+c1(i,3)*two

      do 1011 j=1,6
      do 1011 i=1,m
 1011 dscond(i,j)=zero

      do 1012 j=1,10
      do 1012 i=1,m
 1012 fscond(i,j)=zero

      do 1013 j=1,6
      do 1013 i=1,n
 1013 dscond(icontr(i),j)=dscond(icontr(i),j)+ds0(i,j)

      do 1014 j=1,10
      do 1014 i=1,n
 1014 fscond(icontr(i),j)=fscond(icontr(i),j)+fs0(i,j)

      do 1015 i=1,m
      dpcond(i,01)=axbx(i)*dscond(i,1)+fscond(i,01)
      dpcond(i,02)=ayby(i)*dscond(i,1)+fscond(i,02)
      dpcond(i,03)=azbz(i)*dscond(i,1)+fscond(i,03)
      dpcond(i,04)=axbx(i)*dscond(i,2)+fscond(i,02)
      dpcond(i,05)=ayby(i)*dscond(i,2)+fscond(i,04)
      dpcond(i,06)=azbz(i)*dscond(i,2)+fscond(i,05)
      dpcond(i,07)=axbx(i)*dscond(i,3)+fscond(i,03)
      dpcond(i,08)=ayby(i)*dscond(i,3)+fscond(i,05)
      dpcond(i,09)=azbz(i)*dscond(i,3)+fscond(i,06)
      dpcond(i,10)=axbx(i)*dscond(i,4)+fscond(i,04)
      dpcond(i,11)=ayby(i)*dscond(i,4)+fscond(i,07)
      dpcond(i,12)=azbz(i)*dscond(i,4)+fscond(i,08)
      dpcond(i,13)=axbx(i)*dscond(i,5)+fscond(i,05)
      dpcond(i,14)=ayby(i)*dscond(i,5)+fscond(i,08)
      dpcond(i,15)=azbz(i)*dscond(i,5)+fscond(i,09)
      dpcond(i,16)=axbx(i)*dscond(i,6)+fscond(i,06)
      dpcond(i,17)=ayby(i)*dscond(i,6)+fscond(i,09)
 1015 dpcond(i,18)=azbz(i)*dscond(i,6)+fscond(i,10)

      do 1016 j=1,18
      do 1016 i=1,m
 1016 esp=esp-density(inddyy(i,j))*dpcond(i,j)

      return
      end
