      subroutine gridwork(iswitch,iteration,nfunctional,nauxfunctions,
     &                    npoints,naos,nmos,ncontractions,ncenters,
     &                    nalpha,nbeta,nconts,ncontp,ncontd,
     &                    nxcfunctions,nxcs,nxcspd,natomtype,nptsatom,
     &                    nshels,nshelp,nsheld,ilfunc,icfunc,ngaussians,
     &                    ixclfunc,ixccfunc,iwkvec,coord,alpha,coeff,
     &                    alphaxc,coefsxc,coefpxc,coefdxc,tveca,tvecb,
     &                    tvece,auxoverlap,coeffa,coeffb,fv,fa,fb,dnsty,
     &                    xcpot,xcnrg,weight,gradx,grady,gradz,hssxx,
     &                    hssxy,hssxz,hssyy,hssyz,hsszz,xcoord,ycoord,
     &                    zpoint,wpoint,wkvec,fvx,fvy,fvz,fvxx,fvxy,
     &                    fvxz,fvyy,fvyz,fvzz,fx,fy,fz,fxx)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          ilfunc(*),icfunc(*),ngaussians(*),ixclfunc(*),
     &          ixccfunc(*),iwkvec(*)

      dimension coord(3,*),alpha(*),coeff(*),alphaxc(*),coefsxc(*),
     &          coefpxc(*),coefdxc(*),tveca(*),tvecb(*),tvece(*),
     &          auxoverlap(nauxfunctions,*),coeffa(ncontractions,*),
     &          coeffb(ncontractions,*),fv(npoints,*),fa(nmos,*),
     &          fb(nmos,*),dnsty(npoints,*),xcpot(npoints,*),xcnrg(*),
     &          weight(*),gradx(npoints,*),grady(npoints,*),
     &          gradz(npoints,*),hssxx(npoints,*),hssxy(npoints,*),
     &          hssxz(npoints,*),hssyy(npoints,*),hssyz(npoints,*),
     &          hsszz(npoints,*),xcoord(*),ycoord(*),zpoint(*),
     &          wpoint(*),wkvec(*),fvx(npoints,*),fvy(npoints,*),
     &          fvz(npoints,*),fvxx(npoints,*),fvxy(npoints,*),
     &          fvxz(npoints,*),fvyy(npoints,*),fvyz(npoints,*),
     &          fvzz(npoints,*),fx(nmos,*),fy(nmos,*),fz(nmos,*),
     &          fxx(nmos,*)

      data zero,two/0.0,2.0/

      nsavefunctional=nfunctional

      if(iswitch.eq.0) then
                             if(nsavefunctional.eq.2) nfunctional=1
                       else
                             if(nsavefunctional.eq.2) nfunctional=0
                       endif

      rewind 11
      rewind 12

      if(iteration.eq.1) then
                               do 1001 i=1,nxcfunctions
                               do 1001 j=1,nxcfunctions
 1001                          auxoverlap(j,i)=zero
                         endif

      do 1002 i=1,nxcfunctions
      tveca(i)=zero
      tvecb(i)=zero
 1002 tvece(i)=zero

      do 1003 iatom=1,ncenters

      if(natomtype(iatom).eq.0) goto 1003

      call fastrd(11,xcoord,nptsatom(iatom))
      call fastrd(11,ycoord,nptsatom(iatom))
      call fastrd(11,zpoint,nptsatom(iatom))
      call fastrd(11,wpoint,nptsatom(iatom))

      do 1004 ia=1,nptsatom(iatom),npoints

      ib=min(ia+npoints-1,nptsatom(iatom))

      do 1005 i=ia,ib
 1005 weight(i-ia+1)=wpoint(i)

      npts=ib-ia+1

      if(nfunctional.eq.0) then

          call compg0(ncontractions,npts,npoints,nconts,ncontp,ncontd,
     &                ilfunc,icfunc,ngaussians,nshels,nshelp,nsheld,
     &                coord,alpha,coeff,xcoord(ia),ycoord(ia),
     &                zpoint(ia),fv,wkvec(00*npoints+1),
     &                wkvec(01*npoints+1),wkvec(02*npoints+1),
     &                wkvec(03*npoints+1),wkvec(04*npoints+1),
     &                wkvec(05*npoints+1),wkvec(06*npoints+1),
     &                wkvec(07*npoints+1),wkvec(08*npoints+1),
     &                wkvec(09*npoints+1),wkvec(10*npoints+1),
     &                wkvec(11*npoints+1))

                           endif

      if(nfunctional.eq.1) then

          call compg2(ncontractions,npts,npoints,nconts,ncontp,ncontd,
     &                ilfunc,icfunc,ngaussians,nshels,nshelp,nsheld,
     &                iwkvec,coord,alpha,coeff,xcoord(ia),ycoord(ia),
     &                zpoint(ia),fv,fvx,fvy,fvz,fvxx,fvxy,fvxz,fvyy,
     &                fvyz,fvzz,wkvec(00*npoints+1),wkvec(01*npoints+1),
     &                wkvec(02*npoints+1),wkvec(03*npoints+1),
     &                wkvec(04*npoints+1),wkvec(05*npoints+1),
     &                wkvec(06*npoints+1),wkvec(07*npoints+1),
     &                wkvec(08*npoints+1),wkvec(09*npoints+1),
     &                wkvec(10*npoints+1),wkvec(11*npoints+1),
     &                wkvec(12*npoints+1),wkvec(13*npoints+1),
     &                wkvec(14*npoints+1),wkvec(15*npoints+1),
     &                wkvec(16*npoints+1),wkvec(17*npoints+1),
     &                wkvec(18*npoints+1),wkvec(19*npoints+1),
     &                wkvec(20*npoints+1),wkvec(21*npoints+1),
     &                wkvec(22*npoints+1),wkvec(23*npoints+1),
     &                wkvec(24*npoints+1),wkvec(25*npoints+1),
     &                wkvec(26*npoints+1),wkvec(27*npoints+1),
     &                wkvec(28*npoints+1),wkvec(29*npoints+1),
     &                wkvec(30*npoints+1),wkvec(31*npoints+1),
     &                wkvec(32*npoints+1),wkvec(33*npoints+1),
     &                wkvec(34*npoints+1),wkvec(35*npoints+1),
     &                wkvec(36*npoints+1),wkvec(37*npoints+1),
     &                wkvec(38*npoints+1),wkvec(39*npoints+1),
     &                wkvec(40*npoints+1),wkvec(41*npoints+1),
     &                wkvec(42*npoints+1),wkvec(43*npoints+1),
     &                wkvec(49*npoints+1),wkvec(55*npoints+1),
     &                wkvec(61*npoints+1),wkvec(67*npoints+1),
     &                wkvec(73*npoints+1),wkvec(79*npoints+1),
     &                wkvec(85*npoints+1),wkvec(91*npoints+1),
     &                wkvec(97*npoints+1))

                           endif

      call smxmy(fv,npoints,coeffa,ncontractions,fa,nmos,npts,nalpha)

      do 1006 i=1,npts
 1006 dnsty(i,1)=selfdot(nalpha,fa(1,i))

      if(nalpha.eq.nbeta) then
                                do 1007 i=1,npts
 1007                           dnsty(i,2)=dnsty(i,1)
                          endif

      if(nalpha.eq.nbeta) goto 1008

      call smxmy(fv,npoints,coeffb,ncontractions,fb,nmos,npts,nbeta)

      do 1009 i=1,npts
 1009 dnsty(i,2)=selfdot(nbeta,fb(1,i))

 1008 continue

      call addvecs(npts,dnsty(1,3),dnsty(1,1),dnsty(1,2))

      if(nfunctional.eq.0) goto 1010

      call smxmy(fvx,npoints,coeffa,ncontractions,fx,nmos,npts,nalpha)
      call smxmy(fvy,npoints,coeffa,ncontractions,fy,nmos,npts,nalpha)
      call smxmy(fvz,npoints,coeffa,ncontractions,fz,nmos,npts,nalpha)

      do 1011 i=1,npts
      gradx(i,1)=two*dot(nalpha,fa(1,i),fx(1,i))
      grady(i,1)=two*dot(nalpha,fa(1,i),fy(1,i))
 1011 gradz(i,1)=two*dot(nalpha,fa(1,i),fz(1,i))

      if(nfunctional.eq.1) then

               call hdcomp(npoints,nmos,ncontractions,nalpha,npts,
     &                                coeffa,fvxx,fa,fx,fxx,hssxx(1,1))

               call hocomp(npoints,nmos,ncontractions,nalpha,npts,
     &                             coeffa,fvxy,fa,fx,fy,fxx,hssxy(1,1))

               call hocomp(npoints,nmos,ncontractions,nalpha,npts,
     &                             coeffa,fvxz,fa,fx,fz,fxx,hssxz(1,1))

               call hdcomp(npoints,nmos,ncontractions,nalpha,npts,
     &                                coeffa,fvyy,fa,fy,fxx,hssyy(1,1))

               call hocomp(npoints,nmos,ncontractions,nalpha,npts,
     &                             coeffa,fvyz,fa,fy,fz,fxx,hssyz(1,1))

               call hdcomp(npoints,nmos,ncontractions,nalpha,npts,
     &                                coeffa,fvzz,fa,fz,fxx,hsszz(1,1))

                           endif

      if(nalpha.eq.nbeta) then
                                do 1012 i=1,npts
                                gradx(i,2)=gradx(i,1)
                                grady(i,2)=grady(i,1)
 1012                           gradz(i,2)=gradz(i,1)

                                do 1013 i=1,npts
                                hssxx(i,2)=hssxx(i,1)
                                hssxy(i,2)=hssxy(i,1)
                                hssxz(i,2)=hssxz(i,1)
                                hssyy(i,2)=hssyy(i,1)
                                hssyz(i,2)=hssyz(i,1)
 1013                           hsszz(i,2)=hsszz(i,1)
                          endif

      if(nalpha.eq.nbeta) goto 1014

      call smxmy(fvx,npoints,coeffb,ncontractions,fx,nmos,npts,nbeta)
      call smxmy(fvy,npoints,coeffb,ncontractions,fy,nmos,npts,nbeta)
      call smxmy(fvz,npoints,coeffb,ncontractions,fz,nmos,npts,nbeta)

      do 1015 i=1,npts
      gradx(i,2)=two*dot(nbeta,fb(1,i),fx(1,i))
      grady(i,2)=two*dot(nbeta,fb(1,i),fy(1,i))
 1015 gradz(i,2)=two*dot(nbeta,fb(1,i),fz(1,i))

      if(nfunctional.eq.1) then

               call hdcomp(npoints,nmos,ncontractions,nbeta,npts,
     &                                coeffb,fvxx,fb,fx,fxx,hssxx(1,2))

               call hocomp(npoints,nmos,ncontractions,nbeta,npts,
     &                             coeffb,fvxy,fb,fx,fy,fxx,hssxy(1,2))

               call hocomp(npoints,nmos,ncontractions,nbeta,npts,
     &                             coeffb,fvxz,fb,fx,fz,fxx,hssxz(1,2))

               call hdcomp(npoints,nmos,ncontractions,nbeta,npts,
     &                                coeffb,fvyy,fb,fy,fxx,hssyy(1,2))

               call hocomp(npoints,nmos,ncontractions,nbeta,npts,
     &                             coeffb,fvyz,fb,fy,fz,fxx,hssyz(1,2))

               call hdcomp(npoints,nmos,ncontractions,nbeta,npts,
     &                                coeffb,fvzz,fb,fz,fxx,hsszz(1,2))

                           endif

 1014 continue

      call addvecs(npts,gradx(1,3),gradx(1,1),gradx(1,2))
      call addvecs(npts,grady(1,3),grady(1,1),grady(1,2))
      call addvecs(npts,gradz(1,3),gradz(1,1),gradz(1,2))

      call addvecs(npts,hssxx(1,3),hssxx(1,1),hssxx(1,2))
      call addvecs(npts,hssxy(1,3),hssxy(1,1),hssxy(1,2))
      call addvecs(npts,hssxz(1,3),hssxz(1,1),hssxz(1,2))
      call addvecs(npts,hssyy(1,3),hssyy(1,1),hssyy(1,2))
      call addvecs(npts,hssyz(1,3),hssyz(1,1),hssyz(1,2))
      call addvecs(npts,hsszz(1,3),hsszz(1,1),hsszz(1,2))

 1010 continue

      do 1016 i=1,npts
      call xcfunctional(nfunctional,dnsty(i,1),dnsty(i,2),dnsty(i,3),
     &                              gradx(i,1),grady(i,1),gradz(i,1),
     &                              gradx(i,2),grady(i,2),gradz(i,2),
     &                              gradx(i,3),grady(i,3),gradz(i,3),
     &                              hssxx(i,1),hssxy(i,1),hssxz(i,1),
     &                              hssyy(i,1),hssyz(i,1),hsszz(i,1),
     &                              hssxx(i,2),hssxy(i,2),hssxz(i,2),
     &                              hssyy(i,2),hssyz(i,2),hsszz(i,2),
     &                              hssxx(i,3),hssxy(i,3),hssxz(i,3),
     &                              hssyy(i,3),hssyz(i,3),hsszz(i,3),
     &                              xcnrg(i),xcpot(i,1),xcpot(i,2))
 1016 continue

      if(iswitch.eq.0) then
                             do 1017 i=1,npts
                             xcoord(ia+i-1)=xcpot(i,1)
                             ycoord(ia+i-1)=xcpot(i,2)
 1017                        zpoint(ia+i-1)=xcnrg(i)
                       endif

      if(iswitch.eq.0) goto 1004

      call gridxc(npts,npoints,nxcfunctions,nxcs,nxcspd,ixclfunc,
     &            ixccfunc,coord,alphaxc,coefsxc,coefpxc,coefdxc,
     &            xcoord(ia),ycoord(ia),zpoint(ia),fv,wkvec,
     &            wkvec(npoints+1),wkvec(2*npoints+1),
     &            wkvec(3*npoints+1),wkvec(4*npoints+1))

      do 1018 i=1,nxcfunctions
 1018 call multvec(npts,fvx(1,i),fv(1,i),weight)

      if(iteration.eq.1) call sxcbld(nauxfunctions,npoints,naos,
     &                               nxcfunctions,npts,auxoverlap,
     &                               fv,fvx,fvy)

      do 1019 i=1,nxcfunctions
      tveca(i)=tveca(i)+dot(npts,fvx(1,i),xcpot(1,1))
      tvecb(i)=tvecb(i)+dot(npts,fvx(1,i),xcpot(1,2))
 1019 tvece(i)=tvece(i)+dot(npts,fvx(1,i),xcnrg(1))

 1004 continue

      if(iswitch.eq.0) then
                             call fastwr(12,xcoord,nptsatom(iatom))
                             call fastwr(12,ycoord,nptsatom(iatom))
                             call fastwr(12,zpoint,nptsatom(iatom))
                       endif

 1003 continue

      nfunctional=nsavefunctional

      return
      end
