      subroutine gradcdps(m,n,ncds,ilfunc,icfunc,icontr,inddyy,icentr,
     &                    iicontr,g,coord,density,gradient,cdfitc,
     &                    alphaaux,coeffs,zeta,twozetaa,twozetab,px,py,
     &                    pz,base,pxax,pyay,pzaz,axbx,ayby,azbz,zzeta,
     &                    ttwozetaa,ttwozetab,zetarec,ppx,ppy,ppz,ppxax,
     &                    ppyay,ppzaz,wxpx,wypy,wzpz,zetac1,u,sss0,sss1,
     &                    sss2,pss0,pss1,dss0,c,sscond,pscond,dscond,
     &                    ppcond,grad)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(m,*),icentr(m,*),
     &          iicontr(*)

      dimension g(*),coord(3,*),density(*),gradient(3,*),cdfitc(*),
     &          alphaaux(*),coeffs(*),zeta(*),twozetaa(*),twozetab(*),
     &          px(*),py(*),pz(*),base(*),pxax(*),pyay(*),pzaz(*),
     &          axbx(*),ayby(*),azbz(*),zzeta(*),ttwozetaa(*),
     &          ttwozetab(*),zetarec(*),ppx(*),ppy(*),ppz(*),ppxax(*),
     &          ppyay(*),ppzaz(*),wxpx(*),wypy(*),wzpz(*),zetac1(*),
     &          u(*),sss0(*),sss1(*),sss2(*),pss0(n,*),pss1(n,*),
     &          dss0(n,*),c(*),sscond(*),pscond(m,*),dscond(m,*),
     &          ppcond(m,*),grad(m,*)

      data one,two,three,four,five,seven/1.0,2.0,3.0,4.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      nc=icfunc(ilaux)

      ccx=coord(1,nc)
      ccy=coord(2,nc)
      ccz=coord(3,nc)

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(3,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
 1004 sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n
      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ttwozetaa(nn)=twozetaa(i)
                                       ttwozetab(nn)=twozetab(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                 endif
 1005 continue

      do 1006 i=1,nn
 1006 zetac1(i)=zetaux*zetarec(i)

      do 1007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1008 i=1,nn
      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
 1008 pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      do 1009 i=1,nn
      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
 1009 pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      do 1010 i=1,nn
 1010 c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      do 1011 i=1,nn
      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
 1011 dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      do 1012 i=1,m
 1012 sscond(i)=zero

      do 1013 i=1,nn
 1013 sscond(iicontr(i))=sscond(iicontr(i))-sss0(i)

      do 1014 j=1,3
      do 1014 i=1,m
 1014 grad(i,j)=sscond(i)*density(inddyy(i,j))*cdfits

      do 1015 j=1,3
      do 1015 i=1,m
 1015 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1016 j=1,3
      do 1016 i=1,m
 1016 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))+grad(i,j)

      do 1017 j=1,6
      do 1017 i=1,m
 1017 dscond(i,j)=zero

      do 1018 j=1,6
      do 1018 i=1,nn
 1018 dscond(iicontr(i),j)=dscond(iicontr(i),j)+dss0(i,j)*ttwozetaa(i)

      do 1019 i=1,m
      grad(i,1)=dscond(i,1)*density(inddyy(i,1))*cdfits
      grad(i,2)=dscond(i,2)*density(inddyy(i,2))*cdfits
      grad(i,3)=dscond(i,3)*density(inddyy(i,3))*cdfits
      grad(i,4)=dscond(i,2)*density(inddyy(i,1))*cdfits
      grad(i,5)=dscond(i,4)*density(inddyy(i,2))*cdfits
      grad(i,6)=dscond(i,5)*density(inddyy(i,3))*cdfits
      grad(i,7)=dscond(i,3)*density(inddyy(i,1))*cdfits
      grad(i,8)=dscond(i,5)*density(inddyy(i,2))*cdfits
 1019 grad(i,9)=dscond(i,6)*density(inddyy(i,3))*cdfits

      do 1020 k=1,3
      do 1020 j=1,3
      do 1020 i=1,m
 1020 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1021 k=1,3
      do 1021 j=1,3
      do 1021 i=1,m
 1021 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

      do 1022 j=1,3
      do 1022 i=1,m
 1022 pscond(i,j)=zero

      do 1023 j=1,6
      do 1023 i=1,m
 1023 dscond(i,j)=zero

      do 1024 j=1,3
      do 1024 i=1,nn
 1024 pscond(iicontr(i),j)=pscond(iicontr(i),j)+pss0(i,j)*ttwozetab(i)

      do 1025 j=1,6
      do 1025 i=1,nn
 1025 dscond(iicontr(i),j)=dscond(iicontr(i),j)+dss0(i,j)*ttwozetab(i)

      do 1026 i=1,m
      ppcond(i,1)=axbx(i)*pscond(i,1)+dscond(i,1)
      ppcond(i,2)=ayby(i)*pscond(i,1)+dscond(i,2)
      ppcond(i,3)=azbz(i)*pscond(i,1)+dscond(i,3)
      ppcond(i,4)=axbx(i)*pscond(i,2)+dscond(i,2)
      ppcond(i,5)=ayby(i)*pscond(i,2)+dscond(i,4)
      ppcond(i,6)=azbz(i)*pscond(i,2)+dscond(i,5)
      ppcond(i,7)=axbx(i)*pscond(i,3)+dscond(i,3)
      ppcond(i,8)=ayby(i)*pscond(i,3)+dscond(i,5)
 1026 ppcond(i,9)=azbz(i)*pscond(i,3)+dscond(i,6)

      do 1027 i=1,m
      grad(i,1)=ppcond(i,1)*density(inddyy(i,1))*cdfits
      grad(i,2)=ppcond(i,4)*density(inddyy(i,2))*cdfits
      grad(i,3)=ppcond(i,7)*density(inddyy(i,3))*cdfits
      grad(i,4)=ppcond(i,2)*density(inddyy(i,1))*cdfits
      grad(i,5)=ppcond(i,5)*density(inddyy(i,2))*cdfits
      grad(i,6)=ppcond(i,8)*density(inddyy(i,3))*cdfits
      grad(i,7)=ppcond(i,3)*density(inddyy(i,1))*cdfits
      grad(i,8)=ppcond(i,6)*density(inddyy(i,2))*cdfits
 1027 grad(i,9)=ppcond(i,9)*density(inddyy(i,3))*cdfits

      do 1028 k=1,3
      do 1028 j=1,3
      do 1028 i=1,m
 1028 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1029 k=1,3
      do 1029 j=1,3
      do 1029 i=1,m
 1029 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,3*(k-1)+j)

 1001 continue

      return
      end
