      subroutine xcorpp(m,n,nxcs,nxcspd,ilfunc,icfunc,iminj,icontr,
     &                  iicontr,inddyy,coord,xcfit1,xcfit2,xcfit3,
     &                  alphaaux,coeffs,coeffp,coeffd,fock1,fock2,fock3,
     &                  zeta,ax,ay,az,axbx,ayby,azbz,px,py,pz,base,
     &                  zetarec,zetafac,efac,gxax,gyay,gzaz,sss,pss,
     &                  psscond,dss,dsscond,fss,fsscond,gss,gsscond,pps,
     &                  dps,fps,ppp,dpp,ppd,c,c1,c2,zzeta,aax,aay,aaz,
     &                  ppx,ppy,ppz,axcx,aycy,azcz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xcft1p(3),xcft2p(3),xcft3p(3),
     &          xcft1d(6),xcft2d(6),xcft3d(6)

      dimension ilfunc(*),icfunc(*),iminj(*),icontr(*),iicontr(*),
     &          inddyy(m,*)

      dimension coord(3,*),xcfit1(*),xcfit2(*),xcfit3(*),alphaaux(*),
     &          coeffs(*),coeffp(*),coeffd(*),fock1(*),fock2(*),
     &          fock3(*),zeta(*),ax(*),ay(*),az(*),axbx(*),ayby(*),
     &          azbz(*),px(*),py(*),pz(*),base(*),zetarec(*),zetafac(*),
     &          efac(*),gxax(*),gyay(*),gzaz(*),sss(*),pss(n,*),
     &          psscond(m,*),dss(n,*),dsscond(m,*),fss(n,*),
     &          fsscond(m,*),gss(n,*),gsscond(m,*),pps(m,*),dps(m,*),
     &          fps(m,*),ppp(m,*),dpp(m,*),ppd(m,*),c(*),c1(n,*),
     &          c2(n,*),zzeta(*),aax(*),aay(*),aaz(*),ppx(*),ppy(*),
     &          ppz(*),axcx(*),aycy(*),azcz(*)

      data zero,one,two,three/0.0,1.0,2.0,3.0/
      data expcut,calcut/80.0,1.0e-16/

      sqrt3=sqrt(three)

      do 1001 naux=1,nxcs

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(naux)*coeffs(ilaux)
      xcft2s=xcfit2(naux)*coeffs(ilaux)
      xcft3s=xcfit3(naux)*coeffs(ilaux)

      do 1002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      sss(i)=zero
 1004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 1005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 1005 continue

      do 1006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 1006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 1007 i=1,nn
 1007 zetarec(i)=zetarec(i)/two

      do 1008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 1008 pss(i,3)=gzaz(i)*sss(i)

      do 1009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 1009 continue

      do 1010 j=1,3
      do 1010 i=1,m
 1010 psscond(i,j)=zero

      do 1011 j=1,6
      do 1011 i=1,m
 1011 dsscond(i,j)=zero

      do 1012 j=1,3
      do 1012 i=1,nn
 1012 psscond(iicontr(i),j)=psscond(iicontr(i),j)+pss(i,j)

      do 1013 j=1,6
      do 1013 i=1,nn
 1013 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 1014 i=1,m
      pps(i,1)=axbx(i)*psscond(i,1)+dsscond(i,1)
      pps(i,2)=ayby(i)*psscond(i,1)+dsscond(i,2)
      pps(i,3)=azbz(i)*psscond(i,1)+dsscond(i,3)
      pps(i,4)=axbx(i)*psscond(i,2)+dsscond(i,2)
      pps(i,5)=ayby(i)*psscond(i,2)+dsscond(i,4)
      pps(i,6)=azbz(i)*psscond(i,2)+dsscond(i,5)
      pps(i,7)=axbx(i)*psscond(i,3)+dsscond(i,3)
      pps(i,8)=ayby(i)*psscond(i,3)+dsscond(i,5)
 1014 pps(i,9)=azbz(i)*psscond(i,3)+dsscond(i,6)

      do 1015 i=1,m

      fock1(inddyy(i,1))=fock1(inddyy(i,1))+pps(i,1)*xcft1s
      fock1(inddyy(i,4))=fock1(inddyy(i,4))+pps(i,4)*xcft1s
      fock1(inddyy(i,5))=fock1(inddyy(i,5))+pps(i,5)*xcft1s
      fock1(inddyy(i,7))=fock1(inddyy(i,7))+pps(i,7)*xcft1s
      fock1(inddyy(i,8))=fock1(inddyy(i,8))+pps(i,8)*xcft1s
      fock1(inddyy(i,9))=fock1(inddyy(i,9))+pps(i,9)*xcft1s

      fock2(inddyy(i,1))=fock2(inddyy(i,1))+pps(i,1)*xcft2s
      fock2(inddyy(i,4))=fock2(inddyy(i,4))+pps(i,4)*xcft2s
      fock2(inddyy(i,5))=fock2(inddyy(i,5))+pps(i,5)*xcft2s
      fock2(inddyy(i,7))=fock2(inddyy(i,7))+pps(i,7)*xcft2s
      fock2(inddyy(i,8))=fock2(inddyy(i,8))+pps(i,8)*xcft2s
      fock2(inddyy(i,9))=fock2(inddyy(i,9))+pps(i,9)*xcft2s

      fock3(inddyy(i,1))=fock3(inddyy(i,1))+pps(i,1)*xcft3s
      fock3(inddyy(i,4))=fock3(inddyy(i,4))+pps(i,4)*xcft3s
      fock3(inddyy(i,5))=fock3(inddyy(i,5))+pps(i,5)*xcft3s
      fock3(inddyy(i,7))=fock3(inddyy(i,7))+pps(i,7)*xcft3s
      fock3(inddyy(i,8))=fock3(inddyy(i,8))+pps(i,8)*xcft3s
      fock3(inddyy(i,9))=fock3(inddyy(i,9))+pps(i,9)*xcft3s

 1015 continue

      do 1016 i=1,m
      if(iminj(i).ne.0) then

                 fock1(inddyy(i,2))=fock1(inddyy(i,2))+pps(i,2)*xcft1s
                 fock1(inddyy(i,3))=fock1(inddyy(i,3))+pps(i,3)*xcft1s
                 fock1(inddyy(i,6))=fock1(inddyy(i,6))+pps(i,6)*xcft1s

                 fock2(inddyy(i,2))=fock2(inddyy(i,2))+pps(i,2)*xcft2s
                 fock2(inddyy(i,3))=fock2(inddyy(i,3))+pps(i,3)*xcft2s
                 fock2(inddyy(i,6))=fock2(inddyy(i,6))+pps(i,6)*xcft2s

                 fock3(inddyy(i,2))=fock3(inddyy(i,2))+pps(i,2)*xcft3s
                 fock3(inddyy(i,3))=fock3(inddyy(i,3))+pps(i,3)*xcft3s
                 fock3(inddyy(i,6))=fock3(inddyy(i,6))+pps(i,6)*xcft3s

                        endif
 1016 continue

 1001 continue

      do 2001 naux=1,nxcspd

      ilaux=ilfunc(nxcs+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft2s=xcfit2(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft3s=xcfit3(nxcs+(naux-1)*10+1)*coeffs(ilaux)

      xcft1p(1)=xcfit1(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft1p(2)=xcfit1(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft1p(3)=xcfit1(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft2p(1)=xcfit2(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft2p(2)=xcfit2(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft2p(3)=xcfit2(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft3p(1)=xcfit3(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft3p(2)=xcfit3(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft3p(3)=xcfit3(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft1d(1)=xcfit1(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft1d(2)=xcfit1(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft1d(3)=xcfit1(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft1d(4)=xcfit1(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft1d(5)=xcfit1(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft1d(6)=xcfit1(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft2d(1)=xcfit2(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft2d(2)=xcfit2(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft2d(3)=xcfit2(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft2d(4)=xcfit2(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft2d(5)=xcfit2(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft2d(6)=xcfit2(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft3d(1)=xcfit3(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft3d(2)=xcfit3(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft3d(3)=xcfit3(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft3d(4)=xcfit3(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft3d(5)=xcfit3(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft3d(6)=xcfit3(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      do 2002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n

      axcx(icontr(i))=ax(i)-ccx
      aycy(icontr(i))=ay(i)-ccy
      azcz(icontr(i))=az(i)-ccz

      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz

 2003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      sss(i)=zero
 2004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 2005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 2005 continue

      do 2006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 2006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 2007 i=1,nn
 2007 zetarec(i)=zetarec(i)/two

      do 2008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 2008 pss(i,3)=gzaz(i)*sss(i)

      do 2009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 2009 continue

      do 2010 j=1,3
      do 2010 i=1,nn
 2010 c1(i,j)=zetarec(i)*pss(i,j)

      do 2011 i=1,nn
      fss(i,01)=gxax(i)*dss(i,1)+c1(i,1)*two
      fss(i,02)=gyay(i)*dss(i,1)
      fss(i,03)=gzaz(i)*dss(i,1)
      fss(i,04)=gyay(i)*dss(i,2)+c1(i,1)
      fss(i,05)=gzaz(i)*dss(i,2)
      fss(i,06)=gzaz(i)*dss(i,3)+c1(i,1)
      fss(i,07)=gyay(i)*dss(i,4)+c1(i,2)*two
      fss(i,08)=gzaz(i)*dss(i,4)
      fss(i,09)=gzaz(i)*dss(i,5)+c1(i,2)
 2011 fss(i,10)=gzaz(i)*dss(i,6)+c1(i,3)*two

      do 2012 j=1,6
      do 2012 i=1,nn
 2012 c2(i,j)=zetarec(i)*dss(i,j)

      do 2013 i=1,nn
      gss(i,01)=gxax(i)*fss(i,01)+c2(i,1)*three
      gss(i,02)=gyay(i)*fss(i,01)
      gss(i,03)=gzaz(i)*fss(i,01)
      gss(i,04)=gyay(i)*fss(i,02)+c2(i,1)
      gss(i,05)=gzaz(i)*fss(i,02)
      gss(i,06)=gzaz(i)*fss(i,03)+c2(i,1)
      gss(i,07)=gyay(i)*fss(i,04)+c2(i,2)*two
      gss(i,08)=gzaz(i)*fss(i,04)
      gss(i,09)=gzaz(i)*fss(i,05)+c2(i,2)
      gss(i,10)=gzaz(i)*fss(i,06)+c2(i,3)*two
      gss(i,11)=gyay(i)*fss(i,07)+c2(i,4)*three
      gss(i,12)=gzaz(i)*fss(i,07)
      gss(i,13)=gzaz(i)*fss(i,08)+c2(i,4)
      gss(i,14)=gzaz(i)*fss(i,09)+c2(i,5)*two
 2013 gss(i,15)=gzaz(i)*fss(i,10)+c2(i,6)*three

      do 2014 j=1,3
      do 2014 i=1,m
 2014 psscond(i,j)=zero

      do 2015 j=1,6
      do 2015 i=1,m
 2015 dsscond(i,j)=zero

      do 2016 j=1,10
      do 2016 i=1,m
 2016 fsscond(i,j)=zero

      do 2017 j=1,15
      do 2017 i=1,m
 2017 gsscond(i,j)=zero

      do 2018 j=1,3
      do 2018 i=1,nn
 2018 psscond(iicontr(i),j)=psscond(iicontr(i),j)+pss(i,j)

      do 2019 j=1,6
      do 2019 i=1,nn
 2019 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 2020 j=1,10
      do 2020 i=1,nn
 2020 fsscond(iicontr(i),j)=fsscond(iicontr(i),j)+fss(i,j)

      do 2021 j=1,15
      do 2021 i=1,nn
 2021 gsscond(iicontr(i),j)=gsscond(iicontr(i),j)+gss(i,j)

      do 2022 i=1,m
      pps(i,1)=axbx(i)*psscond(i,1)+dsscond(i,1)
      pps(i,2)=ayby(i)*psscond(i,1)+dsscond(i,2)
      pps(i,3)=azbz(i)*psscond(i,1)+dsscond(i,3)
      pps(i,4)=axbx(i)*psscond(i,2)+dsscond(i,2)
      pps(i,5)=ayby(i)*psscond(i,2)+dsscond(i,4)
      pps(i,6)=azbz(i)*psscond(i,2)+dsscond(i,5)
      pps(i,7)=axbx(i)*psscond(i,3)+dsscond(i,3)
      pps(i,8)=ayby(i)*psscond(i,3)+dsscond(i,5)
 2022 pps(i,9)=azbz(i)*psscond(i,3)+dsscond(i,6)

      do 2023 i=1,m
      dps(i,01)=axbx(i)*dsscond(i,1)+fsscond(i,01)
      dps(i,02)=ayby(i)*dsscond(i,1)+fsscond(i,02)
      dps(i,03)=azbz(i)*dsscond(i,1)+fsscond(i,03)
      dps(i,04)=axbx(i)*dsscond(i,2)+fsscond(i,02)
      dps(i,05)=ayby(i)*dsscond(i,2)+fsscond(i,04)
      dps(i,06)=azbz(i)*dsscond(i,2)+fsscond(i,05)
      dps(i,07)=axbx(i)*dsscond(i,3)+fsscond(i,03)
      dps(i,08)=ayby(i)*dsscond(i,3)+fsscond(i,05)
      dps(i,09)=azbz(i)*dsscond(i,3)+fsscond(i,06)
      dps(i,10)=axbx(i)*dsscond(i,4)+fsscond(i,04)
      dps(i,11)=ayby(i)*dsscond(i,4)+fsscond(i,07)
      dps(i,12)=azbz(i)*dsscond(i,4)+fsscond(i,08)
      dps(i,13)=axbx(i)*dsscond(i,5)+fsscond(i,05)
      dps(i,14)=ayby(i)*dsscond(i,5)+fsscond(i,08)
      dps(i,15)=azbz(i)*dsscond(i,5)+fsscond(i,09)
      dps(i,16)=axbx(i)*dsscond(i,6)+fsscond(i,06)
      dps(i,17)=ayby(i)*dsscond(i,6)+fsscond(i,09)
 2023 dps(i,18)=azbz(i)*dsscond(i,6)+fsscond(i,10)

      do 2024 i=1,m
      ppp(i,01)=axcx(i)*pps(i,1)+dps(i,01)
      ppp(i,02)=aycy(i)*pps(i,1)+dps(i,04)
      ppp(i,03)=azcz(i)*pps(i,1)+dps(i,07)
      ppp(i,04)=axcx(i)*pps(i,2)+dps(i,02)
      ppp(i,05)=aycy(i)*pps(i,2)+dps(i,05)
      ppp(i,06)=azcz(i)*pps(i,2)+dps(i,08)
      ppp(i,07)=axcx(i)*pps(i,3)+dps(i,03)
      ppp(i,08)=aycy(i)*pps(i,3)+dps(i,06)
      ppp(i,09)=azcz(i)*pps(i,3)+dps(i,09)
      ppp(i,10)=axcx(i)*pps(i,4)+dps(i,04)
      ppp(i,11)=aycy(i)*pps(i,4)+dps(i,10)
      ppp(i,12)=azcz(i)*pps(i,4)+dps(i,13)
      ppp(i,13)=axcx(i)*pps(i,5)+dps(i,05)
      ppp(i,14)=aycy(i)*pps(i,5)+dps(i,11)
      ppp(i,15)=azcz(i)*pps(i,5)+dps(i,14)
      ppp(i,16)=axcx(i)*pps(i,6)+dps(i,06)
      ppp(i,17)=aycy(i)*pps(i,6)+dps(i,12)
      ppp(i,18)=azcz(i)*pps(i,6)+dps(i,15)
      ppp(i,19)=axcx(i)*pps(i,7)+dps(i,07)
      ppp(i,20)=aycy(i)*pps(i,7)+dps(i,13)
      ppp(i,21)=azcz(i)*pps(i,7)+dps(i,16)
      ppp(i,22)=axcx(i)*pps(i,8)+dps(i,08)
      ppp(i,23)=aycy(i)*pps(i,8)+dps(i,14)
      ppp(i,24)=azcz(i)*pps(i,8)+dps(i,17)
      ppp(i,25)=axcx(i)*pps(i,9)+dps(i,09)
      ppp(i,26)=aycy(i)*pps(i,9)+dps(i,15)
 2024 ppp(i,27)=azcz(i)*pps(i,9)+dps(i,18)

      do 2025 i=1,m
      fps(i,01)=axbx(i)*fsscond(i,01)+gsscond(i,01)
      fps(i,02)=ayby(i)*fsscond(i,01)+gsscond(i,02)
      fps(i,03)=azbz(i)*fsscond(i,01)+gsscond(i,03)
      fps(i,04)=axbx(i)*fsscond(i,02)+gsscond(i,02)
      fps(i,05)=ayby(i)*fsscond(i,02)+gsscond(i,04)
      fps(i,06)=azbz(i)*fsscond(i,02)+gsscond(i,05)
      fps(i,07)=axbx(i)*fsscond(i,03)+gsscond(i,03)
      fps(i,08)=ayby(i)*fsscond(i,03)+gsscond(i,05)
      fps(i,09)=azbz(i)*fsscond(i,03)+gsscond(i,06)
      fps(i,10)=axbx(i)*fsscond(i,04)+gsscond(i,04)
      fps(i,11)=ayby(i)*fsscond(i,04)+gsscond(i,07)
      fps(i,12)=azbz(i)*fsscond(i,04)+gsscond(i,08)
      fps(i,13)=axbx(i)*fsscond(i,05)+gsscond(i,05)
      fps(i,14)=ayby(i)*fsscond(i,05)+gsscond(i,08)
      fps(i,15)=azbz(i)*fsscond(i,05)+gsscond(i,09)
      fps(i,16)=axbx(i)*fsscond(i,06)+gsscond(i,06)
      fps(i,17)=ayby(i)*fsscond(i,06)+gsscond(i,09)
      fps(i,18)=azbz(i)*fsscond(i,06)+gsscond(i,10)
      fps(i,19)=axbx(i)*fsscond(i,07)+gsscond(i,07)
      fps(i,20)=ayby(i)*fsscond(i,07)+gsscond(i,11)
      fps(i,21)=azbz(i)*fsscond(i,07)+gsscond(i,12)
      fps(i,22)=axbx(i)*fsscond(i,08)+gsscond(i,08)
      fps(i,23)=ayby(i)*fsscond(i,08)+gsscond(i,12)
      fps(i,24)=azbz(i)*fsscond(i,08)+gsscond(i,13)
      fps(i,25)=axbx(i)*fsscond(i,09)+gsscond(i,09)
      fps(i,26)=ayby(i)*fsscond(i,09)+gsscond(i,13)
      fps(i,27)=azbz(i)*fsscond(i,09)+gsscond(i,14)
      fps(i,28)=axbx(i)*fsscond(i,10)+gsscond(i,10)
      fps(i,29)=ayby(i)*fsscond(i,10)+gsscond(i,14)
 2025 fps(i,30)=azbz(i)*fsscond(i,10)+gsscond(i,15)

      do 2026 i=1,m
      dpp(i,01)=axcx(i)*dps(i,01)+fps(i,01)
      dpp(i,02)=aycy(i)*dps(i,01)+fps(i,04)
      dpp(i,03)=azcz(i)*dps(i,01)+fps(i,07)
      dpp(i,04)=axcx(i)*dps(i,02)+fps(i,02)
      dpp(i,05)=aycy(i)*dps(i,02)+fps(i,05)
      dpp(i,06)=azcz(i)*dps(i,02)+fps(i,08)
      dpp(i,07)=axcx(i)*dps(i,03)+fps(i,03)
      dpp(i,08)=aycy(i)*dps(i,03)+fps(i,06)
      dpp(i,09)=azcz(i)*dps(i,03)+fps(i,09)
      dpp(i,10)=axcx(i)*dps(i,04)+fps(i,04)
      dpp(i,11)=aycy(i)*dps(i,04)+fps(i,10)
      dpp(i,12)=azcz(i)*dps(i,04)+fps(i,13)
      dpp(i,13)=axcx(i)*dps(i,05)+fps(i,05)
      dpp(i,14)=aycy(i)*dps(i,05)+fps(i,11)
      dpp(i,15)=azcz(i)*dps(i,05)+fps(i,14)
      dpp(i,16)=axcx(i)*dps(i,06)+fps(i,06)
      dpp(i,17)=aycy(i)*dps(i,06)+fps(i,12)
      dpp(i,18)=azcz(i)*dps(i,06)+fps(i,15)
      dpp(i,19)=axcx(i)*dps(i,07)+fps(i,07)
      dpp(i,20)=aycy(i)*dps(i,07)+fps(i,13)
      dpp(i,21)=azcz(i)*dps(i,07)+fps(i,16)
      dpp(i,22)=axcx(i)*dps(i,08)+fps(i,08)
      dpp(i,23)=aycy(i)*dps(i,08)+fps(i,14)
      dpp(i,24)=azcz(i)*dps(i,08)+fps(i,17)
      dpp(i,25)=axcx(i)*dps(i,09)+fps(i,09)
      dpp(i,26)=aycy(i)*dps(i,09)+fps(i,15)
      dpp(i,27)=azcz(i)*dps(i,09)+fps(i,18)
      dpp(i,28)=axcx(i)*dps(i,10)+fps(i,10)
      dpp(i,29)=aycy(i)*dps(i,10)+fps(i,19)
      dpp(i,30)=azcz(i)*dps(i,10)+fps(i,22)
      dpp(i,31)=axcx(i)*dps(i,11)+fps(i,11)
      dpp(i,32)=aycy(i)*dps(i,11)+fps(i,20)
      dpp(i,33)=azcz(i)*dps(i,11)+fps(i,23)
      dpp(i,34)=axcx(i)*dps(i,12)+fps(i,12)
      dpp(i,35)=aycy(i)*dps(i,12)+fps(i,21)
      dpp(i,36)=azcz(i)*dps(i,12)+fps(i,24)
      dpp(i,37)=axcx(i)*dps(i,13)+fps(i,13)
      dpp(i,38)=aycy(i)*dps(i,13)+fps(i,22)
      dpp(i,39)=azcz(i)*dps(i,13)+fps(i,25)
      dpp(i,40)=axcx(i)*dps(i,14)+fps(i,14)
      dpp(i,41)=aycy(i)*dps(i,14)+fps(i,23)
      dpp(i,42)=azcz(i)*dps(i,14)+fps(i,26)
      dpp(i,43)=axcx(i)*dps(i,15)+fps(i,15)
      dpp(i,44)=aycy(i)*dps(i,15)+fps(i,24)
      dpp(i,45)=azcz(i)*dps(i,15)+fps(i,27)
      dpp(i,46)=axcx(i)*dps(i,16)+fps(i,16)
      dpp(i,47)=aycy(i)*dps(i,16)+fps(i,25)
      dpp(i,48)=azcz(i)*dps(i,16)+fps(i,28)
      dpp(i,49)=axcx(i)*dps(i,17)+fps(i,17)
      dpp(i,50)=aycy(i)*dps(i,17)+fps(i,26)
      dpp(i,51)=azcz(i)*dps(i,17)+fps(i,29)
      dpp(i,52)=axcx(i)*dps(i,18)+fps(i,18)
      dpp(i,53)=aycy(i)*dps(i,18)+fps(i,27)
 2026 dpp(i,54)=azcz(i)*dps(i,18)+fps(i,30)

      do 2027 i=1,m
      ppd(i,01)=axcx(i)*ppp(i,01)+dpp(i,01)
      ppd(i,02)=aycy(i)*ppp(i,01)+dpp(i,10)
      ppd(i,03)=azcz(i)*ppp(i,01)+dpp(i,19)
      ppd(i,04)=aycy(i)*ppp(i,02)+dpp(i,11)
      ppd(i,05)=azcz(i)*ppp(i,02)+dpp(i,20)
      ppd(i,06)=azcz(i)*ppp(i,03)+dpp(i,21)
      ppd(i,07)=axcx(i)*ppp(i,04)+dpp(i,04)
      ppd(i,08)=aycy(i)*ppp(i,04)+dpp(i,13)
      ppd(i,09)=azcz(i)*ppp(i,04)+dpp(i,22)
      ppd(i,10)=aycy(i)*ppp(i,05)+dpp(i,14)
      ppd(i,11)=azcz(i)*ppp(i,05)+dpp(i,23)
      ppd(i,12)=azcz(i)*ppp(i,06)+dpp(i,24)
      ppd(i,13)=axcx(i)*ppp(i,07)+dpp(i,07)
      ppd(i,14)=aycy(i)*ppp(i,07)+dpp(i,16)
      ppd(i,15)=azcz(i)*ppp(i,07)+dpp(i,25)
      ppd(i,16)=aycy(i)*ppp(i,08)+dpp(i,17)
      ppd(i,17)=azcz(i)*ppp(i,08)+dpp(i,26)
      ppd(i,18)=azcz(i)*ppp(i,09)+dpp(i,27)
      ppd(i,19)=axcx(i)*ppp(i,10)+dpp(i,10)
      ppd(i,20)=aycy(i)*ppp(i,10)+dpp(i,28)
      ppd(i,21)=azcz(i)*ppp(i,10)+dpp(i,37)
      ppd(i,22)=aycy(i)*ppp(i,11)+dpp(i,29)
      ppd(i,23)=azcz(i)*ppp(i,11)+dpp(i,38)
      ppd(i,24)=azcz(i)*ppp(i,12)+dpp(i,39)
      ppd(i,25)=axcx(i)*ppp(i,13)+dpp(i,13)
      ppd(i,26)=aycy(i)*ppp(i,13)+dpp(i,31)
      ppd(i,27)=azcz(i)*ppp(i,13)+dpp(i,40)
      ppd(i,28)=aycy(i)*ppp(i,14)+dpp(i,32)
      ppd(i,29)=azcz(i)*ppp(i,14)+dpp(i,41)
      ppd(i,30)=azcz(i)*ppp(i,15)+dpp(i,42)
      ppd(i,31)=axcx(i)*ppp(i,16)+dpp(i,16)
      ppd(i,32)=aycy(i)*ppp(i,16)+dpp(i,34)
      ppd(i,33)=azcz(i)*ppp(i,16)+dpp(i,43)
      ppd(i,34)=aycy(i)*ppp(i,17)+dpp(i,35)
      ppd(i,35)=azcz(i)*ppp(i,17)+dpp(i,44)
      ppd(i,36)=azcz(i)*ppp(i,18)+dpp(i,45)
      ppd(i,37)=axcx(i)*ppp(i,19)+dpp(i,19)
      ppd(i,38)=aycy(i)*ppp(i,19)+dpp(i,37)
      ppd(i,39)=azcz(i)*ppp(i,19)+dpp(i,46)
      ppd(i,40)=aycy(i)*ppp(i,20)+dpp(i,38)
      ppd(i,41)=azcz(i)*ppp(i,20)+dpp(i,47)
      ppd(i,42)=azcz(i)*ppp(i,21)+dpp(i,48)
      ppd(i,43)=axcx(i)*ppp(i,22)+dpp(i,22)
      ppd(i,44)=aycy(i)*ppp(i,22)+dpp(i,40)
      ppd(i,45)=azcz(i)*ppp(i,22)+dpp(i,49)
      ppd(i,46)=aycy(i)*ppp(i,23)+dpp(i,41)
      ppd(i,47)=azcz(i)*ppp(i,23)+dpp(i,50)
      ppd(i,48)=azcz(i)*ppp(i,24)+dpp(i,51)
      ppd(i,49)=axcx(i)*ppp(i,25)+dpp(i,25)
      ppd(i,50)=aycy(i)*ppp(i,25)+dpp(i,43)
      ppd(i,51)=azcz(i)*ppp(i,25)+dpp(i,52)
      ppd(i,52)=aycy(i)*ppp(i,26)+dpp(i,44)
      ppd(i,53)=azcz(i)*ppp(i,26)+dpp(i,53)
 2027 ppd(i,54)=azcz(i)*ppp(i,27)+dpp(i,54)

      do 2028 i=1,m

      fock1(inddyy(i,1))=fock1(inddyy(i,1))+pps(i,1)*xcft1s
      fock1(inddyy(i,4))=fock1(inddyy(i,4))+pps(i,4)*xcft1s
      fock1(inddyy(i,5))=fock1(inddyy(i,5))+pps(i,5)*xcft1s
      fock1(inddyy(i,7))=fock1(inddyy(i,7))+pps(i,7)*xcft1s
      fock1(inddyy(i,8))=fock1(inddyy(i,8))+pps(i,8)*xcft1s
      fock1(inddyy(i,9))=fock1(inddyy(i,9))+pps(i,9)*xcft1s

      fock2(inddyy(i,1))=fock2(inddyy(i,1))+pps(i,1)*xcft2s
      fock2(inddyy(i,4))=fock2(inddyy(i,4))+pps(i,4)*xcft2s
      fock2(inddyy(i,5))=fock2(inddyy(i,5))+pps(i,5)*xcft2s
      fock2(inddyy(i,7))=fock2(inddyy(i,7))+pps(i,7)*xcft2s
      fock2(inddyy(i,8))=fock2(inddyy(i,8))+pps(i,8)*xcft2s
      fock2(inddyy(i,9))=fock2(inddyy(i,9))+pps(i,9)*xcft2s

      fock3(inddyy(i,1))=fock3(inddyy(i,1))+pps(i,1)*xcft3s
      fock3(inddyy(i,4))=fock3(inddyy(i,4))+pps(i,4)*xcft3s
      fock3(inddyy(i,5))=fock3(inddyy(i,5))+pps(i,5)*xcft3s
      fock3(inddyy(i,7))=fock3(inddyy(i,7))+pps(i,7)*xcft3s
      fock3(inddyy(i,8))=fock3(inddyy(i,8))+pps(i,8)*xcft3s
      fock3(inddyy(i,9))=fock3(inddyy(i,9))+pps(i,9)*xcft3s

 2028 continue

      do 2029 i=1,m
      if(iminj(i).ne.0) then

                 fock1(inddyy(i,2))=fock1(inddyy(i,2))+pps(i,2)*xcft1s
                 fock1(inddyy(i,3))=fock1(inddyy(i,3))+pps(i,3)*xcft1s
                 fock1(inddyy(i,6))=fock1(inddyy(i,6))+pps(i,6)*xcft1s

                 fock2(inddyy(i,2))=fock2(inddyy(i,2))+pps(i,2)*xcft2s
                 fock2(inddyy(i,3))=fock2(inddyy(i,3))+pps(i,3)*xcft2s
                 fock2(inddyy(i,6))=fock2(inddyy(i,6))+pps(i,6)*xcft2s

                 fock3(inddyy(i,2))=fock3(inddyy(i,2))+pps(i,2)*xcft3s
                 fock3(inddyy(i,3))=fock3(inddyy(i,3))+pps(i,3)*xcft3s
                 fock3(inddyy(i,6))=fock3(inddyy(i,6))+pps(i,6)*xcft3s

                        endif
 2029 continue

      do 2030 j=1,3
      do 2030 i=1,m

      fock1(inddyy(i,1))=fock1(inddyy(i,1))+ppp(i,3*0+j)*xcft1p(j)
      fock1(inddyy(i,4))=fock1(inddyy(i,4))+ppp(i,3*3+j)*xcft1p(j)
      fock1(inddyy(i,5))=fock1(inddyy(i,5))+ppp(i,3*4+j)*xcft1p(j)
      fock1(inddyy(i,7))=fock1(inddyy(i,7))+ppp(i,3*6+j)*xcft1p(j)
      fock1(inddyy(i,8))=fock1(inddyy(i,8))+ppp(i,3*7+j)*xcft1p(j)
      fock1(inddyy(i,9))=fock1(inddyy(i,9))+ppp(i,3*8+j)*xcft1p(j)

      fock2(inddyy(i,1))=fock2(inddyy(i,1))+ppp(i,3*0+j)*xcft2p(j)
      fock2(inddyy(i,4))=fock2(inddyy(i,4))+ppp(i,3*3+j)*xcft2p(j)
      fock2(inddyy(i,5))=fock2(inddyy(i,5))+ppp(i,3*4+j)*xcft2p(j)
      fock2(inddyy(i,7))=fock2(inddyy(i,7))+ppp(i,3*6+j)*xcft2p(j)
      fock2(inddyy(i,8))=fock2(inddyy(i,8))+ppp(i,3*7+j)*xcft2p(j)
      fock2(inddyy(i,9))=fock2(inddyy(i,9))+ppp(i,3*8+j)*xcft2p(j)

      fock3(inddyy(i,1))=fock3(inddyy(i,1))+ppp(i,3*0+j)*xcft3p(j)
      fock3(inddyy(i,4))=fock3(inddyy(i,4))+ppp(i,3*3+j)*xcft3p(j)
      fock3(inddyy(i,5))=fock3(inddyy(i,5))+ppp(i,3*4+j)*xcft3p(j)
      fock3(inddyy(i,7))=fock3(inddyy(i,7))+ppp(i,3*6+j)*xcft3p(j)
      fock3(inddyy(i,8))=fock3(inddyy(i,8))+ppp(i,3*7+j)*xcft3p(j)
      fock3(inddyy(i,9))=fock3(inddyy(i,9))+ppp(i,3*8+j)*xcft3p(j)

 2030 continue

      do 2031 j=1,3
      do 2031 i=1,m
      if(iminj(i).ne.0) then

          fock1(inddyy(i,2))=fock1(inddyy(i,2))+ppp(i,3*1+j)*xcft1p(j)
          fock1(inddyy(i,3))=fock1(inddyy(i,3))+ppp(i,3*2+j)*xcft1p(j)
          fock1(inddyy(i,6))=fock1(inddyy(i,6))+ppp(i,3*5+j)*xcft1p(j)

          fock2(inddyy(i,2))=fock2(inddyy(i,2))+ppp(i,3*1+j)*xcft2p(j)
          fock2(inddyy(i,3))=fock2(inddyy(i,3))+ppp(i,3*2+j)*xcft2p(j)
          fock2(inddyy(i,6))=fock2(inddyy(i,6))+ppp(i,3*5+j)*xcft2p(j)

          fock3(inddyy(i,2))=fock3(inddyy(i,2))+ppp(i,3*1+j)*xcft3p(j)
          fock3(inddyy(i,3))=fock3(inddyy(i,3))+ppp(i,3*2+j)*xcft3p(j)
          fock3(inddyy(i,6))=fock3(inddyy(i,6))+ppp(i,3*5+j)*xcft3p(j)

                        endif
 2031 continue

      do 2032 j=1,6
      do 2032 i=1,m

      fock1(inddyy(i,1))=fock1(inddyy(i,1))+ppd(i,6*0+j)*xcft1d(j)
      fock1(inddyy(i,4))=fock1(inddyy(i,4))+ppd(i,6*3+j)*xcft1d(j)
      fock1(inddyy(i,5))=fock1(inddyy(i,5))+ppd(i,6*4+j)*xcft1d(j)
      fock1(inddyy(i,7))=fock1(inddyy(i,7))+ppd(i,6*6+j)*xcft1d(j)
      fock1(inddyy(i,8))=fock1(inddyy(i,8))+ppd(i,6*7+j)*xcft1d(j)
      fock1(inddyy(i,9))=fock1(inddyy(i,9))+ppd(i,6*8+j)*xcft1d(j)

      fock2(inddyy(i,1))=fock2(inddyy(i,1))+ppd(i,6*0+j)*xcft2d(j)
      fock2(inddyy(i,4))=fock2(inddyy(i,4))+ppd(i,6*3+j)*xcft2d(j)
      fock2(inddyy(i,5))=fock2(inddyy(i,5))+ppd(i,6*4+j)*xcft2d(j)
      fock2(inddyy(i,7))=fock2(inddyy(i,7))+ppd(i,6*6+j)*xcft2d(j)
      fock2(inddyy(i,8))=fock2(inddyy(i,8))+ppd(i,6*7+j)*xcft2d(j)
      fock2(inddyy(i,9))=fock2(inddyy(i,9))+ppd(i,6*8+j)*xcft2d(j)

      fock3(inddyy(i,1))=fock3(inddyy(i,1))+ppd(i,6*0+j)*xcft3d(j)
      fock3(inddyy(i,4))=fock3(inddyy(i,4))+ppd(i,6*3+j)*xcft3d(j)
      fock3(inddyy(i,5))=fock3(inddyy(i,5))+ppd(i,6*4+j)*xcft3d(j)
      fock3(inddyy(i,7))=fock3(inddyy(i,7))+ppd(i,6*6+j)*xcft3d(j)
      fock3(inddyy(i,8))=fock3(inddyy(i,8))+ppd(i,6*7+j)*xcft3d(j)
      fock3(inddyy(i,9))=fock3(inddyy(i,9))+ppd(i,6*8+j)*xcft3d(j)

 2032 continue

      do 2033 j=1,6
      do 2033 i=1,m
      if(iminj(i).ne.0) then

          fock1(inddyy(i,2))=fock1(inddyy(i,2))+ppd(i,6*1+j)*xcft1d(j)
          fock1(inddyy(i,3))=fock1(inddyy(i,3))+ppd(i,6*2+j)*xcft1d(j)
          fock1(inddyy(i,6))=fock1(inddyy(i,6))+ppd(i,6*5+j)*xcft1d(j)

          fock2(inddyy(i,2))=fock2(inddyy(i,2))+ppd(i,6*1+j)*xcft2d(j)
          fock2(inddyy(i,3))=fock2(inddyy(i,3))+ppd(i,6*2+j)*xcft2d(j)
          fock2(inddyy(i,6))=fock2(inddyy(i,6))+ppd(i,6*5+j)*xcft2d(j)

          fock3(inddyy(i,2))=fock3(inddyy(i,2))+ppd(i,6*1+j)*xcft3d(j)
          fock3(inddyy(i,3))=fock3(inddyy(i,3))+ppd(i,6*2+j)*xcft3d(j)
          fock3(inddyy(i,6))=fock3(inddyy(i,6))+ppd(i,6*5+j)*xcft3d(j)

                        endif
 2033 continue

 2001 continue

      return
      end
