      subroutine rotinv(n,nmodes,cc,gc)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension a(3,3),b(3)

      dimension cc(3,*),gc(3,*)

      data zero/0.0/

      gtx=zero
      gty=zero
      gtz=zero

      cmx=zero
      cmy=zero
      cmz=zero

      do 1001 i=1,n

      gtx=gtx+gc(1,i)/real64(n)
      gty=gty+gc(2,i)/real64(n)
      gtz=gtz+gc(3,i)/real64(n)

      cmx=cmx+cc(1,i)/real64(n)
      cmy=cmy+cc(2,i)/real64(n)
      cmz=cmz+cc(3,i)/real64(n)

 1001 continue

      do 1002 i=1,n
      gc(1,i)=gc(1,i)-gtx
      gc(2,i)=gc(2,i)-gty
      gc(3,i)=gc(3,i)-gtz
 1002 continue

      if(nmodes.ne.(3*n-6)) return

      do 1003 j=1,3
      b(j)=zero
      do 1003 i=1,3
 1003 a(i,j)=zero

      do 1004 i=1,n

      ax=cc(1,i)-cmx
      ay=cc(2,i)-cmy
      az=cc(3,i)-cmz

      a(1,1)=a(1,1)+ay*ay+az*az
      a(2,2)=a(2,2)+ax*ax+az*az
      a(3,3)=a(3,3)+ax*ax+ay*ay

      a(1,2)=a(1,2)-ax*ay
      a(1,3)=a(1,3)-ax*az
      a(2,1)=a(2,1)-ay*ax
      a(2,3)=a(2,3)-ay*az
      a(3,1)=a(3,1)-az*ax
      a(3,2)=a(3,2)-az*ay

      b(1)=b(1)+(ay*gc(3,i)-az*gc(2,i))
      b(2)=b(2)+(az*gc(1,i)-ax*gc(3,i))
      b(3)=b(3)+(ax*gc(2,i)-ay*gc(1,i))

 1004 continue

      call matinv(a,b,3,1,3)

      do 1005 i=1,n
      gc(1,i)=gc(1,i)-(b(2)*(cc(3,i)-cmz)-b(3)*(cc(2,i)-cmy))
      gc(2,i)=gc(2,i)-(b(3)*(cc(1,i)-cmx)-b(1)*(cc(3,i)-cmz))
      gc(3,i)=gc(3,i)-(b(1)*(cc(2,i)-cmy)-b(2)*(cc(1,i)-cmx))
 1005 continue

      return
      end
