      subroutine gradxxss(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,inddyy,
     &                    icentr,iicontr,g,coord,density,gradient,
     &                    cdfitc,alphaaux,coeffs,coeffp,coeffd,zeta,
     &                    twozetaa,twozetab,px,py,pz,base,pxax,pyay,
     &                    pzaz,axbx,ayby,azbz,zzeta,ttwozetaa,ttwozetab,
     &                    zetarec,ppx,ppy,ppz,ppxax,ppyay,ppzaz,wxpx,
     &                    wypy,wzpz,wxcx,wycy,wzcz,zetac1,zetac2,u,sss0,
     &                    sss1,sss2,sss3,pss0,pss1,pss2,ssp0,ssp1,ssd0,
     &                    psp0,psp1,psd0,c,c1,c2,ssscond,sspcond,
     &                    ssdcond,psscond,pspcond,psdcond,spscond,
     &                    sppcond,spdcond,grad)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(*),icentr(m,*),
     &          iicontr(*)

      dimension cdfitp(3),cdfitd(6)

      dimension g(*),coord(3,*),density(*),gradient(3,*),cdfitc(*),
     &          alphaaux(*),coeffs(*),coeffp(*),coeffd(*),zeta(*),
     &          twozetaa(*),twozetab(*),px(*),py(*),pz(*),base(*),
     &          pxax(*),pyay(*),pzaz(*),axbx(*),ayby(*),azbz(*),
     &          zzeta(*),ttwozetaa(*),ttwozetab(*),zetarec(*),ppx(*),
     &          ppy(*),ppz(*),ppxax(*),ppyay(*),ppzaz(*),wxpx(*),
     &          wypy(*),wzpz(*),wxcx(*),wycy(*),wzcz(*),zetac1(*),
     &          zetac2(*),u(*),sss0(*),sss1(*),sss2(*),sss3(*),
     &          pss0(n,*),pss1(n,*),pss2(n,*),ssp0(n,*),ssp1(n,*),
     &          ssd0(n,*),psp0(n,*),psp1(n,*),psd0(n,*),c(*),c1(n,*),
     &          c2(n,*),ssscond(*),sspcond(m,*),ssdcond(m,*),
     &          psscond(m,*),pspcond(m,*),psdcond(m,*),spscond(m,*),
     &          sppcond(m,*),spdcond(m,*),grad(m,*)

      data one,two,three,four,five,seven/1.0,2.0,3.0,4.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      dnormcd=seven/sqrt(three)

      do 1001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      nc=icfunc(ilaux)

      ccx=coord(1,nc)
      ccy=coord(2,nc)
      ccz=coord(3,nc)

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(4,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
 1004 sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n
      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ttwozetaa(nn)=twozetaa(i)
                                       ttwozetab(nn)=twozetab(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                 endif
 1005 continue

      do 1006 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 1006 zetac2(i)=zzeta(i)*zetarec(i)

      do 1007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 1007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 1008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1009 i=1,nn
      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
 1009 pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      do 1010 i=1,nn
      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
 1010 pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      do 1011 i=1,nn
      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
 1011 pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      do 1012 i=1,nn
      ssp0(i,1)=wxcx(i)*sss1(i)
      ssp0(i,2)=wycy(i)*sss1(i)
 1012 ssp0(i,3)=wzcz(i)*sss1(i)

      do 1013 i=1,nn
      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
 1013 ssp1(i,3)=wzcz(i)*sss2(i)

      do 1014 i=1,nn
 1014 c(i)=(sss0(i)-zetac2(i)*sss1(i))/(two*zetaux)

      do 1015 i=1,nn
      ssd0(i,1)=wxcx(i)*ssp1(i,1)+c(i)
      ssd0(i,2)=wycy(i)*ssp1(i,1)
      ssd0(i,3)=wzcz(i)*ssp1(i,1)
      ssd0(i,4)=wycy(i)*ssp1(i,2)+c(i)
      ssd0(i,5)=wzcz(i)*ssp1(i,2)
 1015 ssd0(i,6)=wzcz(i)*ssp1(i,3)+c(i)

      do 1016 i=1,nn
 1016 c(i)=half*sss1(i)*zetarec(i)

      do 1017 i=1,nn
      psp0(i,1)=wxcx(i)*pss1(i,1)+c(i)
      psp0(i,2)=wycy(i)*pss1(i,1)
      psp0(i,3)=wzcz(i)*pss1(i,1)
      psp0(i,4)=wxcx(i)*pss1(i,2)
      psp0(i,5)=wycy(i)*pss1(i,2)+c(i)
      psp0(i,6)=wzcz(i)*pss1(i,2)
      psp0(i,7)=wxcx(i)*pss1(i,3)
      psp0(i,8)=wycy(i)*pss1(i,3)
 1017 psp0(i,9)=wzcz(i)*pss1(i,3)+c(i)

      do 1018 i=1,nn
 1018 c(i)=half*sss2(i)*zetarec(i)

      do 1019 i=1,nn
      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
 1019 psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

      do 1020 j=1,3
      do 1020 i=1,nn
 1020 c1(i,j)=(pss0(i,j)-zetac2(i)*pss1(i,j))/(two*zetaux)

      do 1021 j=1,3
      do 1021 i=1,nn
 1021 c2(i,j)=half*ssp1(i,j)*zetarec(i)

      do 1022 i=1,nn
      psd0(i,01)=wxcx(i)*psp1(i,1)+c1(i,1)+c2(i,1)
      psd0(i,02)=wycy(i)*psp1(i,1)
      psd0(i,03)=wzcz(i)*psp1(i,1)
      psd0(i,04)=wycy(i)*psp1(i,2)+c1(i,1)
      psd0(i,05)=wzcz(i)*psp1(i,2)
      psd0(i,06)=wzcz(i)*psp1(i,3)+c1(i,1)
      psd0(i,07)=wxcx(i)*psp1(i,4)+c1(i,2)
      psd0(i,08)=wycy(i)*psp1(i,4)        +c2(i,1)
      psd0(i,09)=wzcz(i)*psp1(i,4)
      psd0(i,10)=wycy(i)*psp1(i,5)+c1(i,2)+c2(i,2)
      psd0(i,11)=wzcz(i)*psp1(i,5)
      psd0(i,12)=wzcz(i)*psp1(i,6)+c1(i,2)
      psd0(i,13)=wxcx(i)*psp1(i,7)+c1(i,3)
      psd0(i,14)=wycy(i)*psp1(i,7)
      psd0(i,15)=wzcz(i)*psp1(i,7)        +c2(i,1)
      psd0(i,16)=wycy(i)*psp1(i,8)+c1(i,3)
      psd0(i,17)=wzcz(i)*psp1(i,8)        +c2(i,2)
 1022 psd0(i,18)=wzcz(i)*psp1(i,9)+c1(i,3)+c2(i,3)

      do 1023 j=1,3
      do 1023 i=1,m
 1023 psscond(i,j)=zero

      do 1024 j=1,9
      do 1024 i=1,m
 1024 pspcond(i,j)=zero

      do 1025 j=1,18
      do 1025 i=1,m
 1025 psdcond(i,j)=zero

      do 1026 j=1,3
      do 1026 i=1,nn
 1026 psscond(iicontr(i),j)=psscond(iicontr(i),j)+pss0(i,j)*ttwozetaa(i)

      do 1027 j=1,9
      do 1027 i=1,nn
 1027 pspcond(iicontr(i),j)=pspcond(iicontr(i),j)+psp0(i,j)*ttwozetaa(i)

      do 1028 j=1,18
      do 1028 i=1,nn
 1028 psdcond(iicontr(i),j)=psdcond(iicontr(i),j)+psd0(i,j)*ttwozetaa(i)

      do 1029 i=1,m
      grad(i,1)=psscond(i,1)*density(inddyy(i))*cdfits
      grad(i,2)=psscond(i,2)*density(inddyy(i))*cdfits
 1029 grad(i,3)=psscond(i,3)*density(inddyy(i))*cdfits

      do 1030 j=1,3
      do 1030 i=1,m
 1030 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1031 j=1,3
      do 1031 i=1,m
 1031 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))+grad(i,j)

      do 2001 l=1,3

      do 1032 i=1,m
      grad(i,1)=pspcond(i,0+l)*density(inddyy(i))*cdfitp(l)
      grad(i,2)=pspcond(i,3+l)*density(inddyy(i))*cdfitp(l)
 1032 grad(i,3)=pspcond(i,6+l)*density(inddyy(i))*cdfitp(l)

      do 1033 j=1,3
      do 1033 i=1,m
 1033 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1034 j=1,3
      do 1034 i=1,m
 1034 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))+grad(i,j)

 2001 continue

      do 2002 l=1,6

      do 1035 i=1,m
      grad(i,1)=psdcond(i,00+l)*density(inddyy(i))*cdfitd(l)
      grad(i,2)=psdcond(i,06+l)*density(inddyy(i))*cdfitd(l)
 1035 grad(i,3)=psdcond(i,12+l)*density(inddyy(i))*cdfitd(l)

      do 1036 j=1,3
      do 1036 i=1,m
 1036 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1037 j=1,3
      do 1037 i=1,m
 1037 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))+grad(i,j)

 2002 continue

      do 1038 i=1,m
 1038 ssscond(i)=zero

      do 1039 j=1,3
      do 1039 i=1,m
 1039 sspcond(i,j)=zero

      do 1040 j=1,6
      do 1040 i=1,m
 1040 ssdcond(i,j)=zero

      do 1041 j=1,3
      do 1041 i=1,m
 1041 psscond(i,j)=zero

      do 1042 j=1,9
      do 1042 i=1,m
 1042 pspcond(i,j)=zero

      do 1043 j=1,18
      do 1043 i=1,m
 1043 psdcond(i,j)=zero

      do 1044 i=1,nn
 1044 ssscond(iicontr(i))=ssscond(iicontr(i))+sss0(i)*ttwozetab(i)

      do 1045 j=1,3
      do 1045 i=1,nn
 1045 sspcond(iicontr(i),j)=sspcond(iicontr(i),j)+ssp0(i,j)*ttwozetab(i)

      do 1046 j=1,6
      do 1046 i=1,nn
 1046 ssdcond(iicontr(i),j)=ssdcond(iicontr(i),j)+ssd0(i,j)*ttwozetab(i)

      do 1047 j=1,3
      do 1047 i=1,nn
 1047 psscond(iicontr(i),j)=psscond(iicontr(i),j)+pss0(i,j)*ttwozetab(i)

      do 1048 j=1,9
      do 1048 i=1,nn
 1048 pspcond(iicontr(i),j)=pspcond(iicontr(i),j)+psp0(i,j)*ttwozetab(i)

      do 1049 j=1,18
      do 1049 i=1,nn
 1049 psdcond(iicontr(i),j)=psdcond(iicontr(i),j)+psd0(i,j)*ttwozetab(i)

      do 1050 i=1,m
      spscond(i,1)=axbx(i)*ssscond(i)+psscond(i,1)
      spscond(i,2)=ayby(i)*ssscond(i)+psscond(i,2)
 1050 spscond(i,3)=azbz(i)*ssscond(i)+psscond(i,3)

      do 1051 i=1,m
      sppcond(i,1)=axbx(i)*sspcond(i,1)+pspcond(i,1)
      sppcond(i,2)=axbx(i)*sspcond(i,2)+pspcond(i,2)
      sppcond(i,3)=axbx(i)*sspcond(i,3)+pspcond(i,3)
      sppcond(i,4)=ayby(i)*sspcond(i,1)+pspcond(i,4)
      sppcond(i,5)=ayby(i)*sspcond(i,2)+pspcond(i,5)
      sppcond(i,6)=ayby(i)*sspcond(i,3)+pspcond(i,6)
      sppcond(i,7)=azbz(i)*sspcond(i,1)+pspcond(i,7)
      sppcond(i,8)=azbz(i)*sspcond(i,2)+pspcond(i,8)
 1051 sppcond(i,9)=azbz(i)*sspcond(i,3)+pspcond(i,9)

      do 1052 i=1,m
      spdcond(i,01)=axbx(i)*ssdcond(i,1)+psdcond(i,01)
      spdcond(i,02)=axbx(i)*ssdcond(i,2)+psdcond(i,02)
      spdcond(i,03)=axbx(i)*ssdcond(i,3)+psdcond(i,03)
      spdcond(i,04)=axbx(i)*ssdcond(i,4)+psdcond(i,04)
      spdcond(i,05)=axbx(i)*ssdcond(i,5)+psdcond(i,05)
      spdcond(i,06)=axbx(i)*ssdcond(i,6)+psdcond(i,06)
      spdcond(i,07)=ayby(i)*ssdcond(i,1)+psdcond(i,07)
      spdcond(i,08)=ayby(i)*ssdcond(i,2)+psdcond(i,08)
      spdcond(i,09)=ayby(i)*ssdcond(i,3)+psdcond(i,09)
      spdcond(i,10)=ayby(i)*ssdcond(i,4)+psdcond(i,10)
      spdcond(i,11)=ayby(i)*ssdcond(i,5)+psdcond(i,11)
      spdcond(i,12)=ayby(i)*ssdcond(i,6)+psdcond(i,12)
      spdcond(i,13)=azbz(i)*ssdcond(i,1)+psdcond(i,13)
      spdcond(i,14)=azbz(i)*ssdcond(i,2)+psdcond(i,14)
      spdcond(i,15)=azbz(i)*ssdcond(i,3)+psdcond(i,15)
      spdcond(i,16)=azbz(i)*ssdcond(i,4)+psdcond(i,16)
      spdcond(i,17)=azbz(i)*ssdcond(i,5)+psdcond(i,17)
 1052 spdcond(i,18)=azbz(i)*ssdcond(i,6)+psdcond(i,18)

      do 1053 i=1,m
      grad(i,1)=spscond(i,1)*density(inddyy(i))*cdfits
      grad(i,2)=spscond(i,2)*density(inddyy(i))*cdfits
 1053 grad(i,3)=spscond(i,3)*density(inddyy(i))*cdfits

      do 1054 j=1,3
      do 1054 i=1,m
 1054 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1055 j=1,3
      do 1055 i=1,m
 1055 gradient(j,icentr(i,2))=gradient(j,icentr(i,2))+grad(i,j)

      do 2003 l=1,3

      do 1056 i=1,m
      grad(i,1)=sppcond(i,0+l)*density(inddyy(i))*cdfitp(l)
      grad(i,2)=sppcond(i,3+l)*density(inddyy(i))*cdfitp(l)
 1056 grad(i,3)=sppcond(i,6+l)*density(inddyy(i))*cdfitp(l)

      do 1057 j=1,3
      do 1057 i=1,m
 1057 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1058 j=1,3
      do 1058 i=1,m
 1058 gradient(j,icentr(i,2))=gradient(j,icentr(i,2))+grad(i,j)

 2003 continue

      do 2004 l=1,6

      do 1059 i=1,m
      grad(i,1)=spdcond(i,00+l)*density(inddyy(i))*cdfitd(l)
      grad(i,2)=spdcond(i,06+l)*density(inddyy(i))*cdfitd(l)
 1059 grad(i,3)=spdcond(i,12+l)*density(inddyy(i))*cdfitd(l)

      do 1060 j=1,3
      do 1060 i=1,m
 1060 gradient(j,nc)=gradient(j,nc)-grad(i,j)

      do 1061 j=1,3
      do 1061 i=1,m
 1061 gradient(j,icentr(i,2))=gradient(j,icentr(i,2))+grad(i,j)

 2004 continue

 1001 continue

      return
      end
