      subroutine diis(nspin,iteration,ndim,noccupied,nvirtual,ntotal,
     &                dmix,error,wkmat1,wkmat2,wkmat3,wkmat4,wkmat5)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      parameter (nmaxdiis=51)

      dimension diis1(nmaxdiis,nmaxdiis),diis2(nmaxdiis,nmaxdiis),
     &          diismatrix(nmaxdiis,nmaxdiis),diisvector(nmaxdiis)

      dimension wkmat1(ndim,*),wkmat2(ndim,*),wkmat3(ntotal,*),
     &          wkmat4(noccupied,*),wkmat5(noccupied,*)

      data zero,one,startdiis/0.0,1.0,0.001/

      save nstep,dmixsave,diis1,diis2

      if(iteration.le.1) then
                               nstep=1

                               do 1001 i=1,nmaxdiis
                               diis1(i,1)=-one
 1001                          diis1(1,i)=-one

                               diis1(1,1)=zero

                               do 1002 i=1,nmaxdiis
                               diis2(i,1)=-one
 1002                          diis2(1,i)=-one

                               diis2(1,1)=zero

                               dmixsave=dmix

                               return
                         else
                               if(nspin.eq.1) nstep=nstep+1
                         endif

      if(nstep.gt.nmaxdiis) stop 'too many iterations for diis option'

      if(nstep.gt.2) goto 1003

      if(nspin.eq.1) rewind 81
      if(nspin.eq.2) rewind 82

      do 1004 i=1,ntotal
      if(nspin.eq.1) call fastrd(81,wkmat1(1,i),ndim)
 1004 if(nspin.eq.2) call fastrd(82,wkmat1(1,i),ndim)

      if(nspin.eq.1) rewind 83
      if(nspin.eq.2) rewind 84

      do 1005 i=1,ntotal
      if(nspin.eq.1) call fastwr(83,wkmat2(1,i),ndim)
 1005 if(nspin.eq.2) call fastwr(84,wkmat2(1,i),ndim)

      do 1006 j=1,nvirtual
      do 1007 i=1,ntotal
 1007 wkmat3(i,j)=zero
      do 1006 k=1,ntotal
      do 1006 i=1,ntotal
 1006 wkmat3(i,j)=wkmat3(i,j)+wkmat2(i,k)*wkmat1(k,noccupied+j)

      do 1008 j=1,nvirtual
      do 1008 i=1,noccupied
 1008 wkmat4(i,j)=dot(ntotal,wkmat1(1,i),wkmat3(1,j))

      if(nspin.eq.1) rewind 85
      if(nspin.eq.2) rewind 86

      do 1009 i=1,nvirtual
      if(nspin.eq.1) call fastwr(85,wkmat4(1,i),noccupied)
 1009 if(nspin.eq.2) call fastwr(86,wkmat4(1,i),noccupied)

      dotproduct=zero

      do 1010 j=1,nvirtual
      do 1010 i=1,noccupied
 1010 dotproduct=dotproduct+wkmat4(i,j)*wkmat4(i,j)

      if(nspin.eq.1) diis1(2,2)=dotproduct
      if(nspin.eq.2) diis2(2,2)=dotproduct

      error=dotproduct

      return

 1003 continue

      if(nspin.eq.1) rewind 81
      if(nspin.eq.2) rewind 82

      do 1011 i=1,ntotal
      if(nspin.eq.1) call fastrd(81,wkmat1(1,i),ndim)
 1011 if(nspin.eq.2) call fastrd(82,wkmat1(1,i),ndim)

      if(nspin.eq.1) endfile 83
      if(nspin.eq.2) endfile 84

      if(nspin.eq.1) backspace 83
      if(nspin.eq.2) backspace 84

      do 1012 i=1,ntotal
      if(nspin.eq.1) call fastwr(83,wkmat2(1,i),ndim)
 1012 if(nspin.eq.2) call fastwr(84,wkmat2(1,i),ndim)

      do 1013 j=1,nvirtual
      do 1014 i=1,ntotal
 1014 wkmat3(i,j)=zero
      do 1013 k=1,ntotal
      do 1013 i=1,ntotal
 1013 wkmat3(i,j)=wkmat3(i,j)+wkmat2(i,k)*wkmat1(k,noccupied+j)

      do 1015 j=1,nvirtual
      do 1015 i=1,noccupied
 1015 wkmat5(i,j)=dot(ntotal,wkmat1(1,i),wkmat3(1,j))

      if(nspin.eq.1) endfile 85
      if(nspin.eq.2) endfile 86

      if(nspin.eq.1) backspace 85
      if(nspin.eq.2) backspace 86

      do 1016 i=1,nvirtual
      if(nspin.eq.1) call fastwr(85,wkmat5(1,i),noccupied)
 1016 if(nspin.eq.2) call fastwr(86,wkmat5(1,i),noccupied)

      if(nspin.eq.1) rewind 85
      if(nspin.eq.2) rewind 86

      do 1017 k=2,nstep

      do 1018 i=1,nvirtual
      if(nspin.eq.1) call fastrd(85,wkmat4(1,i),noccupied)
 1018 if(nspin.eq.2) call fastrd(86,wkmat4(1,i),noccupied)

      dotproduct=zero

      do 1019 j=1,nvirtual
      do 1019 i=1,noccupied
 1019 dotproduct=dotproduct+wkmat4(i,j)*wkmat5(i,j)

      if(nspin.eq.1) diis1(k,nstep)=dotproduct
      if(nspin.eq.1) diis1(nstep,k)=dotproduct
      if(nspin.eq.2) diis2(k,nstep)=dotproduct
      if(nspin.eq.2) diis2(nstep,k)=dotproduct

 1017 continue

      if(nspin.eq.1) error=diis1(nstep,nstep)
      if(nspin.eq.2) error=diis1(nstep,nstep)+diis2(nstep,nstep)

      dmix=one

      do 1020 i=1,nstep
 1020 diisvector(i)=zero

      diisvector(1)=-one

      nmax=min(nstep,6)

      if(error.gt.startdiis) then
                                   nmax=2
                                   dmix=dmixsave
                             endif

      do 1021 j=1,nstep
      do 1021 i=1,nstep
      if(nspin.eq.1) diismatrix(i,j)=diis1(i,j)
 1021 if(nspin.eq.2) diismatrix(i,j)=diis2(i,j)

      if(nmax.ne.nstep) then

                 do 1022 j=2,nmax
                 do 1022 i=2,nmax
 1022            diismatrix(i,j)=diismatrix(i+nstep-nmax,j+nstep-nmax)

                        endif

      call matinv(diismatrix,diisvector,nmax,1,nmaxdiis)

      if(nspin.eq.1) rewind 83
      if(nspin.eq.2) rewind 84

      if(nmax.ne.nstep) then

                        do 1023 j=nmax,nstep-1
                        do 1023 i=1,ntotal
                        if(nspin.eq.1) call fastrd(83,wkmat3(1,i),1)
 1023                   if(nspin.eq.2) call fastrd(84,wkmat3(1,i),1)

                        endif

      do 1024 j=1,ntotal
      do 1024 i=1,ntotal
 1024 wkmat2(i,j)=zero

      do 1025 idiis=2,nmax

      do 1026 i=1,ntotal
      if(nspin.eq.1) call fastrd(83,wkmat3(1,i),ntotal)
 1026 if(nspin.eq.2) call fastrd(84,wkmat3(1,i),ntotal)

      do 1027 j=1,ntotal
      do 1027 i=1,ntotal
 1027 wkmat2(i,j)=wkmat2(i,j)+diisvector(idiis)*wkmat3(i,j)

 1025 continue

      return
      end
