      subroutine deft(nreal,ninteger,nmaxatoms,nmaxcontractions,ndim,
     &                nauxfunctions,nmaxpoints,nesppts,ncontacts,
     &                ndegfreedom,iwkvec,nptsatom,natomtype,izmat1,
     &                izmat2,izmat3,nequivvec,intfreeze,nfuncatom,
     &                ilfunc,icfunc,mtloca,ngaussians,nshels,nshelp,
     &                nsheld,icdlfunc,icdcfunc,ixclfunc,ixccfunc,wkvec,
     &                coord,coordsave,charge,coordptcharge,ptcharge,
     &                grad,gradsave,coord1,coord2,grad1,grad2,hessian,
     &                djacobian,coeffa,coeffb,overlap,orbnrga,orbnrgb,
     &                dmta,dmtb,core,focka,fockb,focke,alpha,coeff,
     &                auxoverlap,alphacd,coefscd,coefpcd,coefdcd,
     &                alphaxc,coefsxc,coefpxc,coefdxc,cdfitc,xcfita,
     &                xcfitb,xcfite,xcfitsave,tvector,tveca,tvecb,tvece,
     &                inputstring,atomsymbol)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      character inputstring(nmaxatoms,*)*30,atomsymbol(*)*4

      dimension iwkvec(*),nptsatom(*),natomtype(*),izmat1(*),izmat2(*),
     &          izmat3(*),nequivvec(nmaxatoms,*),intfreeze(*),
     &          nfuncatom(*),ilfunc(*),icfunc(*),mtloca(*),
     &          ngaussians(*),nshels(*),nshelp(*),nsheld(*),icdlfunc(*),
     &          icdcfunc(*),ixclfunc(*),ixccfunc(*)

      dimension wkvec(*),coord(3,*),coordsave(3,*),charge(*),
     &          coordptcharge(3,*),ptcharge(*),grad(3,*),gradsave(3,*),
     &          coord1(*),coord2(*),grad1(*),grad2(*),
     &          hessian(ndegfreedom,*),djacobian(*),
     &          coeffa(nmaxcontractions,*),coeffb(nmaxcontractions,*),
     &          overlap(nmaxcontractions,*),orbnrga(*),orbnrgb(*),
     &          dmta(*),dmtb(*),core(*),focka(*),fockb(*),focke(*),
     &          alpha(*),coeff(*),auxoverlap(nauxfunctions,*),
     &          alphacd(*),coefscd(*),coefpcd(*),coefdcd(*),alphaxc(*),
     &          coefsxc(*),coefpxc(*),coefdxc(*),cdfitc(*),xcfita(*),
     &          xcfitb(*),xcfite(*),xcfitsave(*),tvector(*),tveca(*),
     &          tvecb(*),tvece(*)

      data zero,bohr,one/0.0,0.529177,1.0/
      data smallnumber,default,bignumber/1.0e-06,0.250,1.0e+25/

      call startup

      ncenters=0
      nptcharges=0
      icharge=0
      imultiplicity=1
      ngridtype=1
      nfunctional=0
      irandomgrid=1
      ihessian=2
      idiis=1
      irestart=0
      intcoordflag=0
      ioptimize=0
      nmaxiterations=40
      nmaxgeometries=10
      mopac=0
      ivibrations=0
      nfdpbt=0
      nequivalences=0

      do 1001 i=1,nmaxatoms
      nequivvec(i,1)=0
 1001 nequivvec(i,2)=0

      dmixing=default
      dmaxstep=default
      econvergence=smallnumber
      gconvergence=sqrt(smallnumber)
      elevelshift=zero
      epsilon=one

      call input(nmaxatoms,ncenters,nptcharges,ndegfreedom,nfunctional,
     &           irandomgrid,ngridtype,nmaxiterations,nmaxgeometries,
     &           icharge,imultiplicity,mopac,idiis,nfdpbt,irestart,
     &           ioptimize,ivibrations,ihessian,intcoordflag,
     &           nequivalences,izmat1,izmat2,izmat3,natomtype,intfreeze,
     &           nequivvec,econvergence,gconvergence,dmixing,dmaxstep,
     &           elevelshift,epsilon,coord,charge,coordptcharge,
     &           ptcharge,atomsymbol)

      write(6,1002)
 1002 format(//)

      dnuclearcharge=zero

      do 1003 i=1,ncenters
 1003 dnuclearcharge=dnuclearcharge+charge(i)

      nelectrons=nint(dnuclearcharge)-icharge

      if((mod(imultiplicity,2)).eq.1) then

                  nalpha=(nelectrons/2)+((imultiplicity-1)/2)
                  nbeta=(nelectrons/2)-((imultiplicity-1)/2)

                                      else

                  nalpha=((nelectrons+1)/2)+((imultiplicity-2)/2)
                  nbeta=((nelectrons-1)/2)-((imultiplicity-2)/2)

                                      endif

      if((nalpha+nbeta).ne.nelectrons) then

             write(6,1004)
 1004        format(' the charge and multiplicity do not make sense')
             stop

                                       endif

      savedmixing=dmixing

      call inputbases(nmaxatoms,ncenters,nconts,ncontp,ncontd,
     &                ncontractions,ncds,ncdsets,ncdfunctions,nxcs,
     &                nxcsets,nxcfunctions,wkvec,
     &                wkvec(1*nauxfunctions+1),wkvec(2*nauxfunctions+1),
     &                wkvec(3*nauxfunctions+1),icfunc,ilfunc,ngaussians,
     &                mtloca,nshels,nshelp,nsheld,icdcfunc,icdlfunc,
     &                ixccfunc,ixclfunc,natomtype,alpha,coeff,alphacd,
     &                coefscd,coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,
     &                coefdxc,inputstring)

      do 1005 i=1,ncdfunctions
 1005 cdfitc(i)=zero

      do 1006 i=1,nxcfunctions
      xcfita(i)=zero
      xcfitb(i)=zero
 1006 xcfite(i)=zero

      ja=1
      jb=ja+9*ncenters**2
      jc=jb+9*ncenters**2
      jd=jc+3*ncenters
      je=jd+3*ncenters
      jf=je+3*ncenters

      if(ioptimize.ne.0) then

               if(mopac.eq.1) call mopaci(coord,hessian,wkvec(ja),
     &                                    wkvec(jb),wkvec(jc),
     &                                    wkvec(jd),wkvec(je),
     &                                    wkvec(jf),ihessian,ncenters,
     &                                    3*ncenters,ndegfreedom)

               if(mopac.eq.0) then
                                    do 1007 i=1,3*ncenters
                                    do 1008 j=1,3*ncenters
 1008                               hessian(j,i)=zero
 1007                               hessian(i,i)=one
                              endif

               do 1009 j=1,ncenters
               do 1009 i=1,3
 1009          coordsave(i,j)=coord(i,j)

                         endif

      if(irestart.ne.0) call readt(ncenters,ndegfreedom,ncdfunctions,
     &                             nxcfunctions,coordsave,coord,
     &                             gradsave,grad,hessian,cdfitc,xcfita,
     &                             xcfitb,xcfite)

      if(intcoorflag.eq.1) call zmatrix(ncenters,coord,izmat1,izmat2,
     &                                  izmat3,atomsymbol)

      write(6,1010)
 1010 format(' cartesian coordinates (with basis sets):',/)

      do 1011 i=1,ncenters
 1011 if(natomtype(i).ne.0) write(6,1012) atomsymbol(i),
     &                                    coord(1,i)*bohr,
     &                                    coord(2,i)*bohr,
     &                                    coord(3,i)*bohr,
     &                                    inputstring(i,1),
     &                                    inputstring(i,2)
 1012 format(1x,a4,2x,3f12.7,6x,a30,/,49x,a30,/)

      call rijmat(ncenters,atomsymbol,coord)

      if(ivibrations.eq.1) then

          call savet(ncenters,ndegfreedom,ncdfunctions,nxcfunctions,
     &               coordsave,coord,gradsave,grad,hessian,cdfitc,
     &               xcfita,xcfitb,xcfite)

          call vibrations(nreal,ninteger,nmaxcontractions,nauxfunctions,
     &                    nmaxpoints,ndim,ndegfreedom,ncenters,
     &                    nptcharges,nalpha,nbeta,nconts,ncontp,ncontd,
     &                    ncds,ncdsets-ncds,nxcs,nxcsets-nxcs,idiis,
     &                    nmaxiterations,nfunctional,irandomgrid,
     &                    ngridtype,iwkvec,izmat1,izmat2,izmat3,
     &                    natomtype,nfuncatom,nptsatom,icfunc,ilfunc,
     &                    ngaussians,mtloca,nshels,nshelp,nsheld,
     &                    icdcfunc,icdlfunc,ixccfunc,ixclfunc,intfreeze,
     &                    econvergence,dmixing,elevelshift,wkvec,coord,
     &                    coordsave,charge,grad,gradsave,coordptcharge,
     &                    ptcharge,overlap,core,focka,fockb,focke,dmta,
     &                    dmtb,coeffa,coeffb,orbnrga,orbnrgb,alpha,
     &                    coeff,alphacd,coefscd,coefpcd,coefdcd,alphaxc,
     &                    coefsxc,coefpxc,coefdxc,cdfitc,xcfita,xcfitb,
     &                    xcfite,xcfitsave,tvector,tveca,tvecb,tvece,
     &                    auxoverlap,grad1,grad2,coord1,coord2,hessian,
     &                    djacobian,atomsymbol)

            stop 'normal'

                      endif

      if(ioptimize.eq.0) then

          call scfcontrol(nfdpbt,nreal,ninteger,nmaxatoms,
     &                    nmaxcontractions,nauxfunctions,nmaxpoints,
     &                    ncontacts,nesppts,nmaxiterations,nfunctional,
     &                    idiis,ngridtype,irandomgrid,ncenters,
     &                    nptcharges,nequivalences,nalpha,nbeta,nconts,
     &                    ncontp,ncontd,ncds,ncdsets-ncds,nxcs,
     &                    nxcsets-nxcs,natomtype,nptsatom,nshels,nshelp,
     &                    nsheld,ilfunc,icfunc,ngaussians,mtloca,
     &                    icdlfunc,icdcfunc,ixclfunc,ixccfunc,nequivvec,
     &                    iwkvec,epsilon,econvergence,dmixing,
     &                    elevelshift,coord,charge,coordptcharge,
     &                    ptcharge,core,focka,fockb,focke,dmta,dmtb,
     &                    coeffa,coeffb,orbnrga,orbnrgb,overlap,alpha,
     &                    coeff,alphacd,coefscd,coefpcd,coefdcd,alphaxc,
     &                    coefsxc,coefpxc,coefdxc,cdfitc,xcfita,xcfitb,
     &                    xcfite,xcfitsave,auxoverlap,tvector,tveca,
     &                    tvecb,tvece,wkvec)

          goto 1013

                    endif

      gradfactor=bignumber

      do 1014 igeom=1,nmaxgeometries

      if(gradfactor.lt.gconvergence) goto 1014

      write(6,1015) igeom
 1015 format(////,' geometry # ',i4,/)

      if(intcoordflag.eq.1) call zmatrix(ncenters,coord,izmat1,izmat2,
     &                                   izmat3,atomsymbol)

      write(6,1016)
 1016 format(' cartesian coordinates :',/)

      do 1017 i=1,ncenters
 1017 write(6,1018) atomsymbol(i),coord(1,i)*bohr,coord(2,i)*bohr,
     &                            coord(3,i)*bohr
 1018 format(5x,a4,2x,3f12.7)

      write(6,1019)
 1019 format()

      call scfcontrol(nfdpbt,nreal,ninteger,nmaxatoms,nmaxcontractions,
     &                nauxfunctions,nmaxpoints,ncontacts,nesppts,
     &                nmaxiterations,nfunctional,idiis,ngridtype,
     &                irandomgrid,ncenters,nptcharges,nequivalences,
     &                nalpha,nbeta,nconts,ncontp,ncontd,ncds,
     &                ncdsets-ncds,nxcs,nxcsets-nxcs,natomtype,nptsatom,
     &                nshels,nshelp,nsheld,ilfunc,icfunc,ngaussians,
     &                mtloca,icdlfunc,icdcfunc,ixclfunc,ixccfunc,
     &                nequivvec,iwkvec,epsilon,econvergence,dmixing,
     &                elevelshift,coord,charge,coordptcharge,ptcharge,
     &                core,focka,fockb,focke,dmta,dmtb,coeffa,coeffb,
     &                orbnrga,orbnrgb,overlap,alpha,coeff,alphacd,
     &                coefscd,coefpcd,coefdcd,alphaxc,coefsxc,coefpxc,
     &                coefdxc,cdfitc,xcfita,xcfitb,xcfite,xcfitsave,
     &                auxoverlap,tvector,tveca,tvecb,tvece,wkvec)

      dmixing=savedmixing

      nlinear=0

      do 1020 i=1,ncenters
      do 1020 j=2,3
 1020 if(abs(coord(j,i)).ge.sqrt(smallnumber)) nlinear=1

      if(nlinear.eq.0) nmodes=3*ncenters-5
      if(nlinear.eq.1) nmodes=3*ncenters-6

      call move(0,igeom,ihessian,nreal,ninteger,nmaxpoints,
     &          nmaxcontractions,ndim,ndegfreedom,nmodes,ncenters,
     &          nalpha,nbeta,ncontractions,nconts,ncontp,ncontd,ncds,
     &          ncdsets-ncds,intfreeze,natomtype,nptsatom,nfuncatom,
     &          izmat1,izmat2,izmat3,nshels,nshelp,nsheld,ilfunc,icfunc,
     &          ngaussians,mtloca,icdlfunc,icdcfunc,iwkvec,gradfactor,
     &          dmaxstep,coordsave,coord,charge,dmta,dmtb,coeffa,coeffb,
     &          orbnrga,orbnrgb,alpha,coeff,cdfitc,alphacd,coefscd,
     &          coefpcd,coefdcd,gradsave,grad,coord1,coord2,grad1,grad2,
     &          hessian,auxoverlap,djacobian,wkvec,atomsymbol)

 1014 continue

      if(gradfactor.lt.gconvergence) then
                                           write(6,1021)
                                     else
                                           write(6,1022)
                                     endif

 1021 format(/,' geometry optimized!!! :-) :-) :-) ')
 1022 format(/,' geometry not optimized??? :-( :-( :-( ')

 1013 continue

      call writet(ncenters,ndegfreedom,ncdfunctions,nxcfunctions,
     &            coordsave,coord,gradsave,grad,hessian,cdfitc,xcfita,
     &            xcfitb,xcfite)

      call rijmat(ncenters,atomsymbol,coord)

      ja=1
      jb=ja+3*nesppts
      jc=jb+4*ncenters**2
      jd=jc+2*ncenters
      je=jd+ncenters
      jf=je+3*ncenters
      jg=jf+ncenters
      jh=jg+3*ncontacts

      call espgen(nreal-jh,ninteger-nesppts,nmaxatoms,ncenters,nesppts,
     &            nalpha,nbeta,nconts,ncontp,ncontd,ncontacts,ilfunc,
     &            ngaussians,icfunc,mtloca,nshels,nshelp,nsheld,
     &            natomtype,iwkvec,nequivalences,nequivvec,
     &            iwkvec(nesppts+1),coord,charge,dmta,dmtb,alpha,coeff,
     &            wkvec(ja),wkvec(jb),wkvec(jc),wkvec(jd),wkvec(je),
     &            wkvec(jf),wkvec(jg),wkvec(jh))

      call ksorbs(nmaxcontractions,nalpha,nbeta,orbnrga,orbnrgb)

      na=ncontractions*(ncontractions+1)/2

      call dipolemm(nreal-na-5,ninteger,ncenters,nconts,ncontp,ncontd,
     &              nshels,nshelp,nsheld,mtloca,ilfunc,ngaussians,
     &              icfunc,iwkvec,wkvec,coord,charge,alpha,coeff,dmta,
     &              dmtb,wkvec(5),wkvec(na+5))

      return
      end
