      subroutine coreps(m,n,ncentr,icontr,inddyy,g,coord,charge,overlap,
     &                  core,zeta,px,py,pz,pxax,pyay,pzaz,eta,base,
     &                  etarr,ss,ss0,ss1,ps,pscond,pxcx,pycy,pzcz,u,
     &                  eta2)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension icontr(*),inddyy(m,*)

      dimension g(*),coord(3,*),charge(*),overlap(*),core(*),zeta(*),
     &          px(*),py(*),pz(*),pxax(*),pyay(*),pzaz(*),eta(*),
     &          base(*),etarr(*),ss(*),ss0(*),ss1(*),ps(n,*),
     &          pscond(m,*),pxcx(*),pycy(*),pzcz(*),u(*),eta2(*)

      data zero,thrhlf,two,three,pi/0.0,1.5,2.0,3.0,3.1415926535898/

      do 1001 i=1,n
 1001 eta2(i)=two*eta(i)

      do 1002 i=1,n
 1002 ss(i)=((pi/zeta(i))**thrhlf)*base(i)

      do 1003 i=1,n
      ps(i,1)=pxax(i)*ss(i)
      ps(i,2)=pyay(i)*ss(i)
 1003 ps(i,3)=pzaz(i)*ss(i)

      do 1004 j=1,3
      do 1004 i=1,m
 1004 pscond(i,j)=zero

      do 1005 j=1,3
      do 1005 i=1,n
 1005 pscond(icontr(i),j)=pscond(icontr(i),j)+ps(i,j)

      do 1006 j=1,3
      do 1006 i=1,m
 1006 overlap(inddyy(i,j))=overlap(inddyy(i,j))+pscond(i,j)

      do 1007 i=1,n
 1007 ss(i)=eta(i)*(three-two*etarr(i))*ss(i)

      do 1008 i=1,n
      ps(i,1)=pxax(i)*ss(i)+eta2(i)*ps(i,1)
      ps(i,2)=pyay(i)*ss(i)+eta2(i)*ps(i,2)
 1008 ps(i,3)=pzaz(i)*ss(i)+eta2(i)*ps(i,3)

      do 1009 j=1,3
      do 1009 i=1,m
 1009 pscond(i,j)=zero

      do 1010 j=1,3
      do 1010 i=1,n
 1010 pscond(icontr(i),j)=pscond(icontr(i),j)+ps(i,j)

      do 1011 j=1,3
      do 1011 i=1,m
 1011 core(inddyy(i,j))=core(inddyy(i,j))+pscond(i,j)

      do 2001 nn=1,ncentr

      ccx=coord(1,nn)
      ccy=coord(2,nn)
      ccz=coord(3,nn)

      twopichrg=two*pi*charge(nn)

      do 2002 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 2002 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      do 2003 i=1,n
      call augg(2,u(i),g)
      ss0(i)=base(i)*g(1)*twopichrg/zeta(i)
 2003 ss1(i)=base(i)*g(2)*twopichrg/zeta(i)

      do 2004 i=1,n
      ps(i,1)=pxax(i)*ss0(i)-pxcx(i)*ss1(i)
      ps(i,2)=pyay(i)*ss0(i)-pycy(i)*ss1(i)
 2004 ps(i,3)=pzaz(i)*ss0(i)-pzcz(i)*ss1(i)

      do 2005 j=1,3
      do 2005 i=1,m
 2005 pscond(i,j)=zero

      do 2006 j=1,3
      do 2006 i=1,n
 2006 pscond(icontr(i),j)=pscond(icontr(i),j)+ps(i,j)

      do 2007 j=1,3
      do 2007 i=1,m
 2007 core(inddyy(i,j))=core(inddyy(i,j))-pscond(i,j)

 2001 continue

      return
      end
