      subroutine corepp(m,n,ncentr,iminj,icontr,inddyy,g,coord,charge,
     &                  overlap,core,zeta,axbx,ayby,azbz,px,py,pz,pxax,
     &                  pyay,pzaz,pxbx,pyby,pzbz,eta,base,etarr,ss,ss0,
     &                  ss1,ss2,ps,ps0,ps1,pscond,ds0,dscond,pp,ppcond,
     &                  c,pxcx,pycy,pzcz,u,twozeta,eta2)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iminj(*),icontr(*),inddyy(m,*)

      dimension g(*),coord(3,*),charge(*),overlap(*),core(*),zeta(*),
     &          axbx(*),ayby(*),azbz(*),px(*),py(*),pz(*),pxax(*),
     &          pyay(*),pzaz(*),pxbx(*),pyby(*),pzbz(*),eta(*),base(*),
     &          etarr(*),ss(*),ss0(*),ss1(*),ss2(*),ps(n,*),ps0(n,*),
     &          ps1(n,*),pscond(m,*),ds0(n,*),dscond(m,*),pp(n,*),
     &          ppcond(m,*),c(*),pxcx(*),pycy(*),pzcz(*),u(*),
     &          twozeta(*),eta2(*)

      data zero,thrhlf,two,three,pi/0.0,1.5,2.0,3.0,3.1415926535898/

      do 1001 i=1,n
      eta2(i)=two*eta(i)
 1001 twozeta(i)=two*zeta(i)

      do 1002 i=1,n
 1002 ss0(i)=((pi/zeta(i))**thrhlf)*base(i)

      do 1003 i=1,n
      ps0(i,1)=pxax(i)*ss0(i)
      ps0(i,2)=pyay(i)*ss0(i)
 1003 ps0(i,3)=pzaz(i)*ss0(i)

      do 1004 i=1,n
 1004 c(i)=ss0(i)/twozeta(i)

      do 1005 i=1,n
      pp(i,1)=pxbx(i)*ps0(i,1)+c(i)
      pp(i,2)=pyby(i)*ps0(i,1)
      pp(i,3)=pzbz(i)*ps0(i,1)
      pp(i,4)=pxbx(i)*ps0(i,2)
      pp(i,5)=pyby(i)*ps0(i,2)+c(i)
      pp(i,6)=pzbz(i)*ps0(i,2)
      pp(i,7)=pxbx(i)*ps0(i,3)
      pp(i,8)=pyby(i)*ps0(i,3)
 1005 pp(i,9)=pzbz(i)*ps0(i,3)+c(i)

      do 1006 j=1,9
      do 1006 i=1,m
 1006 ppcond(i,j)=zero

      do 1007 j=1,9
      do 1007 i=1,n
 1007 ppcond(icontr(i),j)=ppcond(icontr(i),j)+pp(i,j)

      do 1008 i=1,m
      overlap(inddyy(i,1))=overlap(inddyy(i,1))+ppcond(i,1)
      overlap(inddyy(i,4))=overlap(inddyy(i,4))+ppcond(i,4)
      overlap(inddyy(i,5))=overlap(inddyy(i,5))+ppcond(i,5)
      overlap(inddyy(i,7))=overlap(inddyy(i,7))+ppcond(i,7)
      overlap(inddyy(i,8))=overlap(inddyy(i,8))+ppcond(i,8)
 1008 overlap(inddyy(i,9))=overlap(inddyy(i,9))+ppcond(i,9)

      do 1009 i=1,m
      if(iminj(i).ne.0) then

                 overlap(inddyy(i,2))=overlap(inddyy(i,2))+ppcond(i,2)
                 overlap(inddyy(i,3))=overlap(inddyy(i,3))+ppcond(i,3)
                 overlap(inddyy(i,6))=overlap(inddyy(i,6))+ppcond(i,6)

                        endif
 1009 continue

      do 1010 i=1,n
 1010 ss(i)=eta(i)*(three-two*etarr(i))*ss0(i)

      do 1011 i=1,n
      ps(i,1)=pxax(i)*ss(i)+eta2(i)*ps0(i,1)
      ps(i,2)=pyay(i)*ss(i)+eta2(i)*ps0(i,2)
 1011 ps(i,3)=pzaz(i)*ss(i)+eta2(i)*ps0(i,3)

      do 1012 i=1,n
 1012 c(i)=ss(i)/twozeta(i)

      do 1013 i=1,n
      pp(i,1)=pxbx(i)*ps(i,1)+eta2(i)*pp(i,1)+c(i)
      pp(i,2)=pyby(i)*ps(i,1)+eta2(i)*pp(i,2)
      pp(i,3)=pzbz(i)*ps(i,1)+eta2(i)*pp(i,3)
      pp(i,4)=pxbx(i)*ps(i,2)+eta2(i)*pp(i,4)
      pp(i,5)=pyby(i)*ps(i,2)+eta2(i)*pp(i,5)+c(i)
      pp(i,6)=pzbz(i)*ps(i,2)+eta2(i)*pp(i,6)
      pp(i,7)=pxbx(i)*ps(i,3)+eta2(i)*pp(i,7)
      pp(i,8)=pyby(i)*ps(i,3)+eta2(i)*pp(i,8)
 1013 pp(i,9)=pzbz(i)*ps(i,3)+eta2(i)*pp(i,9)+c(i)

      do 1014 j=1,9
      do 1014 i=1,m
 1014 ppcond(i,j)=zero

      do 1015 j=1,9
      do 1015 i=1,n
 1015 ppcond(icontr(i),j)=ppcond(icontr(i),j)+pp(i,j)

      do 1016 i=1,m
      core(inddyy(i,1))=core(inddyy(i,1))+ppcond(i,1)
      core(inddyy(i,4))=core(inddyy(i,4))+ppcond(i,4)
      core(inddyy(i,5))=core(inddyy(i,5))+ppcond(i,5)
      core(inddyy(i,7))=core(inddyy(i,7))+ppcond(i,7)
      core(inddyy(i,8))=core(inddyy(i,8))+ppcond(i,8)
 1016 core(inddyy(i,9))=core(inddyy(i,9))+ppcond(i,9)

      do 1017 i=1,m
      if(iminj(i).ne.0) then

                       core(inddyy(i,2))=core(inddyy(i,2))+ppcond(i,2)
                       core(inddyy(i,3))=core(inddyy(i,3))+ppcond(i,3)
                       core(inddyy(i,6))=core(inddyy(i,6))+ppcond(i,6)

                        endif
 1017 continue

      do 2001 nn=1,ncentr

      ccx=coord(1,nn)
      ccy=coord(2,nn)
      ccz=coord(3,nn)

      twopichrg=two*pi*charge(nn)

      do 2002 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 2002 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      do 2003 i=1,n
      call augg(3,u(i),g)
      ss0(i)=base(i)*g(1)*twopichrg/zeta(i)
      ss1(i)=base(i)*g(2)*twopichrg/zeta(i)
 2003 ss2(i)=base(i)*g(3)*twopichrg/zeta(i)

      do 2004 i=1,n

      ps0(i,1)=pxax(i)*ss0(i)-pxcx(i)*ss1(i)
      ps0(i,2)=pyay(i)*ss0(i)-pycy(i)*ss1(i)
      ps0(i,3)=pzaz(i)*ss0(i)-pzcz(i)*ss1(i)

      ps1(i,1)=pxax(i)*ss1(i)-pxcx(i)*ss2(i)
      ps1(i,2)=pyay(i)*ss1(i)-pycy(i)*ss2(i)
      ps1(i,3)=pzaz(i)*ss1(i)-pzcz(i)*ss2(i)

 2004 continue

      do 2005 i=1,n
 2005 c(i)=(ss0(i)-ss1(i))/twozeta(i)

      do 2006 i=1,n
      ds0(i,1)=pxax(i)*ps0(i,1)-pxcx(i)*ps1(i,1)+c(i)
      ds0(i,2)=pyay(i)*ps0(i,1)-pycy(i)*ps1(i,1)
      ds0(i,3)=pzaz(i)*ps0(i,1)-pzcz(i)*ps1(i,1)
      ds0(i,4)=pyay(i)*ps0(i,2)-pycy(i)*ps1(i,2)+c(i)
      ds0(i,5)=pzaz(i)*ps0(i,2)-pzcz(i)*ps1(i,2)
 2006 ds0(i,6)=pzaz(i)*ps0(i,3)-pzcz(i)*ps1(i,3)+c(i)

      do 2007 j=1,3
      do 2007 i=1,m
 2007 pscond(i,j)=zero

      do 2008 j=1,3
      do 2008 i=1,n
 2008 pscond(icontr(i),j)=pscond(icontr(i),j)+ps0(i,j)

      do 2009 j=1,6
      do 2009 i=1,m
 2009 dscond(i,j)=zero

      do 2010 j=1,6
      do 2010 i=1,n
 2010 dscond(icontr(i),j)=dscond(icontr(i),j)+ds0(i,j)

      do 2011 i=1,m
      ppcond(i,1)=axbx(i)*pscond(i,1)+dscond(i,1)
      ppcond(i,2)=ayby(i)*pscond(i,1)+dscond(i,2)
      ppcond(i,3)=azbz(i)*pscond(i,1)+dscond(i,3)
      ppcond(i,4)=axbx(i)*pscond(i,2)+dscond(i,2)
      ppcond(i,5)=ayby(i)*pscond(i,2)+dscond(i,4)
      ppcond(i,6)=azbz(i)*pscond(i,2)+dscond(i,5)
      ppcond(i,7)=axbx(i)*pscond(i,3)+dscond(i,3)
      ppcond(i,8)=ayby(i)*pscond(i,3)+dscond(i,5)
 2011 ppcond(i,9)=azbz(i)*pscond(i,3)+dscond(i,6)

      do 2012 i=1,m
      core(inddyy(i,1))=core(inddyy(i,1))-ppcond(i,1)
      core(inddyy(i,4))=core(inddyy(i,4))-ppcond(i,4)
      core(inddyy(i,5))=core(inddyy(i,5))-ppcond(i,5)
      core(inddyy(i,7))=core(inddyy(i,7))-ppcond(i,7)
      core(inddyy(i,8))=core(inddyy(i,8))-ppcond(i,8)
 2012 core(inddyy(i,9))=core(inddyy(i,9))-ppcond(i,9)

      do 2013 i=1,m
      if(iminj(i).ne.0) then

                       core(inddyy(i,2))=core(inddyy(i,2))-ppcond(i,2)
                       core(inddyy(i,3))=core(inddyy(i,3))-ppcond(i,3)
                       core(inddyy(i,6))=core(inddyy(i,6))-ppcond(i,6)

                        endif
 2013 continue

 2001 continue

      return
      end
