      subroutine compg0(ncntrt,npts,ndm,nconts,ncontp,ncontd,ilfunc,
     &                  icfunc,ngauss,nptrs,nptrp,nptrd,cent,alpha,
     &                  coeff,x,y,z,qf,xx,yy,zz,rr,rralpha,s,dxx,dxy,
     &                  dxz,dyy,dyz,dzz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)

      dimension cent(3,*),alpha(*),coeff(*)

      dimension x(*),y(*),z(*),qf(ndm,*)

      dimension xx(*),yy(*),zz(*),rr(*),rralpha(*)
      dimension s(*),dxx(*),dxy(*),dxz(*),dyy(*),dyz(*),dzz(*)

      data zero,one,two,three,expcut/0.0,1.0,2.0,3.0,80.0/

      rsqrt3=one/sqrt(three)

      do 1001 i=1,ncntrt
      do 1001 j=1,ndm
 1001 qf(j,i)=zero

      k=0

c  loop over s functions

      if(nconts.eq.0) return

      do 1002 i=1,nconts

      ilabel=nptrs(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      do 1003 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1003 zz(j)=z(j)-cent(3,nc)

      do 1004 j=1,npts
 1004 rr(j)=xx(j)*xx(j)+yy(j)*yy(j)+zz(j)*zz(j)

      do 1005 nprimitive=iptr1,iptr2

      do 1006 j=1,npts
 1006 rralpha(j)=rr(j)*alpha(nprimitive)

      do 1007 j=1,npts
 1007 if(rralpha(j).lt.expcut) qf(j,k+1)=qf(j,k+1)
     &                             +coeff(nprimitive)*exp(-rralpha(j))

 1005 continue

 1002 k=k+1

c  loop over p functions

      if(ncontp.eq.0) return

      do 1011 i=1,ncontp

      ilabel=nptrp(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      do 1012 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1012 zz(j)=z(j)-cent(3,nc)

      do 1013 j=1,npts
 1013 rr(j)=xx(j)*xx(j)+yy(j)*yy(j)+zz(j)*zz(j)

      do 1014 nprimitive=iptr1,iptr2

      do 1015 j=1,npts
 1015 rralpha(j)=rr(j)*alpha(nprimitive)

      do 1016 j=1,npts
      if(rralpha(j).lt.expcut) then

                     s(j)=coeff(nprimitive)*exp(-rralpha(j))

                     qf(j,k+1)=qf(j,k+1)+xx(j)*s(j)
                     qf(j,k+2)=qf(j,k+2)+yy(j)*s(j)
                     qf(j,k+3)=qf(j,k+3)+zz(j)*s(j)

                               endif
 1016 continue

 1014 continue

 1011 k=k+3

c  loop over d functions

      if(ncontd.eq.0) return

      do 1021 i=1,ncontd

      ilabel=nptrd(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      nc=icfunc(ilabel)

      do 1022 j=1,npts
      xx(j)=x(j)-cent(1,nc)
      yy(j)=y(j)-cent(2,nc)
 1022 zz(j)=z(j)-cent(3,nc)

      do 1023 j=1,npts
      dxx(j)=xx(j)*xx(j)
      dxy(j)=xx(j)*yy(j)
      dxz(j)=xx(j)*zz(j)
      dyy(j)=yy(j)*yy(j)
      dyz(j)=yy(j)*zz(j)
 1023 dzz(j)=zz(j)*zz(j)

      do 1024 j=1,npts
 1024 rr(j)=dxx(j)+dyy(j)+dzz(j)

      do 1025 nprimitive=iptr1,iptr2

      do 1026 j=1,npts
 1026 rralpha(j)=rr(j)*alpha(nprimitive)

      do 1027 j=1,npts
      if(rralpha(j).lt.expcut) then

                     s(j)=coeff(nprimitive)*exp(-rralpha(j))

                     qf(j,k+1)=qf(j,k+1)+dxx(j)*s(j)
                     qf(j,k+2)=qf(j,k+2)+dxy(j)*s(j)
                     qf(j,k+3)=qf(j,k+3)+dxz(j)*s(j)
                     qf(j,k+4)=qf(j,k+4)+dyy(j)*s(j)
                     qf(j,k+5)=qf(j,k+5)+dyz(j)*s(j)
                     qf(j,k+6)=qf(j,k+6)+dzz(j)*s(j)

                             endif
 1027 continue

 1025 continue

      do 1028 j=1,npts
      qf(j,k+1)=qf(j,k+1)*rsqrt3
      qf(j,k+4)=qf(j,k+4)*rsqrt3
 1028 qf(j,k+6)=qf(j,k+6)*rsqrt3

 1021 k=k+6

      return
      end
