      subroutine cdovxs(ncds,ncdspd,ndim,ilfunc,icfunc,alpha,coeffs,
     &                  coeffp,coeffd,cdsmat,cent)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension g(13)

      dimension ilfunc(*),icfunc(*)

      dimension alpha(*),coeffs(*),coeffp(*),coeffd(*),cdsmat(ndim,*)
      dimension cent(3,*)

      data one,two,three,four,five,forty9/1.0,2.0,3.0,4.0,5.0,49.0/
      data pi/3.1415926535898/

      sqrt493=sqrt(forty9/three)

      factor=(pi**(five/four)*sqrt(two))**2

      do 1001 i=1,ncdspd

      ilabel=ilfunc(ncds+i)

      nc1=icfunc(ilabel)

      zetaa=alpha(ilabel)

      do 1001 j=1,ncds

      jlabel=ilfunc(j)

      nc2=icfunc(jlabel)

      zetab=alpha(jlabel)

      zetaab=one/(zetaa+zetab)

      wxpx=(zetaa*cent(1,nc1)+zetab*cent(1,nc2))*zetaab-cent(1,nc1)
      wypy=(zetaa*cent(2,nc1)+zetab*cent(2,nc2))*zetaab-cent(2,nc1)
      wzpz=(zetaa*cent(3,nc1)+zetab*cent(3,nc2))*zetaab-cent(3,nc1)

      axbx=cent(1,nc1)-cent(1,nc2)
      ayby=cent(2,nc1)-cent(2,nc2)
      azbz=cent(3,nc1)-cent(3,nc2)

      u=zetaa*zetab*zetaab*(axbx*axbx+ayby*ayby+azbz*azbz)

      call augg(3,u,g)

      sasa0=g(1)*factor*sqrt(zetaab)/(zetaa*zetab)
      sasa1=g(2)*factor*sqrt(zetaab)/(zetaa*zetab)
      sasa2=g(3)*factor*sqrt(zetaab)/(zetaa*zetab)

      pasa0=wxpx*sasa1
      pbsa0=wypy*sasa1
      pcsa0=wzpz*sasa1

      pasa1=wxpx*sasa2
      pbsa1=wypy*sasa2
      pcsa1=wzpz*sasa2

      corr=(sasa0-zetab*zetaab*sasa1)/(two*zetaa)

      dasa0=wxpx*pasa1+corr
      dbsa0=wypy*pasa1
      dcsa0=wzpz*pasa1
      ddsa0=wypy*pbsa1+corr
      desa0=wzpz*pbsa1
      dfsa0=wzpz*pcsa1+corr

      n=ncds+10*(i-1)

      cdsmat(n+01,j)=coeffs(ilabel)*coeffs(jlabel)*sasa0
      cdsmat(n+02,j)=coeffp(ilabel)*coeffs(jlabel)*pasa0
      cdsmat(n+03,j)=coeffp(ilabel)*coeffs(jlabel)*pbsa0
      cdsmat(n+04,j)=coeffp(ilabel)*coeffs(jlabel)*pcsa0
      cdsmat(n+05,j)=coeffd(ilabel)*coeffs(jlabel)*dasa0/sqrt493
      cdsmat(n+06,j)=coeffd(ilabel)*coeffs(jlabel)*dbsa0
      cdsmat(n+07,j)=coeffd(ilabel)*coeffs(jlabel)*dcsa0
      cdsmat(n+08,j)=coeffd(ilabel)*coeffs(jlabel)*ddsa0/sqrt493
      cdsmat(n+09,j)=coeffd(ilabel)*coeffs(jlabel)*desa0
      cdsmat(n+10,j)=coeffd(ilabel)*coeffs(jlabel)*dfsa0/sqrt493

 1001 continue

      return
      end
