      subroutine ang26(x,y,z,weight)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xunit(26),yunit(26),zunit(26)

      dimension x(*),y(*),z(*),weight(*)

      data xunit/  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,
     &             0.0,  0.0,  0.0,  0.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0/

      data yunit/  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,
     &             1.0, -1.0,  1.0, -1.0,  0.0,  0.0,
     &             0.0,  0.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0/

      data zunit/  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0,
     &            -1.0, -1.0,  0.0,  0.0,  0.0,  0.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0/

      data wght1,wght2,wght3/0.04761904615385,
     &                       0.03809523846154,
     &                       0.03214285769231/

      data one,two,three/1.0,2.0,3.0/

      rsqrt2=one/sqrt(two)
      rsqrt3=one/sqrt(three)

      do 1001 i=1,6
 1001 weight(i)=wght1

      do 1002 i=7,18
 1002 weight(i)=wght2

      do 1003 i=19,26
 1003 weight(i)=wght3

      do 1004 i=1,6
      x(i)=xunit(i)
      y(i)=yunit(i)
 1004 z(i)=zunit(i)

      do 1005 i=7,18
      x(i)=rsqrt2*xunit(i)
      y(i)=rsqrt2*yunit(i)
 1005 z(i)=rsqrt2*zunit(i)

      do 1006 i=19,26
      x(i)=rsqrt3*xunit(i)
      y(i)=rsqrt3*yunit(i)
 1006 z(i)=rsqrt3*zunit(i)

      return
      end
