      subroutine xyzfint(nn,di,dc,izmat1,izmat2,izmat3)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension di(*),dc(3,*)
      dimension izmat1(*),izmat2(*),izmat3(*)

      data zero/0.0/

      do 1001 n=1,nn

      i=izmat1(n)
      j=izmat2(n)
      k=izmat3(n)

      if(n.eq.1) then
                       dc(1,n)=zero
                       dc(2,n)=zero
                       dc(3,n)=zero
                 endif

      if(n.eq.2) then
                       bondl=di(1)

                       dc(1,n)=bondl
                       dc(2,n)=zero
                       dc(3,n)=zero
                 endif

      if(n.eq.3) then
                       bondl=di(2)
                       bangle=di(3)

                       xo=dc(1,i)
                       yo=dc(2,i)
                       zo=dc(3,i)

                       if(i.eq.1) dc(1,n)=xo+bondl*cos(bangle)
                       if(i.eq.2) dc(1,n)=xo-bondl*cos(bangle)
                       dc(2,n)=yo+bondl*sin(bangle)
                       dc(3,n)=zero
                 endif

      if(n.ge.4) then
                       bondl=di(3*(n-3)+1)
                       bangle=di(3*(n-3)+2)
                       dangle=di(3*(n-3)+3)
 
                       xo=dc(1,i)
                       yo=dc(2,i)
                       zo=dc(3,i)

                       xa=dc(1,j)-dc(1,i)
                       ya=dc(2,j)-dc(2,i)
                       za=dc(3,j)-dc(3,i)

                       rr=sqrt(xa*xa+ya*ya+za*za)

                       xa=xa/rr
                       ya=ya/rr
                       za=za/rr

                       xb=dc(1,j)-dc(1,k)
                       yb=dc(2,j)-dc(2,k)
                       zb=dc(3,j)-dc(3,k)

                       xc=ya*zb-za*yb
                       yc=za*xb-xa*zb
                       zc=xa*yb-ya*xb

                       rr=sqrt(xc*xc+yc*yc+zc*zc)

                       xc=xc/rr
                       yc=yc/rr
                       zc=zc/rr

                       xb=ya*zc-za*yc
                       yb=za*xc-xa*zc
                       zb=xa*yc-ya*xc

                       zzz=bondl*cos(bangle)
                       xxx=bondl*sin(bangle)*cos(dangle)
                       yyy=bondl*sin(bangle)*sin(dangle)

                       dc(1,n)=xo+xa*zzz+xb*xxx+xc*yyy
                       dc(2,n)=yo+ya*zzz+yb*xxx+yc*yyy
                       dc(3,n)=zo+za*zzz+zb*xxx+zc*yyy
                 endif

 1001 continue

      return
      end
