      subroutine xcordd(m,n,nxcs,nxcspd,ilfunc,icfunc,iminj,icontr,
     &                  iicontr,inddyy,coord,xcfit1,xcfit2,xcfit3,
     &                  alphaaux,coeffs,coeffp,coeffd,fock1,fock2,fock3,
     &                  zeta,ax,ay,az,axbx,ayby,azbz,px,py,pz,base,
     &                  zetarec,zetafac,efac,gxax,gyay,gzaz,sss,pss,dss,
     &                  dsscond,fss,fsscond,gss,gsscond,hss,hsscond,qss,
     &                  qsscond,dps,dds,ddp,ddd,fps,fds,fdp,gps,gds,hps,
     &                  c,c1,c2,c3,c4,zzeta,aax,aay,aaz,ppx,ppy,ppz,
     &                  axcx,aycy,azcz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xcft1p(3),xcft2p(3),xcft3p(3),
     &          xcft1d(6),xcft2d(6),xcft3d(6)

      dimension ilfunc(*),icfunc(*),iminj(*),icontr(*),iicontr(*),
     &          inddyy(m,*)

      dimension coord(3,*),xcfit1(*),xcfit2(*),xcfit3(*),alphaaux(*),
     &          coeffs(*),coeffp(*),coeffd(*),fock1(*),fock2(*),
     &          fock3(*),zeta(*),ax(*),ay(*),az(*),axbx(*),ayby(*),
     &          azbz(*),px(*),py(*),pz(*),base(*),zetarec(*),zetafac(*),
     &          efac(*),gxax(*),gyay(*),gzaz(*),sss(*),pss(n,*),
     &          dss(n,*),dsscond(m,*),fss(n,*),fsscond(m,*),gss(n,*),
     &          gsscond(m,*),hss(n,*),hsscond(m,*),qss(n,*),
     &          qsscond(m,*),dps(m,*),dds(m,*),ddp(m,*),ddd(m,*),
     &          fps(m,*),fds(m,*),fdp(m,*),gps(m,*),gds(m,*),hps(m,*),
     &          c(*),c1(n,*),c2(n,*),c3(n,*),c4(n,*),zzeta(*),aax(*),
     &          aay(*),aaz(*),ppx(*),ppy(*),ppz(*),axcx(*),aycy(*),
     &          azcz(*)

      data zero,one,two,three,four,five/0.0,1.0,2.0,3.0,4.0,5.0/
      data expcut,calcut/80.0,1.0e-16/

      sqrt3=sqrt(three)

      do 1001 naux=1,nxcs

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(naux)*coeffs(ilaux)
      xcft2s=xcfit2(naux)*coeffs(ilaux)
      xcft3s=xcfit3(naux)*coeffs(ilaux)

      do 1002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      sss(i)=zero
 1004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 1005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 1005 continue

      do 1006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 1006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 1007 i=1,nn
 1007 zetarec(i)=zetarec(i)/two

      do 1008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 1008 pss(i,3)=gzaz(i)*sss(i)

      do 1009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 1009 continue

      do 1010 j=1,3
      do 1010 i=1,nn
 1010 c1(i,j)=zetarec(i)*pss(i,j)

      do 1011 i=1,nn
      fss(i,01)=gxax(i)*dss(i,1)+c1(i,1)+c1(i,1)
      fss(i,02)=gyay(i)*dss(i,1)
      fss(i,03)=gzaz(i)*dss(i,1)
      fss(i,04)=gyay(i)*dss(i,2)+c1(i,1)
      fss(i,05)=gzaz(i)*dss(i,2)
      fss(i,06)=gzaz(i)*dss(i,3)+c1(i,1)
      fss(i,07)=gyay(i)*dss(i,4)+c1(i,2)+c1(i,2)
      fss(i,08)=gzaz(i)*dss(i,4)
      fss(i,09)=gzaz(i)*dss(i,5)+c1(i,2)
 1011 fss(i,10)=gzaz(i)*dss(i,6)+c1(i,3)+c1(i,3)

      do 1012 j=1,6
      do 1012 i=1,nn
 1012 c2(i,j)=zetarec(i)*dss(i,j)


      do 1013 i=1,nn
      gss(i,01)=gxax(i)*fss(i,01)+c2(i,1)*three
      gss(i,02)=gyay(i)*fss(i,01)
      gss(i,03)=gzaz(i)*fss(i,01)
      gss(i,04)=gyay(i)*fss(i,02)+c2(i,1)
      gss(i,05)=gzaz(i)*fss(i,02)
      gss(i,06)=gzaz(i)*fss(i,03)+c2(i,1)
      gss(i,07)=gyay(i)*fss(i,04)+c2(i,2)*two
      gss(i,08)=gzaz(i)*fss(i,04)
      gss(i,09)=gzaz(i)*fss(i,05)+c2(i,2)
      gss(i,10)=gzaz(i)*fss(i,06)+c2(i,3)*two
      gss(i,11)=gyay(i)*fss(i,07)+c2(i,4)*three
      gss(i,12)=gzaz(i)*fss(i,07)
      gss(i,13)=gzaz(i)*fss(i,08)+c2(i,4)
      gss(i,14)=gzaz(i)*fss(i,09)+c2(i,5)*two
 1013 gss(i,15)=gzaz(i)*fss(i,10)+c2(i,6)*three

      do 1014 j=1,6
      do 1014 i=1,m
 1014 dsscond(i,j)=zero

      do 1015 j=1,10
      do 1015 i=1,m
 1015 fsscond(i,j)=zero

      do 1016 j=1,15
      do 1016 i=1,m
 1016 gsscond(i,j)=zero

      do 1017 j=1,6
      do 1017 i=1,nn
 1017 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss(i,j)

      do 1018 j=1,10
      do 1018 i=1,nn
 1018 fsscond(iicontr(i),j)=fsscond(iicontr(i),j)+fss(i,j)

      do 1019 j=1,15
      do 1019 i=1,nn
 1019 gsscond(iicontr(i),j)=gsscond(iicontr(i),j)+gss(i,j)

      do 1020 i=1,m
      dps(i,01)=axbx(i)*dsscond(i,1)+fsscond(i,01)
      dps(i,02)=ayby(i)*dsscond(i,1)+fsscond(i,02)
      dps(i,03)=azbz(i)*dsscond(i,1)+fsscond(i,03)
      dps(i,04)=axbx(i)*dsscond(i,2)+fsscond(i,02)
      dps(i,05)=ayby(i)*dsscond(i,2)+fsscond(i,04)
      dps(i,06)=azbz(i)*dsscond(i,2)+fsscond(i,05)
      dps(i,07)=axbx(i)*dsscond(i,3)+fsscond(i,03)
      dps(i,08)=ayby(i)*dsscond(i,3)+fsscond(i,05)
      dps(i,09)=azbz(i)*dsscond(i,3)+fsscond(i,06)
      dps(i,10)=axbx(i)*dsscond(i,4)+fsscond(i,04)
      dps(i,11)=ayby(i)*dsscond(i,4)+fsscond(i,07)
      dps(i,12)=azbz(i)*dsscond(i,4)+fsscond(i,08)
      dps(i,13)=axbx(i)*dsscond(i,5)+fsscond(i,05)
      dps(i,14)=ayby(i)*dsscond(i,5)+fsscond(i,08)
      dps(i,15)=azbz(i)*dsscond(i,5)+fsscond(i,09)
      dps(i,16)=axbx(i)*dsscond(i,6)+fsscond(i,06)
      dps(i,17)=ayby(i)*dsscond(i,6)+fsscond(i,09)
 1020 dps(i,18)=azbz(i)*dsscond(i,6)+fsscond(i,10)

      do 1021 i=1,m
      fps(i,01)=axbx(i)*fsscond(i,01)+gsscond(i,01)
      fps(i,02)=ayby(i)*fsscond(i,01)+gsscond(i,02)
      fps(i,03)=azbz(i)*fsscond(i,01)+gsscond(i,03)
      fps(i,04)=axbx(i)*fsscond(i,02)+gsscond(i,02)
      fps(i,05)=ayby(i)*fsscond(i,02)+gsscond(i,04)
      fps(i,06)=azbz(i)*fsscond(i,02)+gsscond(i,05)
      fps(i,07)=axbx(i)*fsscond(i,03)+gsscond(i,03)
      fps(i,08)=ayby(i)*fsscond(i,03)+gsscond(i,05)
      fps(i,09)=azbz(i)*fsscond(i,03)+gsscond(i,06)
      fps(i,10)=axbx(i)*fsscond(i,04)+gsscond(i,04)
      fps(i,11)=ayby(i)*fsscond(i,04)+gsscond(i,07)
      fps(i,12)=azbz(i)*fsscond(i,04)+gsscond(i,08)
      fps(i,13)=axbx(i)*fsscond(i,05)+gsscond(i,05)
      fps(i,14)=ayby(i)*fsscond(i,05)+gsscond(i,08)
      fps(i,15)=azbz(i)*fsscond(i,05)+gsscond(i,09)
      fps(i,16)=axbx(i)*fsscond(i,06)+gsscond(i,06)
      fps(i,17)=ayby(i)*fsscond(i,06)+gsscond(i,09)
      fps(i,18)=azbz(i)*fsscond(i,06)+gsscond(i,10)
      fps(i,19)=axbx(i)*fsscond(i,07)+gsscond(i,07)
      fps(i,20)=ayby(i)*fsscond(i,07)+gsscond(i,11)
      fps(i,21)=azbz(i)*fsscond(i,07)+gsscond(i,12)
      fps(i,22)=axbx(i)*fsscond(i,08)+gsscond(i,08)
      fps(i,23)=ayby(i)*fsscond(i,08)+gsscond(i,12)
      fps(i,24)=azbz(i)*fsscond(i,08)+gsscond(i,13)
      fps(i,25)=axbx(i)*fsscond(i,09)+gsscond(i,09)
      fps(i,26)=ayby(i)*fsscond(i,09)+gsscond(i,13)
      fps(i,27)=azbz(i)*fsscond(i,09)+gsscond(i,14)
      fps(i,28)=axbx(i)*fsscond(i,10)+gsscond(i,10)
      fps(i,29)=ayby(i)*fsscond(i,10)+gsscond(i,14)
 1021 fps(i,30)=azbz(i)*fsscond(i,10)+gsscond(i,15)

      do 1022 i=1,m
      dds(i,01)=axbx(i)*dps(i,01)+fps(i,01)
      dds(i,02)=ayby(i)*dps(i,01)+fps(i,04)
      dds(i,03)=azbz(i)*dps(i,01)+fps(i,07)
      dds(i,04)=ayby(i)*dps(i,02)+fps(i,05)
      dds(i,05)=azbz(i)*dps(i,02)+fps(i,08)
      dds(i,06)=azbz(i)*dps(i,03)+fps(i,09)
      dds(i,07)=axbx(i)*dps(i,04)+fps(i,04)
      dds(i,08)=ayby(i)*dps(i,04)+fps(i,10)
      dds(i,09)=azbz(i)*dps(i,04)+fps(i,13)
      dds(i,10)=ayby(i)*dps(i,05)+fps(i,11)
      dds(i,11)=azbz(i)*dps(i,05)+fps(i,14)
      dds(i,12)=azbz(i)*dps(i,06)+fps(i,15)
      dds(i,13)=axbx(i)*dps(i,07)+fps(i,07)
      dds(i,14)=ayby(i)*dps(i,07)+fps(i,13)
      dds(i,15)=azbz(i)*dps(i,07)+fps(i,16)
      dds(i,16)=ayby(i)*dps(i,08)+fps(i,14)
      dds(i,17)=azbz(i)*dps(i,08)+fps(i,17)
      dds(i,18)=azbz(i)*dps(i,09)+fps(i,18)
      dds(i,19)=axbx(i)*dps(i,10)+fps(i,10)
      dds(i,20)=ayby(i)*dps(i,10)+fps(i,19)
      dds(i,21)=azbz(i)*dps(i,10)+fps(i,22)
      dds(i,22)=ayby(i)*dps(i,11)+fps(i,20)
      dds(i,23)=azbz(i)*dps(i,11)+fps(i,23)
      dds(i,24)=azbz(i)*dps(i,12)+fps(i,24)
      dds(i,25)=axbx(i)*dps(i,13)+fps(i,13)
      dds(i,26)=ayby(i)*dps(i,13)+fps(i,22)
      dds(i,27)=azbz(i)*dps(i,13)+fps(i,25)
      dds(i,28)=ayby(i)*dps(i,14)+fps(i,23)
      dds(i,29)=azbz(i)*dps(i,14)+fps(i,26)
      dds(i,30)=azbz(i)*dps(i,15)+fps(i,27)
      dds(i,31)=axbx(i)*dps(i,16)+fps(i,16)
      dds(i,32)=ayby(i)*dps(i,16)+fps(i,25)
      dds(i,33)=azbz(i)*dps(i,16)+fps(i,28)
      dds(i,34)=ayby(i)*dps(i,17)+fps(i,26)
      dds(i,35)=azbz(i)*dps(i,17)+fps(i,29)
 1022 dds(i,36)=azbz(i)*dps(i,18)+fps(i,30)

      do 1023 i=1,m

      fock1(inddyy(i,01))=fock1(inddyy(i,01))+dds(i,01)*xcft1s
      fock1(inddyy(i,07))=fock1(inddyy(i,07))+dds(i,07)*xcft1s
      fock1(inddyy(i,08))=fock1(inddyy(i,08))+dds(i,08)*xcft1s
      fock1(inddyy(i,13))=fock1(inddyy(i,13))+dds(i,13)*xcft1s
      fock1(inddyy(i,14))=fock1(inddyy(i,14))+dds(i,14)*xcft1s
      fock1(inddyy(i,15))=fock1(inddyy(i,15))+dds(i,15)*xcft1s
      fock1(inddyy(i,19))=fock1(inddyy(i,19))+dds(i,19)*xcft1s
      fock1(inddyy(i,20))=fock1(inddyy(i,20))+dds(i,20)*xcft1s
      fock1(inddyy(i,21))=fock1(inddyy(i,21))+dds(i,21)*xcft1s
      fock1(inddyy(i,22))=fock1(inddyy(i,22))+dds(i,22)*xcft1s
      fock1(inddyy(i,25))=fock1(inddyy(i,25))+dds(i,25)*xcft1s
      fock1(inddyy(i,26))=fock1(inddyy(i,26))+dds(i,26)*xcft1s
      fock1(inddyy(i,27))=fock1(inddyy(i,27))+dds(i,27)*xcft1s
      fock1(inddyy(i,28))=fock1(inddyy(i,28))+dds(i,28)*xcft1s
      fock1(inddyy(i,29))=fock1(inddyy(i,29))+dds(i,29)*xcft1s
      fock1(inddyy(i,31))=fock1(inddyy(i,31))+dds(i,31)*xcft1s
      fock1(inddyy(i,32))=fock1(inddyy(i,32))+dds(i,32)*xcft1s
      fock1(inddyy(i,33))=fock1(inddyy(i,33))+dds(i,33)*xcft1s
      fock1(inddyy(i,34))=fock1(inddyy(i,34))+dds(i,34)*xcft1s
      fock1(inddyy(i,35))=fock1(inddyy(i,35))+dds(i,35)*xcft1s
      fock1(inddyy(i,36))=fock1(inddyy(i,36))+dds(i,36)*xcft1s

      fock2(inddyy(i,01))=fock2(inddyy(i,01))+dds(i,01)*xcft2s
      fock2(inddyy(i,07))=fock2(inddyy(i,07))+dds(i,07)*xcft2s
      fock2(inddyy(i,08))=fock2(inddyy(i,08))+dds(i,08)*xcft2s
      fock2(inddyy(i,13))=fock2(inddyy(i,13))+dds(i,13)*xcft2s
      fock2(inddyy(i,14))=fock2(inddyy(i,14))+dds(i,14)*xcft2s
      fock2(inddyy(i,15))=fock2(inddyy(i,15))+dds(i,15)*xcft2s
      fock2(inddyy(i,19))=fock2(inddyy(i,19))+dds(i,19)*xcft2s
      fock2(inddyy(i,20))=fock2(inddyy(i,20))+dds(i,20)*xcft2s
      fock2(inddyy(i,21))=fock2(inddyy(i,21))+dds(i,21)*xcft2s
      fock2(inddyy(i,22))=fock2(inddyy(i,22))+dds(i,22)*xcft2s
      fock2(inddyy(i,25))=fock2(inddyy(i,25))+dds(i,25)*xcft2s
      fock2(inddyy(i,26))=fock2(inddyy(i,26))+dds(i,26)*xcft2s
      fock2(inddyy(i,27))=fock2(inddyy(i,27))+dds(i,27)*xcft2s
      fock2(inddyy(i,28))=fock2(inddyy(i,28))+dds(i,28)*xcft2s
      fock2(inddyy(i,29))=fock2(inddyy(i,29))+dds(i,29)*xcft2s
      fock2(inddyy(i,31))=fock2(inddyy(i,31))+dds(i,31)*xcft2s
      fock2(inddyy(i,32))=fock2(inddyy(i,32))+dds(i,32)*xcft2s
      fock2(inddyy(i,33))=fock2(inddyy(i,33))+dds(i,33)*xcft2s
      fock2(inddyy(i,34))=fock2(inddyy(i,34))+dds(i,34)*xcft2s
      fock2(inddyy(i,35))=fock2(inddyy(i,35))+dds(i,35)*xcft2s
      fock2(inddyy(i,36))=fock2(inddyy(i,36))+dds(i,36)*xcft2s

      fock3(inddyy(i,01))=fock3(inddyy(i,01))+dds(i,01)*xcft3s
      fock3(inddyy(i,07))=fock3(inddyy(i,07))+dds(i,07)*xcft3s
      fock3(inddyy(i,08))=fock3(inddyy(i,08))+dds(i,08)*xcft3s
      fock3(inddyy(i,13))=fock3(inddyy(i,13))+dds(i,13)*xcft3s
      fock3(inddyy(i,14))=fock3(inddyy(i,14))+dds(i,14)*xcft3s
      fock3(inddyy(i,15))=fock3(inddyy(i,15))+dds(i,15)*xcft3s
      fock3(inddyy(i,19))=fock3(inddyy(i,19))+dds(i,19)*xcft3s
      fock3(inddyy(i,20))=fock3(inddyy(i,20))+dds(i,20)*xcft3s
      fock3(inddyy(i,21))=fock3(inddyy(i,21))+dds(i,21)*xcft3s
      fock3(inddyy(i,22))=fock3(inddyy(i,22))+dds(i,22)*xcft3s
      fock3(inddyy(i,25))=fock3(inddyy(i,25))+dds(i,25)*xcft3s
      fock3(inddyy(i,26))=fock3(inddyy(i,26))+dds(i,26)*xcft3s
      fock3(inddyy(i,27))=fock3(inddyy(i,27))+dds(i,27)*xcft3s
      fock3(inddyy(i,28))=fock3(inddyy(i,28))+dds(i,28)*xcft3s
      fock3(inddyy(i,29))=fock3(inddyy(i,29))+dds(i,29)*xcft3s
      fock3(inddyy(i,31))=fock3(inddyy(i,31))+dds(i,31)*xcft3s
      fock3(inddyy(i,32))=fock3(inddyy(i,32))+dds(i,32)*xcft3s
      fock3(inddyy(i,33))=fock3(inddyy(i,33))+dds(i,33)*xcft3s
      fock3(inddyy(i,34))=fock3(inddyy(i,34))+dds(i,34)*xcft3s
      fock3(inddyy(i,35))=fock3(inddyy(i,35))+dds(i,35)*xcft3s
      fock3(inddyy(i,36))=fock3(inddyy(i,36))+dds(i,36)*xcft3s

 1023 continue

      do 1024 i=1,m
      if(iminj(i).ne.0) then

               fock1(inddyy(i,02))=fock1(inddyy(i,02))+dds(i,02)*xcft1s
               fock1(inddyy(i,03))=fock1(inddyy(i,03))+dds(i,03)*xcft1s
               fock1(inddyy(i,04))=fock1(inddyy(i,04))+dds(i,04)*xcft1s
               fock1(inddyy(i,05))=fock1(inddyy(i,05))+dds(i,05)*xcft1s
               fock1(inddyy(i,06))=fock1(inddyy(i,06))+dds(i,06)*xcft1s
               fock1(inddyy(i,09))=fock1(inddyy(i,09))+dds(i,09)*xcft1s
               fock1(inddyy(i,10))=fock1(inddyy(i,10))+dds(i,10)*xcft1s
               fock1(inddyy(i,11))=fock1(inddyy(i,11))+dds(i,11)*xcft1s
               fock1(inddyy(i,12))=fock1(inddyy(i,12))+dds(i,12)*xcft1s
               fock1(inddyy(i,16))=fock1(inddyy(i,16))+dds(i,16)*xcft1s
               fock1(inddyy(i,17))=fock1(inddyy(i,17))+dds(i,17)*xcft1s
               fock1(inddyy(i,18))=fock1(inddyy(i,18))+dds(i,18)*xcft1s
               fock1(inddyy(i,23))=fock1(inddyy(i,23))+dds(i,23)*xcft1s
               fock1(inddyy(i,24))=fock1(inddyy(i,24))+dds(i,24)*xcft1s
               fock1(inddyy(i,30))=fock1(inddyy(i,30))+dds(i,30)*xcft1s

               fock2(inddyy(i,02))=fock2(inddyy(i,02))+dds(i,02)*xcft2s
               fock2(inddyy(i,03))=fock2(inddyy(i,03))+dds(i,03)*xcft2s
               fock2(inddyy(i,04))=fock2(inddyy(i,04))+dds(i,04)*xcft2s
               fock2(inddyy(i,05))=fock2(inddyy(i,05))+dds(i,05)*xcft2s
               fock2(inddyy(i,06))=fock2(inddyy(i,06))+dds(i,06)*xcft2s
               fock2(inddyy(i,09))=fock2(inddyy(i,09))+dds(i,09)*xcft2s
               fock2(inddyy(i,10))=fock2(inddyy(i,10))+dds(i,10)*xcft2s
               fock2(inddyy(i,11))=fock2(inddyy(i,11))+dds(i,11)*xcft2s
               fock2(inddyy(i,12))=fock2(inddyy(i,12))+dds(i,12)*xcft2s
               fock2(inddyy(i,16))=fock2(inddyy(i,16))+dds(i,16)*xcft2s
               fock2(inddyy(i,17))=fock2(inddyy(i,17))+dds(i,17)*xcft2s
               fock2(inddyy(i,18))=fock2(inddyy(i,18))+dds(i,18)*xcft2s
               fock2(inddyy(i,23))=fock2(inddyy(i,23))+dds(i,23)*xcft2s
               fock2(inddyy(i,24))=fock2(inddyy(i,24))+dds(i,24)*xcft2s
               fock2(inddyy(i,30))=fock2(inddyy(i,30))+dds(i,30)*xcft2s

               fock3(inddyy(i,02))=fock3(inddyy(i,02))+dds(i,02)*xcft3s
               fock3(inddyy(i,03))=fock3(inddyy(i,03))+dds(i,03)*xcft3s
               fock3(inddyy(i,04))=fock3(inddyy(i,04))+dds(i,04)*xcft3s
               fock3(inddyy(i,05))=fock3(inddyy(i,05))+dds(i,05)*xcft3s
               fock3(inddyy(i,06))=fock3(inddyy(i,06))+dds(i,06)*xcft3s
               fock3(inddyy(i,09))=fock3(inddyy(i,09))+dds(i,09)*xcft3s
               fock3(inddyy(i,10))=fock3(inddyy(i,10))+dds(i,10)*xcft3s
               fock3(inddyy(i,11))=fock3(inddyy(i,11))+dds(i,11)*xcft3s
               fock3(inddyy(i,12))=fock3(inddyy(i,12))+dds(i,12)*xcft3s
               fock3(inddyy(i,16))=fock3(inddyy(i,16))+dds(i,16)*xcft3s
               fock3(inddyy(i,17))=fock3(inddyy(i,17))+dds(i,17)*xcft3s
               fock3(inddyy(i,18))=fock3(inddyy(i,18))+dds(i,18)*xcft3s
               fock3(inddyy(i,23))=fock3(inddyy(i,23))+dds(i,23)*xcft3s
               fock3(inddyy(i,24))=fock3(inddyy(i,24))+dds(i,24)*xcft3s
               fock3(inddyy(i,30))=fock3(inddyy(i,30))+dds(i,30)*xcft3s

                        endif
 1024 continue

 1001 continue

      do 2001 naux=1,nxcspd

      ilaux=ilfunc(nxcs+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      xcft1s=xcfit1(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft2s=xcfit2(nxcs+(naux-1)*10+1)*coeffs(ilaux)
      xcft3s=xcfit3(nxcs+(naux-1)*10+1)*coeffs(ilaux)

      xcft1p(1)=xcfit1(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft1p(2)=xcfit1(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft1p(3)=xcfit1(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft2p(1)=xcfit2(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft2p(2)=xcfit2(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft2p(3)=xcfit2(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft3p(1)=xcfit3(nxcs+(naux-1)*10+2)*coeffp(ilaux)
      xcft3p(2)=xcfit3(nxcs+(naux-1)*10+3)*coeffp(ilaux)
      xcft3p(3)=xcfit3(nxcs+(naux-1)*10+4)*coeffp(ilaux)

      xcft1d(1)=xcfit1(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft1d(2)=xcfit1(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft1d(3)=xcfit1(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft1d(4)=xcfit1(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft1d(5)=xcfit1(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft1d(6)=xcfit1(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft2d(1)=xcfit2(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft2d(2)=xcfit2(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft2d(3)=xcfit2(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft2d(4)=xcfit2(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft2d(5)=xcfit2(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft2d(6)=xcfit2(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      xcft3d(1)=xcfit3(nxcs+(naux-1)*10+05)*coeffd(ilaux)/sqrt3
      xcft3d(2)=xcfit3(nxcs+(naux-1)*10+06)*coeffd(ilaux)
      xcft3d(3)=xcfit3(nxcs+(naux-1)*10+07)*coeffd(ilaux)
      xcft3d(4)=xcfit3(nxcs+(naux-1)*10+08)*coeffd(ilaux)/sqrt3
      xcft3d(5)=xcfit3(nxcs+(naux-1)*10+09)*coeffd(ilaux)
      xcft3d(6)=xcfit3(nxcs+(naux-1)*10+10)*coeffd(ilaux)/sqrt3

      do 2002 i=1,n
      zetafac(i)=(zeta(i)/(zeta(i)+zetaux))**(three/two)
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n

      axcx(icontr(i))=ax(i)-ccx
      aycy(icontr(i))=ay(i)-ccy
      azcz(icontr(i))=az(i)-ccz

      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz

 2003 efac(i)=zetaux*zeta(i)*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 2004 i=1,n
      sss(i)=zero
 2004 if(efac(i).lt.expcut) sss(i)=zetafac(i)*base(i)*exp(-efac(i))

      nn=0

      do 2005 i=1,n
      if(abs(sss(i)).gt.calcut) then
                                      nn=nn+1

                                      iicontr(nn)=icontr(i)

                                      zzeta(nn)=zeta(i)

                                      zetarec(nn)=zetarec(i)

                                      aax(nn)=ax(i)
                                      aay(nn)=ay(i)
                                      aaz(nn)=az(i)

                                      ppx(nn)=px(i)
                                      ppy(nn)=py(i)
                                      ppz(nn)=pz(i)

                                      sss(nn)=sss(i)
                                endif
 2005 continue

      do 2006 i=1,nn
      gxax(i)=(zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i)-aax(i)
      gyay(i)=(zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i)-aay(i)
 2006 gzaz(i)=(zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i)-aaz(i)

      do 2007 i=1,nn
 2007 zetarec(i)=zetarec(i)/two

      do 2008 i=1,nn
      pss(i,1)=gxax(i)*sss(i)
      pss(i,2)=gyay(i)*sss(i)
 2008 pss(i,3)=gzaz(i)*sss(i)

      do 2009 i=1,nn

      c(i)=zetarec(i)*sss(i)

      dss(i,1)=gxax(i)*pss(i,1)+c(i)
      dss(i,2)=gyay(i)*pss(i,1)
      dss(i,3)=gzaz(i)*pss(i,1)
      dss(i,4)=gyay(i)*pss(i,2)+c(i)
      dss(i,5)=gzaz(i)*pss(i,2)
      dss(i,6)=gzaz(i)*pss(i,3)+c(i)

 2009 continue

      do 2010 j=1,3
      do 2010 i=1,nn
 2010 c1(i,j)=zetarec(i)*pss(i,j)

      do 2011 i=1,nn
      fss(i,01)=gxax(i)*dss(i,1)+c1(i,1)+c1(i,1)
      fss(i,02)=gyay(i)*dss(i,1)
      fss(i,03)=gzaz(i)*dss(i,1)
      fss(i,04)=gyay(i)*dss(i,2)+c1(i,1)
      fss(i,05)=gzaz(i)*dss(i,2)
      fss(i,06)=gzaz(i)*dss(i,3)+c1(i,1)
      fss(i,07)=gyay(i)*dss(i,4)+c1(i,2)+c1(i,2)
      fss(i,08)=gzaz(i)*dss(i,4)
      fss(i,09)=gzaz(i)*dss(i,5)+c1(i,2)
 2011 fss(i,10)=gzaz(i)*dss(i,6)+c1(i,3)+c1(i,3)

      do 2012 j=1,6
      do 2012 i=1,nn
 2012 c2(i,j)=zetarec(i)*dss(i,j)

      do 2013 i=1,nn
      gss(i,01)=gxax(i)*fss(i,01)+c2(i,1)*three
      gss(i,02)=gyay(i)*fss(i,01)
      gss(i,03)=gzaz(i)*fss(i,01)
      gss(i,04)=gyay(i)*fss(i,02)+c2(i,1)
      gss(i,05)=gzaz(i)*fss(i,02)
      gss(i,06)=gzaz(i)*fss(i,03)+c2(i,1)
      gss(i,07)=gyay(i)*fss(i,04)+c2(i,2)*two
      gss(i,08)=gzaz(i)*fss(i,04)
      gss(i,09)=gzaz(i)*fss(i,05)+c2(i,2)
      gss(i,10)=gzaz(i)*fss(i,06)+c2(i,3)*two
      gss(i,11)=gyay(i)*fss(i,07)+c2(i,4)*three
      gss(i,12)=gzaz(i)*fss(i,07)
      gss(i,13)=gzaz(i)*fss(i,08)+c2(i,4)
      gss(i,14)=gzaz(i)*fss(i,09)+c2(i,5)*two
 2013 gss(i,15)=gzaz(i)*fss(i,10)+c2(i,6)*three

      do 2014 j=1,10
      do 2014 i=1,nn
 2014 c3(i,j)=zetarec(i)*fss(i,j)

      do 2015 i=1,nn
      hss(i,01)=gxax(i)*gss(i,01)+c3(i,01)*four
      hss(i,02)=gyay(i)*gss(i,01)
      hss(i,03)=gzaz(i)*gss(i,01)
      hss(i,04)=gyay(i)*gss(i,02)+c3(i,01)
      hss(i,05)=gzaz(i)*gss(i,02)
      hss(i,06)=gzaz(i)*gss(i,03)+c3(i,01)
      hss(i,07)=gyay(i)*gss(i,04)+c3(i,02)*two
      hss(i,08)=gzaz(i)*gss(i,04)
      hss(i,09)=gzaz(i)*gss(i,05)+c3(i,02)
      hss(i,10)=gzaz(i)*gss(i,06)+c3(i,03)*two
      hss(i,11)=gyay(i)*gss(i,07)+c3(i,04)*three
      hss(i,12)=gzaz(i)*gss(i,07)
      hss(i,13)=gzaz(i)*gss(i,08)+c3(i,04)
      hss(i,14)=gzaz(i)*gss(i,09)+c3(i,05)*two
      hss(i,15)=gzaz(i)*gss(i,10)+c3(i,06)*three
      hss(i,16)=gyay(i)*gss(i,11)+c3(i,07)*four
      hss(i,17)=gzaz(i)*gss(i,11)
      hss(i,18)=gzaz(i)*gss(i,12)+c3(i,07)
      hss(i,19)=gzaz(i)*gss(i,13)+c3(i,08)*two
      hss(i,20)=gzaz(i)*gss(i,14)+c3(i,09)*three
 2015 hss(i,21)=gzaz(i)*gss(i,15)+c3(i,10)*four

      do 2016 j=1,15
      do 2016 i=1,nn
 2016 c4(i,j)=zetarec(i)*gss(i,j)

      do 2017 i=1,nn
      qss(i,01)=gxax(i)*hss(i,01)+c4(i,01)*five
      qss(i,02)=gyay(i)*hss(i,01)
      qss(i,03)=gzaz(i)*hss(i,01)
      qss(i,04)=gyay(i)*hss(i,02)+c4(i,01)
      qss(i,05)=gzaz(i)*hss(i,02)
      qss(i,06)=gzaz(i)*hss(i,03)+c4(i,01)
      qss(i,07)=gyay(i)*hss(i,04)+c4(i,02)*two
      qss(i,08)=gzaz(i)*hss(i,04)
      qss(i,09)=gzaz(i)*hss(i,05)+c4(i,02)
      qss(i,10)=gzaz(i)*hss(i,06)+c4(i,03)*two
      qss(i,11)=gyay(i)*hss(i,07)+c4(i,04)*three
      qss(i,12)=gzaz(i)*hss(i,07)
      qss(i,13)=gzaz(i)*hss(i,08)+c4(i,04)
      qss(i,14)=gzaz(i)*hss(i,09)+c4(i,05)*two
      qss(i,15)=gzaz(i)*hss(i,10)+c4(i,06)*three
      qss(i,16)=gyay(i)*hss(i,11)+c4(i,07)*four
      qss(i,17)=gzaz(i)*hss(i,11)
      qss(i,18)=gzaz(i)*hss(i,12)+c4(i,07)
      qss(i,19)=gzaz(i)*hss(i,13)+c4(i,08)*two
      qss(i,20)=gzaz(i)*hss(i,14)+c4(i,09)*three
      qss(i,21)=gzaz(i)*hss(i,15)+c4(i,10)*four
      qss(i,22)=gyay(i)*hss(i,16)+c4(i,11)*five
      qss(i,23)=gzaz(i)*hss(i,16)
      qss(i,24)=gzaz(i)*hss(i,17)+c4(i,11)
      qss(i,25)=gzaz(i)*hss(i,18)+c4(i,12)*two
      qss(i,26)=gzaz(i)*hss(i,19)+c4(i,13)*three
      qss(i,27)=gzaz(i)*hss(i,20)+c4(i,14)*four
 2017 qss(i,28)=gzaz(i)*hss(i,21)+c4(i,15)*five

      call xcordd1(m,n,nn,iicontr,axbx,ayby,azbz,axcx,aycy,azcz,dss,
     &             dsscond,fss,fsscond,gss,gsscond,hss,hsscond,qss,
     &             qsscond,dps,dds,ddp,ddd,fps,fds,fdp,gps,gds,hps)

      do 2018 i=1,m

      fock1(inddyy(i,01))=fock1(inddyy(i,01))+dds(i,01)*xcft1s
      fock1(inddyy(i,07))=fock1(inddyy(i,07))+dds(i,07)*xcft1s
      fock1(inddyy(i,08))=fock1(inddyy(i,08))+dds(i,08)*xcft1s
      fock1(inddyy(i,13))=fock1(inddyy(i,13))+dds(i,13)*xcft1s
      fock1(inddyy(i,14))=fock1(inddyy(i,14))+dds(i,14)*xcft1s
      fock1(inddyy(i,15))=fock1(inddyy(i,15))+dds(i,15)*xcft1s
      fock1(inddyy(i,19))=fock1(inddyy(i,19))+dds(i,19)*xcft1s
      fock1(inddyy(i,20))=fock1(inddyy(i,20))+dds(i,20)*xcft1s
      fock1(inddyy(i,21))=fock1(inddyy(i,21))+dds(i,21)*xcft1s
      fock1(inddyy(i,22))=fock1(inddyy(i,22))+dds(i,22)*xcft1s
      fock1(inddyy(i,25))=fock1(inddyy(i,25))+dds(i,25)*xcft1s
      fock1(inddyy(i,26))=fock1(inddyy(i,26))+dds(i,26)*xcft1s
      fock1(inddyy(i,27))=fock1(inddyy(i,27))+dds(i,27)*xcft1s
      fock1(inddyy(i,28))=fock1(inddyy(i,28))+dds(i,28)*xcft1s
      fock1(inddyy(i,29))=fock1(inddyy(i,29))+dds(i,29)*xcft1s
      fock1(inddyy(i,31))=fock1(inddyy(i,31))+dds(i,31)*xcft1s
      fock1(inddyy(i,32))=fock1(inddyy(i,32))+dds(i,32)*xcft1s
      fock1(inddyy(i,33))=fock1(inddyy(i,33))+dds(i,33)*xcft1s
      fock1(inddyy(i,34))=fock1(inddyy(i,34))+dds(i,34)*xcft1s
      fock1(inddyy(i,35))=fock1(inddyy(i,35))+dds(i,35)*xcft1s
      fock1(inddyy(i,36))=fock1(inddyy(i,36))+dds(i,36)*xcft1s

      fock2(inddyy(i,01))=fock2(inddyy(i,01))+dds(i,01)*xcft2s
      fock2(inddyy(i,07))=fock2(inddyy(i,07))+dds(i,07)*xcft2s
      fock2(inddyy(i,08))=fock2(inddyy(i,08))+dds(i,08)*xcft2s
      fock2(inddyy(i,13))=fock2(inddyy(i,13))+dds(i,13)*xcft2s
      fock2(inddyy(i,14))=fock2(inddyy(i,14))+dds(i,14)*xcft2s
      fock2(inddyy(i,15))=fock2(inddyy(i,15))+dds(i,15)*xcft2s
      fock2(inddyy(i,19))=fock2(inddyy(i,19))+dds(i,19)*xcft2s
      fock2(inddyy(i,20))=fock2(inddyy(i,20))+dds(i,20)*xcft2s
      fock2(inddyy(i,21))=fock2(inddyy(i,21))+dds(i,21)*xcft2s
      fock2(inddyy(i,22))=fock2(inddyy(i,22))+dds(i,22)*xcft2s
      fock2(inddyy(i,25))=fock2(inddyy(i,25))+dds(i,25)*xcft2s
      fock2(inddyy(i,26))=fock2(inddyy(i,26))+dds(i,26)*xcft2s
      fock2(inddyy(i,27))=fock2(inddyy(i,27))+dds(i,27)*xcft2s
      fock2(inddyy(i,28))=fock2(inddyy(i,28))+dds(i,28)*xcft2s
      fock2(inddyy(i,29))=fock2(inddyy(i,29))+dds(i,29)*xcft2s
      fock2(inddyy(i,31))=fock2(inddyy(i,31))+dds(i,31)*xcft2s
      fock2(inddyy(i,32))=fock2(inddyy(i,32))+dds(i,32)*xcft2s
      fock2(inddyy(i,33))=fock2(inddyy(i,33))+dds(i,33)*xcft2s
      fock2(inddyy(i,34))=fock2(inddyy(i,34))+dds(i,34)*xcft2s
      fock2(inddyy(i,35))=fock2(inddyy(i,35))+dds(i,35)*xcft2s
      fock2(inddyy(i,36))=fock2(inddyy(i,36))+dds(i,36)*xcft2s

      fock3(inddyy(i,01))=fock3(inddyy(i,01))+dds(i,01)*xcft3s
      fock3(inddyy(i,07))=fock3(inddyy(i,07))+dds(i,07)*xcft3s
      fock3(inddyy(i,08))=fock3(inddyy(i,08))+dds(i,08)*xcft3s
      fock3(inddyy(i,13))=fock3(inddyy(i,13))+dds(i,13)*xcft3s
      fock3(inddyy(i,14))=fock3(inddyy(i,14))+dds(i,14)*xcft3s
      fock3(inddyy(i,15))=fock3(inddyy(i,15))+dds(i,15)*xcft3s
      fock3(inddyy(i,19))=fock3(inddyy(i,19))+dds(i,19)*xcft3s
      fock3(inddyy(i,20))=fock3(inddyy(i,20))+dds(i,20)*xcft3s
      fock3(inddyy(i,21))=fock3(inddyy(i,21))+dds(i,21)*xcft3s
      fock3(inddyy(i,22))=fock3(inddyy(i,22))+dds(i,22)*xcft3s
      fock3(inddyy(i,25))=fock3(inddyy(i,25))+dds(i,25)*xcft3s
      fock3(inddyy(i,26))=fock3(inddyy(i,26))+dds(i,26)*xcft3s
      fock3(inddyy(i,27))=fock3(inddyy(i,27))+dds(i,27)*xcft3s
      fock3(inddyy(i,28))=fock3(inddyy(i,28))+dds(i,28)*xcft3s
      fock3(inddyy(i,29))=fock3(inddyy(i,29))+dds(i,29)*xcft3s
      fock3(inddyy(i,31))=fock3(inddyy(i,31))+dds(i,31)*xcft3s
      fock3(inddyy(i,32))=fock3(inddyy(i,32))+dds(i,32)*xcft3s
      fock3(inddyy(i,33))=fock3(inddyy(i,33))+dds(i,33)*xcft3s
      fock3(inddyy(i,34))=fock3(inddyy(i,34))+dds(i,34)*xcft3s
      fock3(inddyy(i,35))=fock3(inddyy(i,35))+dds(i,35)*xcft3s
      fock3(inddyy(i,36))=fock3(inddyy(i,36))+dds(i,36)*xcft3s

 2018 continue

      do 2019 i=1,m
      if(iminj(i).ne.0) then

               fock1(inddyy(i,02))=fock1(inddyy(i,02))+dds(i,02)*xcft1s
               fock1(inddyy(i,03))=fock1(inddyy(i,03))+dds(i,03)*xcft1s
               fock1(inddyy(i,04))=fock1(inddyy(i,04))+dds(i,04)*xcft1s
               fock1(inddyy(i,05))=fock1(inddyy(i,05))+dds(i,05)*xcft1s
               fock1(inddyy(i,06))=fock1(inddyy(i,06))+dds(i,06)*xcft1s
               fock1(inddyy(i,09))=fock1(inddyy(i,09))+dds(i,09)*xcft1s
               fock1(inddyy(i,10))=fock1(inddyy(i,10))+dds(i,10)*xcft1s
               fock1(inddyy(i,11))=fock1(inddyy(i,11))+dds(i,11)*xcft1s
               fock1(inddyy(i,12))=fock1(inddyy(i,12))+dds(i,12)*xcft1s
               fock1(inddyy(i,16))=fock1(inddyy(i,16))+dds(i,16)*xcft1s
               fock1(inddyy(i,17))=fock1(inddyy(i,17))+dds(i,17)*xcft1s
               fock1(inddyy(i,18))=fock1(inddyy(i,18))+dds(i,18)*xcft1s
               fock1(inddyy(i,23))=fock1(inddyy(i,23))+dds(i,23)*xcft1s
               fock1(inddyy(i,24))=fock1(inddyy(i,24))+dds(i,24)*xcft1s
               fock1(inddyy(i,30))=fock1(inddyy(i,30))+dds(i,30)*xcft1s

               fock2(inddyy(i,02))=fock2(inddyy(i,02))+dds(i,02)*xcft2s
               fock2(inddyy(i,03))=fock2(inddyy(i,03))+dds(i,03)*xcft2s
               fock2(inddyy(i,04))=fock2(inddyy(i,04))+dds(i,04)*xcft2s
               fock2(inddyy(i,05))=fock2(inddyy(i,05))+dds(i,05)*xcft2s
               fock2(inddyy(i,06))=fock2(inddyy(i,06))+dds(i,06)*xcft2s
               fock2(inddyy(i,09))=fock2(inddyy(i,09))+dds(i,09)*xcft2s
               fock2(inddyy(i,10))=fock2(inddyy(i,10))+dds(i,10)*xcft2s
               fock2(inddyy(i,11))=fock2(inddyy(i,11))+dds(i,11)*xcft2s
               fock2(inddyy(i,12))=fock2(inddyy(i,12))+dds(i,12)*xcft2s
               fock2(inddyy(i,16))=fock2(inddyy(i,16))+dds(i,16)*xcft2s
               fock2(inddyy(i,17))=fock2(inddyy(i,17))+dds(i,17)*xcft2s
               fock2(inddyy(i,18))=fock2(inddyy(i,18))+dds(i,18)*xcft2s
               fock2(inddyy(i,23))=fock2(inddyy(i,23))+dds(i,23)*xcft2s
               fock2(inddyy(i,24))=fock2(inddyy(i,24))+dds(i,24)*xcft2s
               fock2(inddyy(i,30))=fock2(inddyy(i,30))+dds(i,30)*xcft2s

               fock3(inddyy(i,02))=fock3(inddyy(i,02))+dds(i,02)*xcft3s
               fock3(inddyy(i,03))=fock3(inddyy(i,03))+dds(i,03)*xcft3s
               fock3(inddyy(i,04))=fock3(inddyy(i,04))+dds(i,04)*xcft3s
               fock3(inddyy(i,05))=fock3(inddyy(i,05))+dds(i,05)*xcft3s
               fock3(inddyy(i,06))=fock3(inddyy(i,06))+dds(i,06)*xcft3s
               fock3(inddyy(i,09))=fock3(inddyy(i,09))+dds(i,09)*xcft3s
               fock3(inddyy(i,10))=fock3(inddyy(i,10))+dds(i,10)*xcft3s
               fock3(inddyy(i,11))=fock3(inddyy(i,11))+dds(i,11)*xcft3s
               fock3(inddyy(i,12))=fock3(inddyy(i,12))+dds(i,12)*xcft3s
               fock3(inddyy(i,16))=fock3(inddyy(i,16))+dds(i,16)*xcft3s
               fock3(inddyy(i,17))=fock3(inddyy(i,17))+dds(i,17)*xcft3s
               fock3(inddyy(i,18))=fock3(inddyy(i,18))+dds(i,18)*xcft3s
               fock3(inddyy(i,23))=fock3(inddyy(i,23))+dds(i,23)*xcft3s
               fock3(inddyy(i,24))=fock3(inddyy(i,24))+dds(i,24)*xcft3s
               fock3(inddyy(i,30))=fock3(inddyy(i,30))+dds(i,30)*xcft3s

                        endif
 2019 continue

      do 2020 j=1,3
      do 2020 i=1,m

      fock1(inddyy(i,01))=fock1(inddyy(i,01))+ddp(i,3*00+j)*xcft1p(j)
      fock1(inddyy(i,07))=fock1(inddyy(i,07))+ddp(i,3*06+j)*xcft1p(j)
      fock1(inddyy(i,08))=fock1(inddyy(i,08))+ddp(i,3*07+j)*xcft1p(j)
      fock1(inddyy(i,13))=fock1(inddyy(i,13))+ddp(i,3*12+j)*xcft1p(j)
      fock1(inddyy(i,14))=fock1(inddyy(i,14))+ddp(i,3*13+j)*xcft1p(j)
      fock1(inddyy(i,15))=fock1(inddyy(i,15))+ddp(i,3*14+j)*xcft1p(j)
      fock1(inddyy(i,19))=fock1(inddyy(i,19))+ddp(i,3*18+j)*xcft1p(j)
      fock1(inddyy(i,20))=fock1(inddyy(i,20))+ddp(i,3*19+j)*xcft1p(j)
      fock1(inddyy(i,21))=fock1(inddyy(i,21))+ddp(i,3*20+j)*xcft1p(j)
      fock1(inddyy(i,22))=fock1(inddyy(i,22))+ddp(i,3*21+j)*xcft1p(j)
      fock1(inddyy(i,25))=fock1(inddyy(i,25))+ddp(i,3*24+j)*xcft1p(j)
      fock1(inddyy(i,26))=fock1(inddyy(i,26))+ddp(i,3*25+j)*xcft1p(j)
      fock1(inddyy(i,27))=fock1(inddyy(i,27))+ddp(i,3*26+j)*xcft1p(j)
      fock1(inddyy(i,28))=fock1(inddyy(i,28))+ddp(i,3*27+j)*xcft1p(j)
      fock1(inddyy(i,29))=fock1(inddyy(i,29))+ddp(i,3*28+j)*xcft1p(j)
      fock1(inddyy(i,31))=fock1(inddyy(i,31))+ddp(i,3*30+j)*xcft1p(j)
      fock1(inddyy(i,32))=fock1(inddyy(i,32))+ddp(i,3*31+j)*xcft1p(j)
      fock1(inddyy(i,33))=fock1(inddyy(i,33))+ddp(i,3*32+j)*xcft1p(j)
      fock1(inddyy(i,34))=fock1(inddyy(i,34))+ddp(i,3*33+j)*xcft1p(j)
      fock1(inddyy(i,35))=fock1(inddyy(i,35))+ddp(i,3*34+j)*xcft1p(j)
      fock1(inddyy(i,36))=fock1(inddyy(i,36))+ddp(i,3*35+j)*xcft1p(j)

      fock2(inddyy(i,01))=fock2(inddyy(i,01))+ddp(i,3*00+j)*xcft2p(j)
      fock2(inddyy(i,07))=fock2(inddyy(i,07))+ddp(i,3*06+j)*xcft2p(j)
      fock2(inddyy(i,08))=fock2(inddyy(i,08))+ddp(i,3*07+j)*xcft2p(j)
      fock2(inddyy(i,13))=fock2(inddyy(i,13))+ddp(i,3*12+j)*xcft2p(j)
      fock2(inddyy(i,14))=fock2(inddyy(i,14))+ddp(i,3*13+j)*xcft2p(j)
      fock2(inddyy(i,15))=fock2(inddyy(i,15))+ddp(i,3*14+j)*xcft2p(j)
      fock2(inddyy(i,19))=fock2(inddyy(i,19))+ddp(i,3*18+j)*xcft2p(j)
      fock2(inddyy(i,20))=fock2(inddyy(i,20))+ddp(i,3*19+j)*xcft2p(j)
      fock2(inddyy(i,21))=fock2(inddyy(i,21))+ddp(i,3*20+j)*xcft2p(j)
      fock2(inddyy(i,22))=fock2(inddyy(i,22))+ddp(i,3*21+j)*xcft2p(j)
      fock2(inddyy(i,25))=fock2(inddyy(i,25))+ddp(i,3*24+j)*xcft2p(j)
      fock2(inddyy(i,26))=fock2(inddyy(i,26))+ddp(i,3*25+j)*xcft2p(j)
      fock2(inddyy(i,27))=fock2(inddyy(i,27))+ddp(i,3*26+j)*xcft2p(j)
      fock2(inddyy(i,28))=fock2(inddyy(i,28))+ddp(i,3*27+j)*xcft2p(j)
      fock2(inddyy(i,29))=fock2(inddyy(i,29))+ddp(i,3*28+j)*xcft2p(j)
      fock2(inddyy(i,31))=fock2(inddyy(i,31))+ddp(i,3*30+j)*xcft2p(j)
      fock2(inddyy(i,32))=fock2(inddyy(i,32))+ddp(i,3*31+j)*xcft2p(j)
      fock2(inddyy(i,33))=fock2(inddyy(i,33))+ddp(i,3*32+j)*xcft2p(j)
      fock2(inddyy(i,34))=fock2(inddyy(i,34))+ddp(i,3*33+j)*xcft2p(j)
      fock2(inddyy(i,35))=fock2(inddyy(i,35))+ddp(i,3*34+j)*xcft2p(j)
      fock2(inddyy(i,36))=fock2(inddyy(i,36))+ddp(i,3*35+j)*xcft2p(j)

      fock3(inddyy(i,01))=fock3(inddyy(i,01))+ddp(i,3*00+j)*xcft3p(j)
      fock3(inddyy(i,07))=fock3(inddyy(i,07))+ddp(i,3*06+j)*xcft3p(j)
      fock3(inddyy(i,08))=fock3(inddyy(i,08))+ddp(i,3*07+j)*xcft3p(j)
      fock3(inddyy(i,13))=fock3(inddyy(i,13))+ddp(i,3*12+j)*xcft3p(j)
      fock3(inddyy(i,14))=fock3(inddyy(i,14))+ddp(i,3*13+j)*xcft3p(j)
      fock3(inddyy(i,15))=fock3(inddyy(i,15))+ddp(i,3*14+j)*xcft3p(j)
      fock3(inddyy(i,19))=fock3(inddyy(i,19))+ddp(i,3*18+j)*xcft3p(j)
      fock3(inddyy(i,20))=fock3(inddyy(i,20))+ddp(i,3*19+j)*xcft3p(j)
      fock3(inddyy(i,21))=fock3(inddyy(i,21))+ddp(i,3*20+j)*xcft3p(j)
      fock3(inddyy(i,22))=fock3(inddyy(i,22))+ddp(i,3*21+j)*xcft3p(j)
      fock3(inddyy(i,25))=fock3(inddyy(i,25))+ddp(i,3*24+j)*xcft3p(j)
      fock3(inddyy(i,26))=fock3(inddyy(i,26))+ddp(i,3*25+j)*xcft3p(j)
      fock3(inddyy(i,27))=fock3(inddyy(i,27))+ddp(i,3*26+j)*xcft3p(j)
      fock3(inddyy(i,28))=fock3(inddyy(i,28))+ddp(i,3*27+j)*xcft3p(j)
      fock3(inddyy(i,29))=fock3(inddyy(i,29))+ddp(i,3*28+j)*xcft3p(j)
      fock3(inddyy(i,31))=fock3(inddyy(i,31))+ddp(i,3*30+j)*xcft3p(j)
      fock3(inddyy(i,32))=fock3(inddyy(i,32))+ddp(i,3*31+j)*xcft3p(j)
      fock3(inddyy(i,33))=fock3(inddyy(i,33))+ddp(i,3*32+j)*xcft3p(j)
      fock3(inddyy(i,34))=fock3(inddyy(i,34))+ddp(i,3*33+j)*xcft3p(j)
      fock3(inddyy(i,35))=fock3(inddyy(i,35))+ddp(i,3*34+j)*xcft3p(j)
      fock3(inddyy(i,36))=fock3(inddyy(i,36))+ddp(i,3*35+j)*xcft3p(j)

 2020 continue

      do 2021 j=1,3
      do 2021 i=1,m
      if(iminj(i).ne.0) then

         fock1(inddyy(i,02))=fock1(inddyy(i,02))+ddp(i,3*01+j)*xcft1p(j)
         fock1(inddyy(i,03))=fock1(inddyy(i,03))+ddp(i,3*02+j)*xcft1p(j)
         fock1(inddyy(i,04))=fock1(inddyy(i,04))+ddp(i,3*03+j)*xcft1p(j)
         fock1(inddyy(i,05))=fock1(inddyy(i,05))+ddp(i,3*04+j)*xcft1p(j)
         fock1(inddyy(i,06))=fock1(inddyy(i,06))+ddp(i,3*05+j)*xcft1p(j)
         fock1(inddyy(i,09))=fock1(inddyy(i,09))+ddp(i,3*08+j)*xcft1p(j)
         fock1(inddyy(i,10))=fock1(inddyy(i,10))+ddp(i,3*09+j)*xcft1p(j)
         fock1(inddyy(i,11))=fock1(inddyy(i,11))+ddp(i,3*10+j)*xcft1p(j)
         fock1(inddyy(i,12))=fock1(inddyy(i,12))+ddp(i,3*11+j)*xcft1p(j)
         fock1(inddyy(i,16))=fock1(inddyy(i,16))+ddp(i,3*15+j)*xcft1p(j)
         fock1(inddyy(i,17))=fock1(inddyy(i,17))+ddp(i,3*16+j)*xcft1p(j)
         fock1(inddyy(i,18))=fock1(inddyy(i,18))+ddp(i,3*17+j)*xcft1p(j)
         fock1(inddyy(i,23))=fock1(inddyy(i,23))+ddp(i,3*22+j)*xcft1p(j)
         fock1(inddyy(i,24))=fock1(inddyy(i,24))+ddp(i,3*23+j)*xcft1p(j)
         fock1(inddyy(i,30))=fock1(inddyy(i,30))+ddp(i,3*29+j)*xcft1p(j)

         fock2(inddyy(i,02))=fock2(inddyy(i,02))+ddp(i,3*01+j)*xcft2p(j)
         fock2(inddyy(i,03))=fock2(inddyy(i,03))+ddp(i,3*02+j)*xcft2p(j)
         fock2(inddyy(i,04))=fock2(inddyy(i,04))+ddp(i,3*03+j)*xcft2p(j)
         fock2(inddyy(i,05))=fock2(inddyy(i,05))+ddp(i,3*04+j)*xcft2p(j)
         fock2(inddyy(i,06))=fock2(inddyy(i,06))+ddp(i,3*05+j)*xcft2p(j)
         fock2(inddyy(i,09))=fock2(inddyy(i,09))+ddp(i,3*08+j)*xcft2p(j)
         fock2(inddyy(i,10))=fock2(inddyy(i,10))+ddp(i,3*09+j)*xcft2p(j)
         fock2(inddyy(i,11))=fock2(inddyy(i,11))+ddp(i,3*10+j)*xcft2p(j)
         fock2(inddyy(i,12))=fock2(inddyy(i,12))+ddp(i,3*11+j)*xcft2p(j)
         fock2(inddyy(i,16))=fock2(inddyy(i,16))+ddp(i,3*15+j)*xcft2p(j)
         fock2(inddyy(i,17))=fock2(inddyy(i,17))+ddp(i,3*16+j)*xcft2p(j)
         fock2(inddyy(i,18))=fock2(inddyy(i,18))+ddp(i,3*17+j)*xcft2p(j)
         fock2(inddyy(i,23))=fock2(inddyy(i,23))+ddp(i,3*22+j)*xcft2p(j)
         fock2(inddyy(i,24))=fock2(inddyy(i,24))+ddp(i,3*23+j)*xcft2p(j)
         fock2(inddyy(i,30))=fock2(inddyy(i,30))+ddp(i,3*29+j)*xcft2p(j)

         fock3(inddyy(i,02))=fock3(inddyy(i,02))+ddp(i,3*01+j)*xcft3p(j)
         fock3(inddyy(i,03))=fock3(inddyy(i,03))+ddp(i,3*02+j)*xcft3p(j)
         fock3(inddyy(i,04))=fock3(inddyy(i,04))+ddp(i,3*03+j)*xcft3p(j)
         fock3(inddyy(i,05))=fock3(inddyy(i,05))+ddp(i,3*04+j)*xcft3p(j)
         fock3(inddyy(i,06))=fock3(inddyy(i,06))+ddp(i,3*05+j)*xcft3p(j)
         fock3(inddyy(i,09))=fock3(inddyy(i,09))+ddp(i,3*08+j)*xcft3p(j)
         fock3(inddyy(i,10))=fock3(inddyy(i,10))+ddp(i,3*09+j)*xcft3p(j)
         fock3(inddyy(i,11))=fock3(inddyy(i,11))+ddp(i,3*10+j)*xcft3p(j)
         fock3(inddyy(i,12))=fock3(inddyy(i,12))+ddp(i,3*11+j)*xcft3p(j)
         fock3(inddyy(i,16))=fock3(inddyy(i,16))+ddp(i,3*15+j)*xcft3p(j)
         fock3(inddyy(i,17))=fock3(inddyy(i,17))+ddp(i,3*16+j)*xcft3p(j)
         fock3(inddyy(i,18))=fock3(inddyy(i,18))+ddp(i,3*17+j)*xcft3p(j)
         fock3(inddyy(i,23))=fock3(inddyy(i,23))+ddp(i,3*22+j)*xcft3p(j)
         fock3(inddyy(i,24))=fock3(inddyy(i,24))+ddp(i,3*23+j)*xcft3p(j)
         fock3(inddyy(i,30))=fock3(inddyy(i,30))+ddp(i,3*29+j)*xcft3p(j)

                        endif
 2021 continue

      do 2022 j=1,6
      do 2022 i=1,m

      fock1(inddyy(i,01))=fock1(inddyy(i,01))+ddd(i,6*00+j)*xcft1d(j)
      fock1(inddyy(i,07))=fock1(inddyy(i,07))+ddd(i,6*06+j)*xcft1d(j)
      fock1(inddyy(i,08))=fock1(inddyy(i,08))+ddd(i,6*07+j)*xcft1d(j)
      fock1(inddyy(i,13))=fock1(inddyy(i,13))+ddd(i,6*12+j)*xcft1d(j)
      fock1(inddyy(i,14))=fock1(inddyy(i,14))+ddd(i,6*13+j)*xcft1d(j)
      fock1(inddyy(i,15))=fock1(inddyy(i,15))+ddd(i,6*14+j)*xcft1d(j)
      fock1(inddyy(i,19))=fock1(inddyy(i,19))+ddd(i,6*18+j)*xcft1d(j)
      fock1(inddyy(i,20))=fock1(inddyy(i,20))+ddd(i,6*19+j)*xcft1d(j)
      fock1(inddyy(i,21))=fock1(inddyy(i,21))+ddd(i,6*20+j)*xcft1d(j)
      fock1(inddyy(i,22))=fock1(inddyy(i,22))+ddd(i,6*21+j)*xcft1d(j)
      fock1(inddyy(i,25))=fock1(inddyy(i,25))+ddd(i,6*24+j)*xcft1d(j)
      fock1(inddyy(i,26))=fock1(inddyy(i,26))+ddd(i,6*25+j)*xcft1d(j)
      fock1(inddyy(i,27))=fock1(inddyy(i,27))+ddd(i,6*26+j)*xcft1d(j)
      fock1(inddyy(i,28))=fock1(inddyy(i,28))+ddd(i,6*27+j)*xcft1d(j)
      fock1(inddyy(i,29))=fock1(inddyy(i,29))+ddd(i,6*28+j)*xcft1d(j)
      fock1(inddyy(i,31))=fock1(inddyy(i,31))+ddd(i,6*30+j)*xcft1d(j)
      fock1(inddyy(i,32))=fock1(inddyy(i,32))+ddd(i,6*31+j)*xcft1d(j)
      fock1(inddyy(i,33))=fock1(inddyy(i,33))+ddd(i,6*32+j)*xcft1d(j)
      fock1(inddyy(i,34))=fock1(inddyy(i,34))+ddd(i,6*33+j)*xcft1d(j)
      fock1(inddyy(i,35))=fock1(inddyy(i,35))+ddd(i,6*34+j)*xcft1d(j)
      fock1(inddyy(i,36))=fock1(inddyy(i,36))+ddd(i,6*35+j)*xcft1d(j)

      fock2(inddyy(i,01))=fock2(inddyy(i,01))+ddd(i,6*00+j)*xcft2d(j)
      fock2(inddyy(i,07))=fock2(inddyy(i,07))+ddd(i,6*06+j)*xcft2d(j)
      fock2(inddyy(i,08))=fock2(inddyy(i,08))+ddd(i,6*07+j)*xcft2d(j)
      fock2(inddyy(i,13))=fock2(inddyy(i,13))+ddd(i,6*12+j)*xcft2d(j)
      fock2(inddyy(i,14))=fock2(inddyy(i,14))+ddd(i,6*13+j)*xcft2d(j)
      fock2(inddyy(i,15))=fock2(inddyy(i,15))+ddd(i,6*14+j)*xcft2d(j)
      fock2(inddyy(i,19))=fock2(inddyy(i,19))+ddd(i,6*18+j)*xcft2d(j)
      fock2(inddyy(i,20))=fock2(inddyy(i,20))+ddd(i,6*19+j)*xcft2d(j)
      fock2(inddyy(i,21))=fock2(inddyy(i,21))+ddd(i,6*20+j)*xcft2d(j)
      fock2(inddyy(i,22))=fock2(inddyy(i,22))+ddd(i,6*21+j)*xcft2d(j)
      fock2(inddyy(i,25))=fock2(inddyy(i,25))+ddd(i,6*24+j)*xcft2d(j)
      fock2(inddyy(i,26))=fock2(inddyy(i,26))+ddd(i,6*25+j)*xcft2d(j)
      fock2(inddyy(i,27))=fock2(inddyy(i,27))+ddd(i,6*26+j)*xcft2d(j)
      fock2(inddyy(i,28))=fock2(inddyy(i,28))+ddd(i,6*27+j)*xcft2d(j)
      fock2(inddyy(i,29))=fock2(inddyy(i,29))+ddd(i,6*28+j)*xcft2d(j)
      fock2(inddyy(i,31))=fock2(inddyy(i,31))+ddd(i,6*30+j)*xcft2d(j)
      fock2(inddyy(i,32))=fock2(inddyy(i,32))+ddd(i,6*31+j)*xcft2d(j)
      fock2(inddyy(i,33))=fock2(inddyy(i,33))+ddd(i,6*32+j)*xcft2d(j)
      fock2(inddyy(i,34))=fock2(inddyy(i,34))+ddd(i,6*33+j)*xcft2d(j)
      fock2(inddyy(i,35))=fock2(inddyy(i,35))+ddd(i,6*34+j)*xcft2d(j)
      fock2(inddyy(i,36))=fock2(inddyy(i,36))+ddd(i,6*35+j)*xcft2d(j)

      fock3(inddyy(i,01))=fock3(inddyy(i,01))+ddd(i,6*00+j)*xcft3d(j)
      fock3(inddyy(i,07))=fock3(inddyy(i,07))+ddd(i,6*06+j)*xcft3d(j)
      fock3(inddyy(i,08))=fock3(inddyy(i,08))+ddd(i,6*07+j)*xcft3d(j)
      fock3(inddyy(i,13))=fock3(inddyy(i,13))+ddd(i,6*12+j)*xcft3d(j)
      fock3(inddyy(i,14))=fock3(inddyy(i,14))+ddd(i,6*13+j)*xcft3d(j)
      fock3(inddyy(i,15))=fock3(inddyy(i,15))+ddd(i,6*14+j)*xcft3d(j)
      fock3(inddyy(i,19))=fock3(inddyy(i,19))+ddd(i,6*18+j)*xcft3d(j)
      fock3(inddyy(i,20))=fock3(inddyy(i,20))+ddd(i,6*19+j)*xcft3d(j)
      fock3(inddyy(i,21))=fock3(inddyy(i,21))+ddd(i,6*20+j)*xcft3d(j)
      fock3(inddyy(i,22))=fock3(inddyy(i,22))+ddd(i,6*21+j)*xcft3d(j)
      fock3(inddyy(i,25))=fock3(inddyy(i,25))+ddd(i,6*24+j)*xcft3d(j)
      fock3(inddyy(i,26))=fock3(inddyy(i,26))+ddd(i,6*25+j)*xcft3d(j)
      fock3(inddyy(i,27))=fock3(inddyy(i,27))+ddd(i,6*26+j)*xcft3d(j)
      fock3(inddyy(i,28))=fock3(inddyy(i,28))+ddd(i,6*27+j)*xcft3d(j)
      fock3(inddyy(i,29))=fock3(inddyy(i,29))+ddd(i,6*28+j)*xcft3d(j)
      fock3(inddyy(i,31))=fock3(inddyy(i,31))+ddd(i,6*30+j)*xcft3d(j)
      fock3(inddyy(i,32))=fock3(inddyy(i,32))+ddd(i,6*31+j)*xcft3d(j)
      fock3(inddyy(i,33))=fock3(inddyy(i,33))+ddd(i,6*32+j)*xcft3d(j)
      fock3(inddyy(i,34))=fock3(inddyy(i,34))+ddd(i,6*33+j)*xcft3d(j)
      fock3(inddyy(i,35))=fock3(inddyy(i,35))+ddd(i,6*34+j)*xcft3d(j)
      fock3(inddyy(i,36))=fock3(inddyy(i,36))+ddd(i,6*35+j)*xcft3d(j)

 2022 continue

      do 2023 j=1,6
      do 2023 i=1,m
      if(iminj(i).ne.0) then

         fock1(inddyy(i,02))=fock1(inddyy(i,02))+ddd(i,6*01+j)*xcft1d(j)
         fock1(inddyy(i,03))=fock1(inddyy(i,03))+ddd(i,6*02+j)*xcft1d(j)
         fock1(inddyy(i,04))=fock1(inddyy(i,04))+ddd(i,6*03+j)*xcft1d(j)
         fock1(inddyy(i,05))=fock1(inddyy(i,05))+ddd(i,6*04+j)*xcft1d(j)
         fock1(inddyy(i,06))=fock1(inddyy(i,06))+ddd(i,6*05+j)*xcft1d(j)
         fock1(inddyy(i,09))=fock1(inddyy(i,09))+ddd(i,6*08+j)*xcft1d(j)
         fock1(inddyy(i,10))=fock1(inddyy(i,10))+ddd(i,6*09+j)*xcft1d(j)
         fock1(inddyy(i,11))=fock1(inddyy(i,11))+ddd(i,6*10+j)*xcft1d(j)
         fock1(inddyy(i,12))=fock1(inddyy(i,12))+ddd(i,6*11+j)*xcft1d(j)
         fock1(inddyy(i,16))=fock1(inddyy(i,16))+ddd(i,6*15+j)*xcft1d(j)
         fock1(inddyy(i,17))=fock1(inddyy(i,17))+ddd(i,6*16+j)*xcft1d(j)
         fock1(inddyy(i,18))=fock1(inddyy(i,18))+ddd(i,6*17+j)*xcft1d(j)
         fock1(inddyy(i,23))=fock1(inddyy(i,23))+ddd(i,6*22+j)*xcft1d(j)
         fock1(inddyy(i,24))=fock1(inddyy(i,24))+ddd(i,6*23+j)*xcft1d(j)
         fock1(inddyy(i,30))=fock1(inddyy(i,30))+ddd(i,6*29+j)*xcft1d(j)

         fock2(inddyy(i,02))=fock2(inddyy(i,02))+ddd(i,6*01+j)*xcft2d(j)
         fock2(inddyy(i,03))=fock2(inddyy(i,03))+ddd(i,6*02+j)*xcft2d(j)
         fock2(inddyy(i,04))=fock2(inddyy(i,04))+ddd(i,6*03+j)*xcft2d(j)
         fock2(inddyy(i,05))=fock2(inddyy(i,05))+ddd(i,6*04+j)*xcft2d(j)
         fock2(inddyy(i,06))=fock2(inddyy(i,06))+ddd(i,6*05+j)*xcft2d(j)
         fock2(inddyy(i,09))=fock2(inddyy(i,09))+ddd(i,6*08+j)*xcft2d(j)
         fock2(inddyy(i,10))=fock2(inddyy(i,10))+ddd(i,6*09+j)*xcft2d(j)
         fock2(inddyy(i,11))=fock2(inddyy(i,11))+ddd(i,6*10+j)*xcft2d(j)
         fock2(inddyy(i,12))=fock2(inddyy(i,12))+ddd(i,6*11+j)*xcft2d(j)
         fock2(inddyy(i,16))=fock2(inddyy(i,16))+ddd(i,6*15+j)*xcft2d(j)
         fock2(inddyy(i,17))=fock2(inddyy(i,17))+ddd(i,6*16+j)*xcft2d(j)
         fock2(inddyy(i,18))=fock2(inddyy(i,18))+ddd(i,6*17+j)*xcft2d(j)
         fock2(inddyy(i,23))=fock2(inddyy(i,23))+ddd(i,6*22+j)*xcft2d(j)
         fock2(inddyy(i,24))=fock2(inddyy(i,24))+ddd(i,6*23+j)*xcft2d(j)
         fock2(inddyy(i,30))=fock2(inddyy(i,30))+ddd(i,6*29+j)*xcft2d(j)

         fock3(inddyy(i,02))=fock3(inddyy(i,02))+ddd(i,6*01+j)*xcft3d(j)
         fock3(inddyy(i,03))=fock3(inddyy(i,03))+ddd(i,6*02+j)*xcft3d(j)
         fock3(inddyy(i,04))=fock3(inddyy(i,04))+ddd(i,6*03+j)*xcft3d(j)
         fock3(inddyy(i,05))=fock3(inddyy(i,05))+ddd(i,6*04+j)*xcft3d(j)
         fock3(inddyy(i,06))=fock3(inddyy(i,06))+ddd(i,6*05+j)*xcft3d(j)
         fock3(inddyy(i,09))=fock3(inddyy(i,09))+ddd(i,6*08+j)*xcft3d(j)
         fock3(inddyy(i,10))=fock3(inddyy(i,10))+ddd(i,6*09+j)*xcft3d(j)
         fock3(inddyy(i,11))=fock3(inddyy(i,11))+ddd(i,6*10+j)*xcft3d(j)
         fock3(inddyy(i,12))=fock3(inddyy(i,12))+ddd(i,6*11+j)*xcft3d(j)
         fock3(inddyy(i,16))=fock3(inddyy(i,16))+ddd(i,6*15+j)*xcft3d(j)
         fock3(inddyy(i,17))=fock3(inddyy(i,17))+ddd(i,6*16+j)*xcft3d(j)
         fock3(inddyy(i,18))=fock3(inddyy(i,18))+ddd(i,6*17+j)*xcft3d(j)
         fock3(inddyy(i,23))=fock3(inddyy(i,23))+ddd(i,6*22+j)*xcft3d(j)
         fock3(inddyy(i,24))=fock3(inddyy(i,24))+ddd(i,6*23+j)*xcft3d(j)
         fock3(inddyy(i,30))=fock3(inddyy(i,30))+ddd(i,6*29+j)*xcft3d(j)

                        endif
 2023 continue

 2001 continue

      do 3001 i=1,m

      fock1(inddyy(i,01))=fock1(inddyy(i,01))/three
      fock1(inddyy(i,07))=fock1(inddyy(i,07))/sqrt3
      fock1(inddyy(i,13))=fock1(inddyy(i,13))/sqrt3
      fock1(inddyy(i,19))=fock1(inddyy(i,19))/three
      fock1(inddyy(i,20))=fock1(inddyy(i,20))/sqrt3
      fock1(inddyy(i,21))=fock1(inddyy(i,21))/sqrt3
      fock1(inddyy(i,22))=fock1(inddyy(i,22))/three
      fock1(inddyy(i,25))=fock1(inddyy(i,25))/sqrt3
      fock1(inddyy(i,28))=fock1(inddyy(i,28))/sqrt3
      fock1(inddyy(i,31))=fock1(inddyy(i,31))/three
      fock1(inddyy(i,32))=fock1(inddyy(i,32))/sqrt3
      fock1(inddyy(i,33))=fock1(inddyy(i,33))/sqrt3
      fock1(inddyy(i,34))=fock1(inddyy(i,34))/three
      fock1(inddyy(i,35))=fock1(inddyy(i,35))/sqrt3
      fock1(inddyy(i,36))=fock1(inddyy(i,36))/three

      fock2(inddyy(i,01))=fock2(inddyy(i,01))/three
      fock2(inddyy(i,07))=fock2(inddyy(i,07))/sqrt3
      fock2(inddyy(i,13))=fock2(inddyy(i,13))/sqrt3
      fock2(inddyy(i,19))=fock2(inddyy(i,19))/three
      fock2(inddyy(i,20))=fock2(inddyy(i,20))/sqrt3
      fock2(inddyy(i,21))=fock2(inddyy(i,21))/sqrt3
      fock2(inddyy(i,22))=fock2(inddyy(i,22))/three
      fock2(inddyy(i,25))=fock2(inddyy(i,25))/sqrt3
      fock2(inddyy(i,28))=fock2(inddyy(i,28))/sqrt3
      fock2(inddyy(i,31))=fock2(inddyy(i,31))/three
      fock2(inddyy(i,32))=fock2(inddyy(i,32))/sqrt3
      fock2(inddyy(i,33))=fock2(inddyy(i,33))/sqrt3
      fock2(inddyy(i,34))=fock2(inddyy(i,34))/three
      fock2(inddyy(i,35))=fock2(inddyy(i,35))/sqrt3
      fock2(inddyy(i,36))=fock2(inddyy(i,36))/three

      fock3(inddyy(i,01))=fock3(inddyy(i,01))/three
      fock3(inddyy(i,07))=fock3(inddyy(i,07))/sqrt3
      fock3(inddyy(i,13))=fock3(inddyy(i,13))/sqrt3
      fock3(inddyy(i,19))=fock3(inddyy(i,19))/three
      fock3(inddyy(i,20))=fock3(inddyy(i,20))/sqrt3
      fock3(inddyy(i,21))=fock3(inddyy(i,21))/sqrt3
      fock3(inddyy(i,22))=fock3(inddyy(i,22))/three
      fock3(inddyy(i,25))=fock3(inddyy(i,25))/sqrt3
      fock3(inddyy(i,28))=fock3(inddyy(i,28))/sqrt3
      fock3(inddyy(i,31))=fock3(inddyy(i,31))/three
      fock3(inddyy(i,32))=fock3(inddyy(i,32))/sqrt3
      fock3(inddyy(i,33))=fock3(inddyy(i,33))/sqrt3
      fock3(inddyy(i,34))=fock3(inddyy(i,34))/three
      fock3(inddyy(i,35))=fock3(inddyy(i,35))/sqrt3
      fock3(inddyy(i,36))=fock3(inddyy(i,36))/three

 3001 continue

      do 3002 i=1,m
      if(iminj(i).ne.0) then

                   fock1(inddyy(i,02))=fock1(inddyy(i,02))/sqrt3
                   fock1(inddyy(i,03))=fock1(inddyy(i,03))/sqrt3
                   fock1(inddyy(i,04))=fock1(inddyy(i,04))/three
                   fock1(inddyy(i,05))=fock1(inddyy(i,05))/sqrt3
                   fock1(inddyy(i,06))=fock1(inddyy(i,06))/three
                   fock1(inddyy(i,10))=fock1(inddyy(i,10))/sqrt3
                   fock1(inddyy(i,12))=fock1(inddyy(i,12))/sqrt3
                   fock1(inddyy(i,16))=fock1(inddyy(i,16))/sqrt3
                   fock1(inddyy(i,18))=fock1(inddyy(i,18))/sqrt3
                   fock1(inddyy(i,23))=fock1(inddyy(i,23))/sqrt3
                   fock1(inddyy(i,24))=fock1(inddyy(i,24))/three
                   fock1(inddyy(i,30))=fock1(inddyy(i,30))/sqrt3

                   fock2(inddyy(i,02))=fock2(inddyy(i,02))/sqrt3
                   fock2(inddyy(i,03))=fock2(inddyy(i,03))/sqrt3
                   fock2(inddyy(i,04))=fock2(inddyy(i,04))/three
                   fock2(inddyy(i,05))=fock2(inddyy(i,05))/sqrt3
                   fock2(inddyy(i,06))=fock2(inddyy(i,06))/three
                   fock2(inddyy(i,10))=fock2(inddyy(i,10))/sqrt3
                   fock2(inddyy(i,12))=fock2(inddyy(i,12))/sqrt3
                   fock2(inddyy(i,16))=fock2(inddyy(i,16))/sqrt3
                   fock2(inddyy(i,18))=fock2(inddyy(i,18))/sqrt3
                   fock2(inddyy(i,23))=fock2(inddyy(i,23))/sqrt3
                   fock2(inddyy(i,24))=fock2(inddyy(i,24))/three
                   fock2(inddyy(i,30))=fock2(inddyy(i,30))/sqrt3

                   fock3(inddyy(i,02))=fock3(inddyy(i,02))/sqrt3
                   fock3(inddyy(i,03))=fock3(inddyy(i,03))/sqrt3
                   fock3(inddyy(i,04))=fock3(inddyy(i,04))/three
                   fock3(inddyy(i,05))=fock3(inddyy(i,05))/sqrt3
                   fock3(inddyy(i,06))=fock3(inddyy(i,06))/three
                   fock3(inddyy(i,10))=fock3(inddyy(i,10))/sqrt3
                   fock3(inddyy(i,12))=fock3(inddyy(i,12))/sqrt3
                   fock3(inddyy(i,16))=fock3(inddyy(i,16))/sqrt3
                   fock3(inddyy(i,18))=fock3(inddyy(i,18))/sqrt3
                   fock3(inddyy(i,23))=fock3(inddyy(i,23))/sqrt3
                   fock3(inddyy(i,24))=fock3(inddyy(i,24))/three
                   fock3(inddyy(i,30))=fock3(inddyy(i,30))/sqrt3

                        endif
 3002 continue

      return
      end
