      subroutine xcaddgrad(ncntrt,ndim,npts,nfuncatom,xcalph,xcbeta,qf,
     &                     qx,qy,qz,tx,ty,tz,dmta,dmtb,grad,wv,wv1,wv2)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension nfuncatom(*)

      dimension xcalph(*),xcbeta(*)
      dimension qf(ndim,*),qx(ncntrt,*),qy(ncntrt,*),qz(ncntrt,*),
     &                     tx(ncntrt,*),ty(ncntrt,*),tz(ncntrt,*)
      dimension dmta(ncntrt,*),dmtb(ncntrt,*),grad(3,*)
      dimension wv(*),wv1(*),wv2(*)

      data zero,tolerance/0.0,1.0e-10/

      do 1001 j=1,npts
      do 1001 i=1,ncntrt
      qx(i,j)=tx(i,j)
      qy(i,j)=ty(i,j)
 1001 qz(i,j)=tz(i,j)

      do 1002 j=1,npts
      do 1002 i=1,ncntrt
      tx(i,j)=zero
      ty(i,j)=zero
 1002 tz(i,j)=zero

      do 1003 j=1,ncntrt

      do 1004 k=1,npts
      wv1(k)=xcalph(k)*qf(k,j)
 1004 wv2(k)=xcbeta(k)*qf(k,j)

      do 1003 k=1,npts

      if(abs(wv1(k)+wv2(k)).lt.tolerance) goto 1003

      do 1005 i=1,ncntrt
 1005 wv(i)=dmta(i,j)*wv1(k)

      do 1006 i=1,ncntrt
 1006 wv(i)=wv(i)+dmtb(i,j)*wv2(k)

      do 1007 i=1,ncntrt
      tx(i,k)=tx(i,k)+wv(i)*qx(i,k)
      ty(i,k)=ty(i,k)+wv(i)*qy(i,k)
 1007 tz(i,k)=tz(i,k)+wv(i)*qz(i,k)

 1003 continue

      do 1008 i=1,ncntrt
      do 1008 j=1,npts
      grad(1,nfuncatom(i))=grad(1,nfuncatom(i))-tx(i,j)
      grad(2,nfuncatom(i))=grad(2,nfuncatom(i))-ty(i,j)
 1008 grad(3,nfuncatom(i))=grad(3,nfuncatom(i))-tz(i,j)

      return
      end
