      subroutine points(npts,nrandom,radius,rweight,center,gridpoint,
     &                  weight)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xcoord(194),ycoord(194),zcoord(194)

      dimension center(*),gridpoint(3,*),weight(*)

      if(npts.eq.12) call ang12(xcoord,ycoord,zcoord,weight)
      if(npts.eq.26) call ang26(xcoord,ycoord,zcoord,weight)
      if(npts.eq.50) call ang50(xcoord,ycoord,zcoord,weight)
      if(npts.eq.110) call ang110(xcoord,ycoord,zcoord,weight)
      if(npts.eq.194) call ang194(xcoord,ycoord,zcoord,weight)

      do 1001 i=1,npts
      gridpoint(1,i)=xcoord(i)*radius
      gridpoint(2,i)=ycoord(i)*radius
 1001 gridpoint(3,i)=zcoord(i)*radius

      do 1002 i=1,npts
 1002 weight(i)=weight(i)*rweight

      if(nrandom.eq.1) call spingrid(npts,gridpoint)

      do 1003 i=1,npts
      do 1003 j=1,3
 1003 gridpoint(j,i)=gridpoint(j,i)+center(j)

      return
      end
