      subroutine gradxxpp(m,n,ncds,ncdspd,ilfunc,icfunc,iminj,icontr,
     &                    inddyy,icentr,iicontr,g,coord,density,
     &                    gradient,cdfitc,alphaaux,coeffs,coeffp,coeffd,
     &                    zeta,twozetaa,twozetab,px,py,pz,base,pxax,
     &                    pyay,pzaz,axbx,ayby,azbz,zzeta,ttwozetaa,
     &                    ttwozetab,zetarec,ppx,ppy,ppz,ppxax,ppyay,
     &                    ppzaz,wxpx,wypy,wzpz,wxcx,wycy,wzcz,zetac1,
     &                    zetac2,u,sss0,sss1,sss2,sss3,sss4,sss5,pss0,
     &                    pss1,pss2,pss3,pss4,dss0,dss1,dss2,dss3,fss0,
     &                    fss1,fss2,ssp0,ssp1,ssd0,psp0,psp1,psd0,dsp0,
     &                    dsp1,dsd0,fsp0,fsp1,fsd0,c,c1,c2,ssscond,
     &                    sspcond,ssdcond,psscond,pspcond,psdcond,
     &                    spscond,sppcond,spdcond,dsscond,dspcond,
     &                    dsdcond,ppscond,pppcond,ppdcond,fsscond,
     &                    fspcond,fsdcond,dpscond,dppcond,dpdcond,
     &                    pdscond,pdpcond,pddcond,grad)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),iminj(*),icontr(*),inddyy(m,*),
     &          icentr(m,*),iicontr(*)

      dimension cdfitp(3),cdfitd(6)

      dimension g(*),coord(3,*),density(*),gradient(3,*),cdfitc(*),
     &          alphaaux(*),coeffs(*),coeffp(*),coeffd(*),zeta(*),
     &          twozetaa(*),twozetab(*),px(*),py(*),pz(*),base(*),
     &          pxax(*),pyay(*),pzaz(*),axbx(*),ayby(*),azbz(*),
     &          zzeta(*),ttwozetaa(*),ttwozetab(*),zetarec(*),ppx(*),
     &          ppy(*),ppz(*),ppxax(*),ppyay(*),ppzaz(*),wxpx(*),
     &          wypy(*),wzpz(*),wxcx(*),wycy(*),wzcz(*),zetac1(*),
     &          zetac2(*),u(*),sss0(*),sss1(*),sss2(*),sss3(*),sss4(*),
     &          sss5(*),pss0(n,*),pss1(n,*),pss2(n,*),pss3(n,*),
     &          pss4(n,*),dss0(n,*),dss1(n,*),dss2(n,*),dss3(n,*),
     &          fss0(n,*),fss1(n,*),fss2(n,*),ssp0(n,*),ssp1(n,*),
     &          ssd0(n,*),psp0(n,*),psp1(n,*),psd0(n,*),dsp0(n,*),
     &          dsp1(n,*),dsd0(n,*),fsp0(n,*),fsp1(n,*),fsd0(n,*),c(*),
     &          c1(n,*),c2(n,*),ssscond(*),sspcond(m,*),ssdcond(m,*),
     &          psscond(m,*),pspcond(m,*),psdcond(m,*),spscond(m,*),
     &          sppcond(m,*),spdcond(m,*),dsscond(m,*),dspcond(m,*),
     &          dsdcond(m,*),ppscond(m,*),pppcond(m,*),ppdcond(m,*),
     &          fsscond(m,*),fspcond(m,*),fsdcond(m,*),dpscond(m,*),
     &          dppcond(m,*),dpdcond(m,*),pdscond(m,*),pdpcond(m,*),
     &          pddcond(m,*),grad(m,*)

      data one,two,three,four,five,seven/1.0,2.0,3.0,4.0,5.0,7.0/
      data zero,half,thrhlf,pi/0.0,0.5,1.5,3.1415926535898/
      data calcut/1.0e-16/

      twoeconst=two*pi**(five/two)

      dnormcd=seven/sqrt(three)

      do 1001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      nc=icfunc(ilaux)

      ccx=coord(1,nc)
      ccy=coord(2,nc)
      ccz=coord(3,nc)

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(6,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
      sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux
 1004 sss5(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(6)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n
      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ttwozetaa(nn)=twozetaa(i)
                                       ttwozetab(nn)=twozetab(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                       sss5(nn)=sss5(i)
                                 endif
 1005 continue

      do 1006 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 1006 zetac2(i)=zzeta(i)*zetarec(i)

      do 1007 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 1007 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 1008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1009 i=1,nn
      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
 1009 pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      do 1010 i=1,nn
      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
 1010 pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      do 1011 i=1,nn
      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
 1011 pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      do 1012 i=1,nn
      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
 1012 pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

      do 1013 i=1,nn
      pss4(i,1)=ppxax(i)*sss4(i)+wxpx(i)*sss5(i)
      pss4(i,2)=ppyay(i)*sss4(i)+wypy(i)*sss5(i)
 1013 pss4(i,3)=ppzaz(i)*sss4(i)+wzpz(i)*sss5(i)

      do 1014 i=1,nn
 1014 c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      do 1015 i=1,nn
      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
 1015 dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      do 1016 i=1,nn
 1016 c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      do 1017 i=1,nn
      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
 1017 dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      do 1018 i=1,nn
 1018 c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      do 1019 i=1,nn
      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
 1019 dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

      do 1020 i=1,nn
 1020 c(i)=(sss3(i)-zetac1(i)*sss4(i))/(two*zzeta(i))

      do 1021 i=1,nn
      dss3(i,1)=ppxax(i)*pss3(i,1)+wxpx(i)*pss4(i,1)+c(i)
      dss3(i,2)=ppyay(i)*pss3(i,1)+wypy(i)*pss4(i,1)
      dss3(i,3)=ppzaz(i)*pss3(i,1)+wzpz(i)*pss4(i,1)
      dss3(i,4)=ppyay(i)*pss3(i,2)+wypy(i)*pss4(i,2)+c(i)
      dss3(i,5)=ppzaz(i)*pss3(i,2)+wzpz(i)*pss4(i,2)
 1021 dss3(i,6)=ppzaz(i)*pss3(i,3)+wzpz(i)*pss4(i,3)+c(i)

      do 1022 j=1,3
      do 1022 i=1,nn
 1022 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zzeta(i))

      do 1023 i=1,nn
      fss0(i,01)=ppxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=ppyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=ppzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=ppyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=ppzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=ppzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=ppyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=ppzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=ppzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 1023 fss0(i,10)=ppzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 1024 j=1,3
      do 1024 i=1,nn
 1024 c1(i,j)=(pss1(i,j)-zetac1(i)*pss2(i,j))/(two*zzeta(i))

      do 1025 i=1,nn
      fss1(i,01)=ppxax(i)*dss1(i,1)+wxpx(i)*dss2(i,1)+c1(i,1)+c1(i,1)
      fss1(i,02)=ppyay(i)*dss1(i,1)+wypy(i)*dss2(i,1)
      fss1(i,03)=ppzaz(i)*dss1(i,1)+wzpz(i)*dss2(i,1)
      fss1(i,04)=ppyay(i)*dss1(i,2)+wypy(i)*dss2(i,2)+c1(i,1)
      fss1(i,05)=ppzaz(i)*dss1(i,2)+wzpz(i)*dss2(i,2)
      fss1(i,06)=ppzaz(i)*dss1(i,3)+wzpz(i)*dss2(i,3)+c1(i,1)
      fss1(i,07)=ppyay(i)*dss1(i,4)+wypy(i)*dss2(i,4)+c1(i,2)+c1(i,2)
      fss1(i,08)=ppzaz(i)*dss1(i,4)+wzpz(i)*dss2(i,4)
      fss1(i,09)=ppzaz(i)*dss1(i,5)+wzpz(i)*dss2(i,5)+c1(i,2)
 1025 fss1(i,10)=ppzaz(i)*dss1(i,6)+wzpz(i)*dss2(i,6)+c1(i,3)+c1(i,3)

      do 1026 j=1,3
      do 1026 i=1,nn
 1026 c1(i,j)=(pss2(i,j)-zetac1(i)*pss3(i,j))/(two*zzeta(i))

      do 1027 i=1,nn
      fss2(i,01)=ppxax(i)*dss2(i,1)+wxpx(i)*dss3(i,1)+c1(i,1)+c1(i,1)
      fss2(i,02)=ppyay(i)*dss2(i,1)+wypy(i)*dss3(i,1)
      fss2(i,03)=ppzaz(i)*dss2(i,1)+wzpz(i)*dss3(i,1)
      fss2(i,04)=ppyay(i)*dss2(i,2)+wypy(i)*dss3(i,2)+c1(i,1)
      fss2(i,05)=ppzaz(i)*dss2(i,2)+wzpz(i)*dss3(i,2)
      fss2(i,06)=ppzaz(i)*dss2(i,3)+wzpz(i)*dss3(i,3)+c1(i,1)
      fss2(i,07)=ppyay(i)*dss2(i,4)+wypy(i)*dss3(i,4)+c1(i,2)+c1(i,2)
      fss2(i,08)=ppzaz(i)*dss2(i,4)+wzpz(i)*dss3(i,4)
      fss2(i,09)=ppzaz(i)*dss2(i,5)+wzpz(i)*dss3(i,5)+c1(i,2)
 1027 fss2(i,10)=ppzaz(i)*dss2(i,6)+wzpz(i)*dss3(i,6)+c1(i,3)+c1(i,3)

      do 1028 i=1,nn
      ssp0(i,1)=wxcx(i)*sss1(i)
      ssp0(i,2)=wycy(i)*sss1(i)
 1028 ssp0(i,3)=wzcz(i)*sss1(i)

      do 1029 i=1,nn
      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
 1029 ssp1(i,3)=wzcz(i)*sss2(i)

      do 1030 i=1,nn
 1030 c(i)=(sss0(i)-zetac2(i)*sss1(i))/(two*zetaux)

      do 1031 i=1,nn
      ssd0(i,1)=wxcx(i)*ssp1(i,1)+c(i)
      ssd0(i,2)=wycy(i)*ssp1(i,1)
      ssd0(i,3)=wzcz(i)*ssp1(i,1)
      ssd0(i,4)=wycy(i)*ssp1(i,2)+c(i)
      ssd0(i,5)=wzcz(i)*ssp1(i,2)
 1031 ssd0(i,6)=wzcz(i)*ssp1(i,3)+c(i)

      do 1032 i=1,nn
 1032 c(i)=half*sss1(i)*zetarec(i)

      do 1033 i=1,nn
      psp0(i,1)=wxcx(i)*pss1(i,1)+c(i)
      psp0(i,2)=wycy(i)*pss1(i,1)
      psp0(i,3)=wzcz(i)*pss1(i,1)
      psp0(i,4)=wxcx(i)*pss1(i,2)
      psp0(i,5)=wycy(i)*pss1(i,2)+c(i)
      psp0(i,6)=wzcz(i)*pss1(i,2)
      psp0(i,7)=wxcx(i)*pss1(i,3)
      psp0(i,8)=wycy(i)*pss1(i,3)
 1033 psp0(i,9)=wzcz(i)*pss1(i,3)+c(i)

      do 1034 i=1,nn
 1034 c(i)=half*sss2(i)*zetarec(i)

      do 1035 i=1,nn
      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
 1035 psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

      do 1036 j=1,3
      do 1036 i=1,nn
 1036 c1(i,j)=(pss0(i,j)-zetac2(i)*pss1(i,j))/(two*zetaux)

      do 1037 j=1,3
      do 1037 i=1,nn
 1037 c2(i,j)=half*ssp1(i,j)*zetarec(i)

      do 1038 i=1,nn
      psd0(i,01)=wxcx(i)*psp1(i,1)+c1(i,1)+c2(i,1)
      psd0(i,02)=wycy(i)*psp1(i,1)
      psd0(i,03)=wzcz(i)*psp1(i,1)
      psd0(i,04)=wycy(i)*psp1(i,2)+c1(i,1)
      psd0(i,05)=wzcz(i)*psp1(i,2)
      psd0(i,06)=wzcz(i)*psp1(i,3)+c1(i,1)
      psd0(i,07)=wxcx(i)*psp1(i,4)+c1(i,2)
      psd0(i,08)=wycy(i)*psp1(i,4)        +c2(i,1)
      psd0(i,09)=wzcz(i)*psp1(i,4)
      psd0(i,10)=wycy(i)*psp1(i,5)+c1(i,2)+c2(i,2)
      psd0(i,11)=wzcz(i)*psp1(i,5)
      psd0(i,12)=wzcz(i)*psp1(i,6)+c1(i,2)
      psd0(i,13)=wxcx(i)*psp1(i,7)+c1(i,3)
      psd0(i,14)=wycy(i)*psp1(i,7)
      psd0(i,15)=wzcz(i)*psp1(i,7)        +c2(i,1)
      psd0(i,16)=wycy(i)*psp1(i,8)+c1(i,3)
      psd0(i,17)=wzcz(i)*psp1(i,8)        +c2(i,2)
 1038 psd0(i,18)=wzcz(i)*psp1(i,9)+c1(i,3)+c2(i,3)

      do 1039 j=1,3
      do 1039 i=1,nn
 1039 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 1040 i=1,nn
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 1040 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 1041 j=1,3
      do 1041 i=1,nn
 1041 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 1042 i=1,nn
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 1042 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 1043 j=1,6
      do 1043 i=1,nn
 1043 c1(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 1044 j=1,9
      do 1044 i=1,nn
 1044 c2(i,j)=half*psp1(i,j)*zetarec(i)

      do 1045 i=1,nn
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c1(i,1)+c2(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c1(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c1(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c1(i,2)+c2(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c2(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c1(i,2)+c2(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c1(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c1(i,3)+c2(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c2(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c1(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c2(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c1(i,3)+c2(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c1(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c2(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c1(i,4)+c2(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c1(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c1(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c2(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c2(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c1(i,5)+c2(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c2(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c1(i,5)+c2(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c1(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c2(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c1(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c2(i,8)*two
 1045 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c1(i,6)+c2(i,9)*two

      do 1046 j=1,6
      do 1046 i=1,nn
 1046 c1(i,j)=half*dss1(i,j)*zetarec(i)

      do 1047 i=1,nn
      fsp0(i,01)=wxcx(i)*fss1(i,01)+c1(i,1)*three
      fsp0(i,02)=wycy(i)*fss1(i,01)
      fsp0(i,03)=wzcz(i)*fss1(i,01)
      fsp0(i,04)=wxcx(i)*fss1(i,02)+c1(i,2)*two
      fsp0(i,05)=wycy(i)*fss1(i,02)+c1(i,1)
      fsp0(i,06)=wzcz(i)*fss1(i,02)
      fsp0(i,07)=wxcx(i)*fss1(i,03)+c1(i,3)*two
      fsp0(i,08)=wycy(i)*fss1(i,03)
      fsp0(i,09)=wzcz(i)*fss1(i,03)+c1(i,1)
      fsp0(i,10)=wxcx(i)*fss1(i,04)+c1(i,4)
      fsp0(i,11)=wycy(i)*fss1(i,04)+c1(i,2)*two
      fsp0(i,12)=wzcz(i)*fss1(i,04)
      fsp0(i,13)=wxcx(i)*fss1(i,05)+c1(i,5)
      fsp0(i,14)=wycy(i)*fss1(i,05)+c1(i,3)
      fsp0(i,15)=wzcz(i)*fss1(i,05)+c1(i,2)
      fsp0(i,16)=wxcx(i)*fss1(i,06)+c1(i,6)
      fsp0(i,17)=wycy(i)*fss1(i,06)
      fsp0(i,18)=wzcz(i)*fss1(i,06)+c1(i,3)*two
      fsp0(i,19)=wxcx(i)*fss1(i,07)
      fsp0(i,20)=wycy(i)*fss1(i,07)+c1(i,4)*three
      fsp0(i,21)=wzcz(i)*fss1(i,07)
      fsp0(i,22)=wxcx(i)*fss1(i,08)
      fsp0(i,23)=wycy(i)*fss1(i,08)+c1(i,5)*two
      fsp0(i,24)=wzcz(i)*fss1(i,08)+c1(i,4)
      fsp0(i,25)=wxcx(i)*fss1(i,09)
      fsp0(i,26)=wycy(i)*fss1(i,09)+c1(i,6)
      fsp0(i,27)=wzcz(i)*fss1(i,09)+c1(i,5)*two
      fsp0(i,28)=wxcx(i)*fss1(i,10)
      fsp0(i,29)=wycy(i)*fss1(i,10)
 1047 fsp0(i,30)=wzcz(i)*fss1(i,10)+c1(i,6)*three

      do 1048 j=1,6
      do 1048 i=1,nn
 1048 c1(i,j)=half*dss2(i,j)*zetarec(i)

      do 1049 i=1,nn
      fsp1(i,01)=wxcx(i)*fss2(i,01)+c1(i,1)*three
      fsp1(i,02)=wycy(i)*fss2(i,01)
      fsp1(i,03)=wzcz(i)*fss2(i,01)
      fsp1(i,04)=wxcx(i)*fss2(i,02)+c1(i,2)*two
      fsp1(i,05)=wycy(i)*fss2(i,02)+c1(i,1)
      fsp1(i,06)=wzcz(i)*fss2(i,02)
      fsp1(i,07)=wxcx(i)*fss2(i,03)+c1(i,3)*two
      fsp1(i,08)=wycy(i)*fss2(i,03)
      fsp1(i,09)=wzcz(i)*fss2(i,03)+c1(i,1)
      fsp1(i,10)=wxcx(i)*fss2(i,04)+c1(i,4)
      fsp1(i,11)=wycy(i)*fss2(i,04)+c1(i,2)*two
      fsp1(i,12)=wzcz(i)*fss2(i,04)
      fsp1(i,13)=wxcx(i)*fss2(i,05)+c1(i,5)
      fsp1(i,14)=wycy(i)*fss2(i,05)+c1(i,3)
      fsp1(i,15)=wzcz(i)*fss2(i,05)+c1(i,2)
      fsp1(i,16)=wxcx(i)*fss2(i,06)+c1(i,6)
      fsp1(i,17)=wycy(i)*fss2(i,06)
      fsp1(i,18)=wzcz(i)*fss2(i,06)+c1(i,3)*two
      fsp1(i,19)=wxcx(i)*fss2(i,07)
      fsp1(i,20)=wycy(i)*fss2(i,07)+c1(i,4)*three
      fsp1(i,21)=wzcz(i)*fss2(i,07)
      fsp1(i,22)=wxcx(i)*fss2(i,08)
      fsp1(i,23)=wycy(i)*fss2(i,08)+c1(i,5)*two
      fsp1(i,24)=wzcz(i)*fss2(i,08)+c1(i,4)
      fsp1(i,25)=wxcx(i)*fss2(i,09)
      fsp1(i,26)=wycy(i)*fss2(i,09)+c1(i,6)
      fsp1(i,27)=wzcz(i)*fss2(i,09)+c1(i,5)*two
      fsp1(i,28)=wxcx(i)*fss2(i,10)
      fsp1(i,29)=wycy(i)*fss2(i,10)
 1049 fsp1(i,30)=wzcz(i)*fss2(i,10)+c1(i,6)*three

      do 1050 j=1,10
      do 1050 i=1,nn
 1050 c1(i,j)=(fss0(i,j)-zetac2(i)*fss1(i,j))/(two*zetaux)

      do 1051 j=1,18
      do 1051 i=1,nn
 1051 c2(i,j)=half*dsp1(i,j)*zetarec(i)

      do 1052 i=1,nn
      fsd0(i,01)=wxcx(i)*fsp1(i,01)+c1(i,01)+c2(i,01)*three
      fsd0(i,02)=wycy(i)*fsp1(i,01)
      fsd0(i,03)=wzcz(i)*fsp1(i,01)
      fsd0(i,04)=wycy(i)*fsp1(i,02)+c1(i,01)
      fsd0(i,05)=wzcz(i)*fsp1(i,02)
      fsd0(i,06)=wzcz(i)*fsp1(i,03)+c1(i,01)
      fsd0(i,07)=wxcx(i)*fsp1(i,04)+c1(i,02)+c2(i,04)*two
      fsd0(i,08)=wycy(i)*fsp1(i,04)         +c2(i,01)
      fsd0(i,09)=wzcz(i)*fsp1(i,04)
      fsd0(i,10)=wycy(i)*fsp1(i,05)+c1(i,02)+c2(i,02)
      fsd0(i,11)=wzcz(i)*fsp1(i,05)
      fsd0(i,12)=wzcz(i)*fsp1(i,06)+c1(i,02)
      fsd0(i,13)=wxcx(i)*fsp1(i,07)+c1(i,03)+c2(i,07)*two
      fsd0(i,14)=wycy(i)*fsp1(i,07)
      fsd0(i,15)=wzcz(i)*fsp1(i,07)         +c2(i,01)
      fsd0(i,16)=wycy(i)*fsp1(i,08)+c1(i,03)
      fsd0(i,17)=wzcz(i)*fsp1(i,08)         +c2(i,02)
      fsd0(i,18)=wzcz(i)*fsp1(i,09)+c1(i,03)+c2(i,03)
      fsd0(i,19)=wxcx(i)*fsp1(i,10)+c1(i,04)+c2(i,10)
      fsd0(i,20)=wycy(i)*fsp1(i,10)         +c2(i,04)*two
      fsd0(i,21)=wzcz(i)*fsp1(i,10)
      fsd0(i,22)=wycy(i)*fsp1(i,11)+c1(i,04)+c2(i,05)*two
      fsd0(i,23)=wzcz(i)*fsp1(i,11)
      fsd0(i,24)=wzcz(i)*fsp1(i,12)+c1(i,04)
      fsd0(i,25)=wxcx(i)*fsp1(i,13)+c1(i,05)+c2(i,13)
      fsd0(i,26)=wycy(i)*fsp1(i,13)         +c2(i,07)
      fsd0(i,27)=wzcz(i)*fsp1(i,13)         +c2(i,04)
      fsd0(i,28)=wycy(i)*fsp1(i,14)+c1(i,05)+c2(i,08)
      fsd0(i,29)=wzcz(i)*fsp1(i,14)         +c2(i,05)
      fsd0(i,30)=wzcz(i)*fsp1(i,15)+c1(i,05)+c2(i,06)
      fsd0(i,31)=wxcx(i)*fsp1(i,16)+c1(i,06)+c2(i,16)
      fsd0(i,32)=wycy(i)*fsp1(i,16)
      fsd0(i,33)=wzcz(i)*fsp1(i,16)         +c2(i,07)*two
      fsd0(i,34)=wycy(i)*fsp1(i,17)+c1(i,06)
      fsd0(i,35)=wzcz(i)*fsp1(i,17)         +c2(i,08)*two
      fsd0(i,36)=wzcz(i)*fsp1(i,18)+c1(i,06)+c2(i,09)*two
      fsd0(i,37)=wxcx(i)*fsp1(i,19)+c1(i,07)
      fsd0(i,38)=wycy(i)*fsp1(i,19)         +c2(i,10)*three
      fsd0(i,39)=wzcz(i)*fsp1(i,19)
      fsd0(i,40)=wycy(i)*fsp1(i,20)+c1(i,07)+c2(i,11)*three
      fsd0(i,41)=wzcz(i)*fsp1(i,20)
      fsd0(i,42)=wzcz(i)*fsp1(i,21)+c1(i,07)
      fsd0(i,43)=wxcx(i)*fsp1(i,22)+c1(i,08)
      fsd0(i,44)=wycy(i)*fsp1(i,22)         +c2(i,13)*two
      fsd0(i,45)=wzcz(i)*fsp1(i,22)         +c2(i,10)
      fsd0(i,46)=wycy(i)*fsp1(i,23)+c1(i,08)+c2(i,14)*two
      fsd0(i,47)=wzcz(i)*fsp1(i,23)         +c2(i,11)
      fsd0(i,48)=wzcz(i)*fsp1(i,24)+c1(i,08)+c2(i,12)
      fsd0(i,49)=wxcx(i)*fsp1(i,25)+c1(i,09)
      fsd0(i,50)=wycy(i)*fsp1(i,25)         +c2(i,16)
      fsd0(i,51)=wzcz(i)*fsp1(i,25)         +c2(i,13)*two
      fsd0(i,52)=wycy(i)*fsp1(i,26)+c1(i,09)+c2(i,17)
      fsd0(i,53)=wzcz(i)*fsp1(i,26)         +c2(i,14)*two
      fsd0(i,54)=wzcz(i)*fsp1(i,27)+c1(i,09)+c2(i,15)*two
      fsd0(i,55)=wxcx(i)*fsp1(i,28)+c1(i,10)
      fsd0(i,56)=wycy(i)*fsp1(i,28)
      fsd0(i,57)=wzcz(i)*fsp1(i,28)         +c2(i,16)*three
      fsd0(i,58)=wycy(i)*fsp1(i,29)+c1(i,10)
      fsd0(i,59)=wzcz(i)*fsp1(i,29)         +c2(i,17)*three
 1052 fsd0(i,60)=wzcz(i)*fsp1(i,30)+c1(i,10)+c2(i,18)*three

      do 1053 i=1,m
 1053 ssscond(i)=zero

      do 1054 j=1,3
      do 1054 i=1,m
 1054 sspcond(i,j)=zero

      do 1055 j=1,6
      do 1055 i=1,m
 1055 ssdcond(i,j)=zero

      do 1056 j=1,3
      do 1056 i=1,m
 1056 psscond(i,j)=zero

      do 1057 j=1,9
      do 1057 i=1,m
 1057 pspcond(i,j)=zero

      do 1058 j=1,18
      do 1058 i=1,m
 1058 psdcond(i,j)=zero

      do 1059 i=1,nn
 1059 ssscond(iicontr(i))=ssscond(iicontr(i))-sss0(i)

      do 1060 j=1,3
      do 1060 i=1,nn
 1060 sspcond(iicontr(i),j)=sspcond(iicontr(i),j)-ssp0(i,j)

      do 1061 j=1,6
      do 1061 i=1,nn
 1061 ssdcond(iicontr(i),j)=ssdcond(iicontr(i),j)-ssd0(i,j)

      do 1062 j=1,3
      do 1062 i=1,nn
 1062 psscond(iicontr(i),j)=psscond(iicontr(i),j)-pss0(i,j)

      do 1063 j=1,9
      do 1063 i=1,nn
 1063 pspcond(iicontr(i),j)=pspcond(iicontr(i),j)-psp0(i,j)

      do 1064 j=1,18
      do 1064 i=1,nn
 1064 psdcond(iicontr(i),j)=psdcond(iicontr(i),j)-psd0(i,j)

      do 1065 i=1,m
      spscond(i,1)=axbx(i)*ssscond(i)+psscond(i,1)
      spscond(i,2)=ayby(i)*ssscond(i)+psscond(i,2)
 1065 spscond(i,3)=azbz(i)*ssscond(i)+psscond(i,3)

      do 1066 i=1,m
      sppcond(i,1)=axbx(i)*sspcond(i,1)+pspcond(i,1)
      sppcond(i,2)=axbx(i)*sspcond(i,2)+pspcond(i,2)
      sppcond(i,3)=axbx(i)*sspcond(i,3)+pspcond(i,3)
      sppcond(i,4)=ayby(i)*sspcond(i,1)+pspcond(i,4)
      sppcond(i,5)=ayby(i)*sspcond(i,2)+pspcond(i,5)
      sppcond(i,6)=ayby(i)*sspcond(i,3)+pspcond(i,6)
      sppcond(i,7)=azbz(i)*sspcond(i,1)+pspcond(i,7)
      sppcond(i,8)=azbz(i)*sspcond(i,2)+pspcond(i,8)
 1066 sppcond(i,9)=azbz(i)*sspcond(i,3)+pspcond(i,9)

      do 1067 i=1,m
      spdcond(i,01)=axbx(i)*ssdcond(i,1)+psdcond(i,01)
      spdcond(i,02)=axbx(i)*ssdcond(i,2)+psdcond(i,02)
      spdcond(i,03)=axbx(i)*ssdcond(i,3)+psdcond(i,03)
      spdcond(i,04)=axbx(i)*ssdcond(i,4)+psdcond(i,04)
      spdcond(i,05)=axbx(i)*ssdcond(i,5)+psdcond(i,05)
      spdcond(i,06)=axbx(i)*ssdcond(i,6)+psdcond(i,06)
      spdcond(i,07)=ayby(i)*ssdcond(i,1)+psdcond(i,07)
      spdcond(i,08)=ayby(i)*ssdcond(i,2)+psdcond(i,08)
      spdcond(i,09)=ayby(i)*ssdcond(i,3)+psdcond(i,09)
      spdcond(i,10)=ayby(i)*ssdcond(i,4)+psdcond(i,10)
      spdcond(i,11)=ayby(i)*ssdcond(i,5)+psdcond(i,11)
      spdcond(i,12)=ayby(i)*ssdcond(i,6)+psdcond(i,12)
      spdcond(i,13)=azbz(i)*ssdcond(i,1)+psdcond(i,13)
      spdcond(i,14)=azbz(i)*ssdcond(i,2)+psdcond(i,14)
      spdcond(i,15)=azbz(i)*ssdcond(i,3)+psdcond(i,15)
      spdcond(i,16)=azbz(i)*ssdcond(i,4)+psdcond(i,16)
      spdcond(i,17)=azbz(i)*ssdcond(i,5)+psdcond(i,17)
 1067 spdcond(i,18)=azbz(i)*ssdcond(i,6)+psdcond(i,18)

      do 1068 i=1,m
      grad(i,1)=spscond(i,1)*density(inddyy(i,1))*cdfits
      grad(i,2)=spscond(i,2)*density(inddyy(i,2))*cdfits
      grad(i,3)=spscond(i,3)*density(inddyy(i,3))*cdfits
      grad(i,4)=spscond(i,1)*density(inddyy(i,4))*cdfits
      grad(i,5)=spscond(i,2)*density(inddyy(i,5))*cdfits
      grad(i,6)=spscond(i,3)*density(inddyy(i,6))*cdfits
      grad(i,7)=spscond(i,1)*density(inddyy(i,7))*cdfits
      grad(i,8)=spscond(i,2)*density(inddyy(i,8))*cdfits
 1068 grad(i,9)=spscond(i,3)*density(inddyy(i,9))*cdfits

      do 1069 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,2)=zero
                              grad(i,3)=zero
                              grad(i,6)=zero
                        endif
 1069 continue

      do 1070 k=1,3
      do 1070 j=1,3
      do 1070 i=1,m
 1070 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1071 k=1,3
      do 1071 j=1,3
      do 1071 i=1,m
 1071 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

      do 2001 l=1,3

      do 1072 i=1,m
      grad(i,1)=sppcond(i,0+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,2)=sppcond(i,3+l)*density(inddyy(i,2))*cdfitp(l)
      grad(i,3)=sppcond(i,6+l)*density(inddyy(i,3))*cdfitp(l)
      grad(i,4)=sppcond(i,0+l)*density(inddyy(i,4))*cdfitp(l)
      grad(i,5)=sppcond(i,3+l)*density(inddyy(i,5))*cdfitp(l)
      grad(i,6)=sppcond(i,6+l)*density(inddyy(i,6))*cdfitp(l)
      grad(i,7)=sppcond(i,0+l)*density(inddyy(i,7))*cdfitp(l)
      grad(i,8)=sppcond(i,3+l)*density(inddyy(i,8))*cdfitp(l)
 1072 grad(i,9)=sppcond(i,6+l)*density(inddyy(i,9))*cdfitp(l)

      do 1073 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,2)=zero
                              grad(i,3)=zero
                              grad(i,6)=zero
                        endif
 1073 continue

      do 1074 k=1,3
      do 1074 j=1,3
      do 1074 i=1,m
 1074 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1075 k=1,3
      do 1075 j=1,3
      do 1075 i=1,m
 1075 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

 2001 continue

      do 2002 l=1,6

      do 1076 i=1,m
      grad(i,1)=spdcond(i,00+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,2)=spdcond(i,06+l)*density(inddyy(i,2))*cdfitd(l)
      grad(i,3)=spdcond(i,12+l)*density(inddyy(i,3))*cdfitd(l)
      grad(i,4)=spdcond(i,00+l)*density(inddyy(i,4))*cdfitd(l)
      grad(i,5)=spdcond(i,06+l)*density(inddyy(i,5))*cdfitd(l)
      grad(i,6)=spdcond(i,12+l)*density(inddyy(i,6))*cdfitd(l)
      grad(i,7)=spdcond(i,00+l)*density(inddyy(i,7))*cdfitd(l)
      grad(i,8)=spdcond(i,06+l)*density(inddyy(i,8))*cdfitd(l)
 1076 grad(i,9)=spdcond(i,12+l)*density(inddyy(i,9))*cdfitd(l)

      do 1077 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,2)=zero
                              grad(i,3)=zero
                              grad(i,6)=zero
                        endif
 1077 continue

      do 1078 k=1,3
      do 1078 j=1,3
      do 1078 i=1,m
 1078 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1079 k=1,3
      do 1079 j=1,3
      do 1079 i=1,m
 1079 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

 2002 continue

      do 1080 i=1,m
      grad(i,1)=psscond(i,1)*density(inddyy(i,1))*cdfits
      grad(i,2)=psscond(i,2)*density(inddyy(i,4))*cdfits
      grad(i,3)=psscond(i,3)*density(inddyy(i,7))*cdfits
      grad(i,4)=psscond(i,1)*density(inddyy(i,2))*cdfits
      grad(i,5)=psscond(i,2)*density(inddyy(i,5))*cdfits
      grad(i,6)=psscond(i,3)*density(inddyy(i,8))*cdfits
      grad(i,7)=psscond(i,1)*density(inddyy(i,3))*cdfits
      grad(i,8)=psscond(i,2)*density(inddyy(i,6))*cdfits
 1080 grad(i,9)=psscond(i,3)*density(inddyy(i,9))*cdfits

      do 1081 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,4)=zero
                              grad(i,7)=zero
                              grad(i,8)=zero
                        endif
 1081 continue

      do 1082 k=1,3
      do 1082 j=1,3
      do 1082 i=1,m
 1082 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1083 k=1,3
      do 1083 j=1,3
      do 1083 i=1,m
 1083 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,3*(k-1)+j)

      do 2003 l=1,3

      do 1084 i=1,m
      grad(i,1)=pspcond(i,0+l)*density(inddyy(i,1))*cdfitp(l)
      grad(i,2)=pspcond(i,3+l)*density(inddyy(i,4))*cdfitp(l)
      grad(i,3)=pspcond(i,6+l)*density(inddyy(i,7))*cdfitp(l)
      grad(i,4)=pspcond(i,0+l)*density(inddyy(i,2))*cdfitp(l)
      grad(i,5)=pspcond(i,3+l)*density(inddyy(i,5))*cdfitp(l)
      grad(i,6)=pspcond(i,6+l)*density(inddyy(i,8))*cdfitp(l)
      grad(i,7)=pspcond(i,0+l)*density(inddyy(i,3))*cdfitp(l)
      grad(i,8)=pspcond(i,3+l)*density(inddyy(i,6))*cdfitp(l)
 1084 grad(i,9)=pspcond(i,6+l)*density(inddyy(i,9))*cdfitp(l)

      do 1085 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,4)=zero
                              grad(i,7)=zero
                              grad(i,8)=zero
                        endif
 1085 continue

      do 1086 k=1,3
      do 1086 j=1,3
      do 1086 i=1,m
 1086 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1087 k=1,3
      do 1087 j=1,3
      do 1087 i=1,m
 1087 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,3*(k-1)+j)

 2003 continue

      do 2004 l=1,6

      do 1088 i=1,m
      grad(i,1)=psdcond(i,00+l)*density(inddyy(i,1))*cdfitd(l)
      grad(i,2)=psdcond(i,06+l)*density(inddyy(i,4))*cdfitd(l)
      grad(i,3)=psdcond(i,12+l)*density(inddyy(i,7))*cdfitd(l)
      grad(i,4)=psdcond(i,00+l)*density(inddyy(i,2))*cdfitd(l)
      grad(i,5)=psdcond(i,06+l)*density(inddyy(i,5))*cdfitd(l)
      grad(i,6)=psdcond(i,12+l)*density(inddyy(i,8))*cdfitd(l)
      grad(i,7)=psdcond(i,00+l)*density(inddyy(i,3))*cdfitd(l)
      grad(i,8)=psdcond(i,06+l)*density(inddyy(i,6))*cdfitd(l)
 1088 grad(i,9)=psdcond(i,12+l)*density(inddyy(i,9))*cdfitd(l)

      do 1089 i=1,m
      if(iminj(i).eq.0) then
                              grad(i,4)=zero
                              grad(i,7)=zero
                              grad(i,8)=zero
                        endif
 1089 continue

      do 1090 k=1,3
      do 1090 j=1,3
      do 1090 i=1,m
 1090 gradient(k,nc)=gradient(k,nc)-grad(i,3*(k-1)+j)

      do 1091 k=1,3
      do 1091 j=1,3
      do 1091 i=1,m
 1091 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,3*(k-1)+j)

 2004 continue

      do 1092 j=1,6
      do 1092 i=1,m
 1092 dsscond(i,j)=zero

      do 1093 j=1,18
      do 1093 i=1,m
 1093 dspcond(i,j)=zero

      do 1094 j=1,36
      do 1094 i=1,m
 1094 dsdcond(i,j)=zero

      do 1095 j=1,10
      do 1095 i=1,m
 1095 fsscond(i,j)=zero

      do 1096 j=1,30
      do 1096 i=1,m
 1096 fspcond(i,j)=zero

      do 1097 j=1,60
      do 1097 i=1,m
 1097 fsdcond(i,j)=zero

      do 1098 j=1,6
      do 1098 i=1,nn
 1098 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss0(i,j)*ttwozetaa(i)

      do 1099 j=1,18
      do 1099 i=1,nn
 1099 dspcond(iicontr(i),j)=dspcond(iicontr(i),j)+dsp0(i,j)*ttwozetaa(i)

      do 1100 j=1,36
      do 1100 i=1,nn
 1100 dsdcond(iicontr(i),j)=dsdcond(iicontr(i),j)+dsd0(i,j)*ttwozetaa(i)

      do 1101 j=1,10
      do 1101 i=1,nn
 1101 fsscond(iicontr(i),j)=fsscond(iicontr(i),j)+fss0(i,j)*ttwozetaa(i)

      do 1102 j=1,30
      do 1102 i=1,nn
 1102 fspcond(iicontr(i),j)=fspcond(iicontr(i),j)+fsp0(i,j)*ttwozetaa(i)

      do 1103 j=1,60
      do 1103 i=1,nn
 1103 fsdcond(iicontr(i),j)=fsdcond(iicontr(i),j)+fsd0(i,j)*ttwozetaa(i)

      call gradxxds1(m,axbx,ayby,azbz,dsscond,dspcond,dsdcond,fsscond,
     &               fspcond,fsdcond,dpscond,dppcond,dpdcond)

      call gradxxpp1(m,nc,iminj,inddyy,icentr,cdfits,cdfitp,cdfitd,
     &               gradient,density,dpscond,dppcond,dpdcond,grad)

      do 1104 j=1,3
      do 1104 i=1,m
 1104 psscond(i,j)=zero

      do 1105 j=1,9
      do 1105 i=1,m
 1105 pspcond(i,j)=zero

      do 1106 j=1,18
      do 1106 i=1,m
 1106 psdcond(i,j)=zero

      do 1107 j=1,6
      do 1107 i=1,m
 1107 dsscond(i,j)=zero

      do 1108 j=1,18
      do 1108 i=1,m
 1108 dspcond(i,j)=zero

      do 1109 j=1,36
      do 1109 i=1,m
 1109 dsdcond(i,j)=zero

      do 1110 j=1,10
      do 1110 i=1,m
 1110 fsscond(i,j)=zero

      do 1111 j=1,30
      do 1111 i=1,m
 1111 fspcond(i,j)=zero

      do 1112 j=1,60
      do 1112 i=1,m
 1112 fsdcond(i,j)=zero

      do 1113 j=1,3
      do 1113 i=1,nn
 1113 psscond(iicontr(i),j)=psscond(iicontr(i),j)+pss0(i,j)*ttwozetab(i)

      do 1114 j=1,9
      do 1114 i=1,nn
 1114 pspcond(iicontr(i),j)=pspcond(iicontr(i),j)+psp0(i,j)*ttwozetab(i)

      do 1115 j=1,18
      do 1115 i=1,nn
 1115 psdcond(iicontr(i),j)=psdcond(iicontr(i),j)+psd0(i,j)*ttwozetab(i)

      do 1116 j=1,6
      do 1116 i=1,nn
 1116 dsscond(iicontr(i),j)=dsscond(iicontr(i),j)+dss0(i,j)*ttwozetab(i)

      do 1117 j=1,18
      do 1117 i=1,nn
 1117 dspcond(iicontr(i),j)=dspcond(iicontr(i),j)+dsp0(i,j)*ttwozetab(i)

      do 1118 j=1,36
      do 1118 i=1,nn
 1118 dsdcond(iicontr(i),j)=dsdcond(iicontr(i),j)+dsd0(i,j)*ttwozetab(i)

      do 1119 j=1,10
      do 1119 i=1,nn
 1119 fsscond(iicontr(i),j)=fsscond(iicontr(i),j)+fss0(i,j)*ttwozetab(i)

      do 1120 j=1,30
      do 1120 i=1,nn
 1120 fspcond(iicontr(i),j)=fspcond(iicontr(i),j)+fsp0(i,j)*ttwozetab(i)

      do 1121 j=1,60
      do 1121 i=1,nn
 1121 fsdcond(iicontr(i),j)=fsdcond(iicontr(i),j)+fsd0(i,j)*ttwozetab(i)

      call gradxxpp2(m,axbx,ayby,azbz,psscond,pspcond,psdcond,dsscond,
     &               dspcond,dsdcond,fsscond,fspcond,fsdcond,ppscond,
     &               pppcond,ppdcond,dpscond,dppcond,dpdcond,pdscond,
     &               pdpcond,pddcond)

      call gradxxpp3(m,nc,iminj,inddyy,icentr,cdfits,cdfitp,cdfitd,
     &               gradient,density,pdscond,pdpcond,pddcond,grad)

 1001 continue

      return
      end
