      subroutine cdcalls(nreal,ncds,ncdspd,ndim,ilfunc,icfunc,alpha,
     &                   coeffs,coeffp,coeffd,cdsmat,cent,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*)

      dimension alpha(*),coeffs(*),coeffp(*),coeffd(*),cdsmat(ndim,*)
      dimension cent(3,*),wkvec(*)

      ntotal=ncds+10*ncdspd

      call cdovss(ncds,ndim,ilfunc,icfunc,alpha,coeffs,cdsmat,cent)

      call cdovxs(ncds,ncdspd,ndim,ilfunc,icfunc,alpha,coeffs,coeffp,
     &            coeffd,cdsmat,cent)

      call cdovxx(ncds,ncdspd,ndim,ilfunc,icfunc,alpha,coeffs,coeffp,
     &            coeffd,cdsmat,cent)

      do 1001 i=1,ntotal
      do 1001 j=1,i
 1001 cdsmat(j,i)=cdsmat(i,j)

      rewind 17

      do 1002 i=1,ntotal
 1002 call fastwr(17,cdsmat(1,i),ntotal)

      do 1003 j=1,ntotal
      do 1003 i=1,ntotal
 1003 wkvec(ntotal*(j-1)+i)=cdsmat(i,j)

      ja=1
      jb=ja+ntotal*ntotal
      jc=jb+ntotal
      jd=jc+ntotal
      je=jd+ntotal

      if((je+ntotal).gt.nreal) stop 'real overflow in cdcalls'

      call cdtran(cdsmat,wkvec(ja),wkvec(jb),wkvec(jc),wkvec(jd),
     &            wkvec(je),ntotal)

      return
      end
