      subroutine totale(nflag,ncntrt,ncd,iter,nbpc,ncentr,nalpha,nbeta,
     &                  ndim,energy,diisv,dmta,dmtb,fock,coord,charge,
     &                  coordpc,pcharge,overcd,cdcoef,dmaxdm)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension dmta(*),dmtb(*),fock(*)
      dimension coord(3,*),charge(*),coordpc(3,*),pcharge(*)
      dimension overcd(ndim,*),cdcoef(*)

      data zero,half,one,two/0.0,0.5,1.0,2.0/

      esave=energy

      energy=zero

      do 1001 i=1,ncntrt*(ncntrt+1)/2
 1001 energy=energy+(dmta(i)+dmtb(i))*fock(i)

      rewind 17

      do 1002 i=1,ncd
 1002 call fastrd(17,overcd(1,i),ncd)

      do 1003 i=1,ncd
      do 1003 j=1,ncd
 1003 energy=energy-half*cdcoef(i)*cdcoef(j)*overcd(j,i)

      do 1004 i=1,ncentr
      do 1004 j=1,i

      if(i.eq.j) goto 1004

      rrij=dist(coord(1,i),coord(1,j))
      energy=energy+charge(i)*charge(j)/rrij

 1004 continue

      if(nbpc.ne.0) then
                          do 1005 i=1,nbpc

                          do 1006 j=1,ncentr
                          rrij=dist(coord(1,j),coordpc(1,i))
 1006                     energy=energy+charge(j)*pcharge(i)/rrij

                          do 1005 j=1,i

                          if(i.eq.j) goto 1005

                          rrij=dist(coordpc(1,j),coordpc(1,i))
                          energy=energy+pcharge(j)*pcharge(i)/rrij

 1005                     continue
                    endif

      if(nflag.eq.1) then
                           write(6,1007) energy 
                           return
                     endif 

 1007 format(/,' - xc terms numerically integrated',/,
     &         ' - non-local corrections perturbatively added',
     &         ' (if requested)',//,
     &         '           gives :         total energy =',f20.10,//)

      write(6,1008) iter,energy,abs(energy-esave),dmaxdm,diisv
 1008 format(/,' cycle # ',i4,', energy = ',f16.10,5x,
     &         ' |delta E|      = ',e14.7,/,45x,
     &         ' max |delta P|  = ',e14.7,/,45x,
     &         ' diis (error)   = ',e14.7)

      return
      end
