      subroutine dipolepp(m,n,iminj,icontr,inddyy,density,zeta,px,py,pz,
     &                    pxax,pyay,pzaz,pxbx,pyby,pzbz,base,ss,ps,pp,
     &                    pso,c,c1,c2,ppcond,dipole)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iminj(*),icontr(*),inddyy(m,*)

      dimension density(*),zeta(*),px(*),py(*),pz(*),pxax(*),pyay(*),
     &          pzaz(*),pxbx(*),pyby(*),pzbz(*),base(*),ss(n,*),ps(n,*),
     &          pp(n,*),pso(n,*),c(*),c1(n,*),c2(n,*),ppcond(m,*),
     &          dipole(*)

      data zero,thrhlf,two,pi/0.0,1.5,2.0,3.1415926535898/

      do 1001 i=1,n
 1001 base(i)=base(i)*((pi/zeta(i))**thrhlf)

      do 1002 i=1,n
      pso(i,1)=pxax(i)*base(i)
      pso(i,2)=pyay(i)*base(i)
 1002 pso(i,3)=pzaz(i)*base(i)

      do 1003 i=1,n
      ss(i,1)=px(i)*base(i)
      ss(i,2)=py(i)*base(i)
 1003 ss(i,3)=pz(i)*base(i)

      do 1004 i=1,n
 1004 c(i)=base(i)/(two*zeta(i))

      do 1005 i=1,n
      ps(i,1)=pxax(i)*ss(i,1)+c(i)
      ps(i,2)=pxax(i)*ss(i,2)
      ps(i,3)=pxax(i)*ss(i,3)
      ps(i,4)=pyay(i)*ss(i,1)
      ps(i,5)=pyay(i)*ss(i,2)+c(i)
      ps(i,6)=pyay(i)*ss(i,3)
      ps(i,7)=pzaz(i)*ss(i,1)
      ps(i,8)=pzaz(i)*ss(i,2)
 1005 ps(i,9)=pzaz(i)*ss(i,3)+c(i)

      do 1006 j=1,3
      do 1006 i=1,n
 1006 c1(i,j)=ss(i,j)/(two*zeta(i))

      do 1007 j=1,3
      do 1007 i=1,n
 1007 c2(i,j)=pso(i,j)/(two*zeta(i))

      do 1008 i=1,n
      pp(i,01)=pxbx(i)*ps(i,1)+c1(i,1)+c2(i,1)
      pp(i,02)=pxbx(i)*ps(i,2)+c1(i,2)
      pp(i,03)=pxbx(i)*ps(i,3)+c1(i,3)
      pp(i,04)=pyby(i)*ps(i,1)
      pp(i,05)=pyby(i)*ps(i,2)        +c2(i,1)
      pp(i,06)=pyby(i)*ps(i,3)
      pp(i,07)=pzbz(i)*ps(i,1)
      pp(i,08)=pzbz(i)*ps(i,2)
      pp(i,09)=pzbz(i)*ps(i,3)        +c2(i,1)
      pp(i,10)=pxbx(i)*ps(i,4)        +c2(i,2)
      pp(i,11)=pxbx(i)*ps(i,5)
      pp(i,12)=pxbx(i)*ps(i,6)
      pp(i,13)=pyby(i)*ps(i,4)+c1(i,1)
      pp(i,14)=pyby(i)*ps(i,5)+c1(i,2)+c2(i,2)
      pp(i,15)=pyby(i)*ps(i,6)+c1(i,3)
      pp(i,16)=pzbz(i)*ps(i,4)
      pp(i,17)=pzbz(i)*ps(i,5)
      pp(i,18)=pzbz(i)*ps(i,6)        +c2(i,2)
      pp(i,19)=pxbx(i)*ps(i,7)        +c2(i,3)
      pp(i,20)=pxbx(i)*ps(i,8)
      pp(i,21)=pxbx(i)*ps(i,9)
      pp(i,22)=pyby(i)*ps(i,7)
      pp(i,23)=pyby(i)*ps(i,8)        +c2(i,3)
      pp(i,24)=pyby(i)*ps(i,9)
      pp(i,25)=pzbz(i)*ps(i,7)+c1(i,1)
      pp(i,26)=pzbz(i)*ps(i,8)+c1(i,2)
 1008 pp(i,27)=pzbz(i)*ps(i,9)+c1(i,3)+c2(i,3)

      do 1009 j=1,27
      do 1009 i=1,m
 1009 ppcond(i,j)=zero

      do 1010 j=1,27
      do 1010 i=1,n
 1010 ppcond(icontr(i),j)=ppcond(icontr(i),j)+pp(i,j)

      do 1011 j=1,3
      do 1011 i=1,m
      dipole(j)=dipole(j)-density(inddyy(i,1))*ppcond(i,00+j)
      dipole(j)=dipole(j)-density(inddyy(i,4))*ppcond(i,09+j)
      dipole(j)=dipole(j)-density(inddyy(i,5))*ppcond(i,12+j)
      dipole(j)=dipole(j)-density(inddyy(i,7))*ppcond(i,18+j)
      dipole(j)=dipole(j)-density(inddyy(i,8))*ppcond(i,21+j)
 1011 dipole(j)=dipole(j)-density(inddyy(i,9))*ppcond(i,24+j)

      do 1012 j=1,3
      do 1012 i=1,m
      if(iminj(i).ne.0) then

                dipole(j)=dipole(j)-density(inddyy(i,2))*ppcond(i,03+j)
                dipole(j)=dipole(j)-density(inddyy(i,3))*ppcond(i,06+j)
                dipole(j)=dipole(j)-density(inddyy(i,6))*ppcond(i,15+j)

                        endif
 1012 continue

      return
      end
