      subroutine coress(m,n,ncentr,icontr,inddyy,g,coord,charge,overlap,
     &                  core,zeta,px,py,pz,eta,base,etarr,ss,sscond,
     &                  pxcx,pycy,pzcz,u)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension icontr(*),inddyy(*)

      dimension g(*),coord(3,*),charge(*),overlap(*),core(*),zeta(*),
     &          px(*),py(*),pz(*),eta(*),base(*),etarr(*),ss(*),
     &          sscond(*),pxcx(*),pycy(*),pzcz(*),u(*)

      data zero,thrhlf,two,three,pi/0.0,1.5,2.0,3.0,3.1415926535898/

      do 1001 i=1,n
 1001 ss(i)=((pi/zeta(i))**thrhlf)*base(i)

      do 1002 i=1,m
 1002 sscond(i)=zero

      do 1003 i=1,n
 1003 sscond(icontr(i))=sscond(icontr(i))+ss(i)

      do 1004 i=1,m
 1004 overlap(inddyy(i))=overlap(inddyy(i))+sscond(i)

      do 1005 i=1,n
 1005 ss(i)=eta(i)*(three-two*etarr(i))*ss(i)

      do 1006 i=1,m
 1006 sscond(i)=zero

      do 1007 i=1,n
 1007 sscond(icontr(i))=sscond(icontr(i))+ss(i)

      do 1008 i=1,m
 1008 core(inddyy(i))=core(inddyy(i))+sscond(i)

      do 2001 nn=1,ncentr

      ccx=coord(1,nn)
      ccy=coord(2,nn)
      ccz=coord(3,nn)

      twopichrg=two*pi*charge(nn)

      do 2002 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 2002 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      do 2003 i=1,n
      call augg(1,u(i),g)
 2003 ss(i)=base(i)*g(1)*twopichrg/zeta(i)

      do 2004 i=1,m
 2004 sscond(i)=zero

      do 2005 i=1,n
 2005 sscond(icontr(i))=sscond(icontr(i))+ss(i)

      do 2006 i=1,m
 2006 core(inddyy(i))=core(inddyy(i))-sscond(i)

 2001 continue

      return
      end
