      subroutine ang194(x,y,z,weight)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xunit(194),yunit(194),zunit(194)

      dimension x(*),y(*),z(*),weight(*)

      data xunit/  1.0, -1.0,  0.0,  0.0,  0.0,  0.0,
     &             0.0,  0.0,  0.0,  0.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,
     &             0.0,  0.0,  0.0,  0.0,
     &             1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,
     &             0.0,  0.0,  0.0,  0.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0,
     &             1.0, -1.0,  1.0, -1.0,  1.0, -1.0,  1.0, -1.0/

      data yunit/  0.0,  0.0,  1.0, -1.0,  0.0,  0.0,
     &             1.0, -1.0,  1.0, -1.0,  0.0,  0.0,
     &             0.0,  0.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,
     &             0.0,  0.0,  0.0,  0.0,
     &             1.0, -1.0,  1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,
     &             0.0,  0.0,  0.0,  0.0,
     &             1.0, -1.0,  1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0, -1.0, -1.0/

      data zunit/  0.0,  0.0,  0.0,  0.0,  1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,  1.0,  1.0,
     &            -1.0, -1.0,  0.0,  0.0,  0.0,  0.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             0.0,  0.0,  0.0,  0.0,
     &             1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,
     &             0.0,  0.0,  0.0,  0.0,
     &             1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0,
     &             1.0,  1.0,  1.0,  1.0, -1.0, -1.0, -1.0, -1.0/

      data wght1,wght2,wght3,
     &     wght4,wght5,wght6,
     &     wght7,wght8,wght9/0.00178234044724,0.00571690594998,
     &                       0.00557338317884,0.00551877146727,
     &                       0.00515823771181,0.00560870408259,
     &                       0.00410677702817,0.00505184606462,
     &                       0.00553024891623/

      data vrtexa,vrtexb,
     &     vrtexc,vrtexd,
     &     vrtexe,vrtexf,
     &     vrtexg,vrtexh,
     &     vrtexi,vrtexj,
     &     vrtexk,vrtexl,
     &     vrtexm,vrtexn/0.444693317871,0.777493219315,0.289246562758,
     &                   0.912509096867,0.671297344270,0.314196994183,
     &                   0.129933544765,0.982972302707,0.938319218138,
     &                   0.345770219761,0.000000000000,0.836036015482,
     &                   0.159041710538,0.525118572443/

      data one,two,three/1.0,2.0,3.0/

      rsqrt2=one/sqrt(two)
      rsqrt3=one/sqrt(three)

      do 1001 i=1,6
 1001 weight(i)=wght1

      do 1002 i=7,18
 1002 weight(i)=wght2

      do 1003 i=19,26
 1003 weight(i)=wght3

      do 1004 i=27,50
 1004 weight(i)=wght4

      do 1005 i=51,74
 1005 weight(i)=wght5

      do 1006 i=75,98
 1006 weight(i)=wght6

      do 1007 i=99,122
 1007 weight(i)=wght7

      do 1008 i=123,146
 1008 weight(i)=wght8

      do 1009 i=147,194
 1009 weight(i)=wght9

      do 1010 i=1,6
      x(i)=xunit(i)
      y(i)=yunit(i)
 1010 z(i)=zunit(i)

      do 1011 i=7,18
      x(i)=rsqrt2*xunit(i)
      y(i)=rsqrt2*yunit(i)
 1011 z(i)=rsqrt2*zunit(i)

      do 1012 i=19,26
      x(i)=rsqrt3*xunit(i)
      y(i)=rsqrt3*yunit(i)
 1012 z(i)=rsqrt3*zunit(i)

      do 1013 i=27,34
      x(i)=vrtexa*xunit(i)
      y(i)=vrtexa*yunit(i)
 1013 z(i)=vrtexb*zunit(i)

      do 1014 i=35,42
      x(i)=vrtexa*xunit(i)
      y(i)=vrtexb*yunit(i)
 1014 z(i)=vrtexa*zunit(i)

      do 1015 i=43,50
      x(i)=vrtexb*xunit(i)
      y(i)=vrtexa*yunit(i)
 1015 z(i)=vrtexa*zunit(i)

      do 1016 i=51,58
      x(i)=vrtexc*xunit(i)
      y(i)=vrtexc*yunit(i)
 1016 z(i)=vrtexd*zunit(i)

      do 1017 i=59,66
      x(i)=vrtexc*xunit(i)
      y(i)=vrtexd*yunit(i)
 1017 z(i)=vrtexc*zunit(i)

      do 1018 i=67,74
      x(i)=vrtexd*xunit(i)
      y(i)=vrtexc*yunit(i)
 1018 z(i)=vrtexc*zunit(i)

      do 1019 i=75,82
      x(i)=vrtexe*xunit(i)
      y(i)=vrtexe*yunit(i)
 1019 z(i)=vrtexf*zunit(i)

      do 1020 i=83,90
      x(i)=vrtexe*xunit(i)
      y(i)=vrtexf*yunit(i)
 1020 z(i)=vrtexe*zunit(i)

      do 1021 i=91,98
      x(i)=vrtexf*xunit(i)
      y(i)=vrtexe*yunit(i)
 1021 z(i)=vrtexe*zunit(i)

      do 1022 i=99,106
      x(i)=vrtexg*xunit(i)
      y(i)=vrtexg*yunit(i)
 1022 z(i)=vrtexh*zunit(i)

      do 1023 i=107,114
      x(i)=vrtexg*xunit(i)
      y(i)=vrtexh*yunit(i)
 1023 z(i)=vrtexg*zunit(i)

      do 1024 i=115,122
      x(i)=vrtexh*xunit(i)
      y(i)=vrtexg*yunit(i)
 1024 z(i)=vrtexg*zunit(i)

      do 1025 i=123,126
      x(i)=vrtexi*xunit(i)
      y(i)=vrtexj*yunit(i)
 1025 z(i)=vrtexk*zunit(i)

      do 1026 i=127,130
      x(i)=vrtexi*xunit(i)
      y(i)=vrtexk*yunit(i)
 1026 z(i)=vrtexj*zunit(i)

      do 1027 i=131,134
      x(i)=vrtexk*xunit(i)
      y(i)=vrtexi*yunit(i)
 1027 z(i)=vrtexj*zunit(i)

      do 1028 i=135,138
      x(i)=vrtexj*xunit(i)
      y(i)=vrtexi*yunit(i)
 1028 z(i)=vrtexk*zunit(i)

      do 1029 i=139,142
      x(i)=vrtexj*xunit(i)
      y(i)=vrtexk*yunit(i)
 1029 z(i)=vrtexi*zunit(i)

      do 1030 i=143,146
      x(i)=vrtexk*xunit(i)
      y(i)=vrtexj*yunit(i)
 1030 z(i)=vrtexi*zunit(i)

      do 1031 i=147,154
      x(i)=vrtexl*xunit(i)
      y(i)=vrtexm*yunit(i)
 1031 z(i)=vrtexn*zunit(i)

      do 1032 i=155,162
      x(i)=vrtexl*xunit(i)
      y(i)=vrtexn*yunit(i)
 1032 z(i)=vrtexm*zunit(i)

      do 1033 i=163,170
      x(i)=vrtexm*xunit(i)
      y(i)=vrtexl*yunit(i)
 1033 z(i)=vrtexn*zunit(i)

      do 1034 i=171,178
      x(i)=vrtexm*xunit(i)
      y(i)=vrtexn*yunit(i)
 1034 z(i)=vrtexl*zunit(i)

      do 1035 i=179,186
      x(i)=vrtexn*xunit(i)
      y(i)=vrtexl*yunit(i)
 1035 z(i)=vrtexm*zunit(i)

      do 1036 i=187,194
      x(i)=vrtexn*xunit(i)
      y(i)=vrtexm*yunit(i)
 1036 z(i)=vrtexl*zunit(i)

      return
      end
